/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryBits;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.AbstractDiskRegionEntry;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.KnownVersion;

public abstract class AbstractOplogDiskRegionEntry
extends AbstractDiskRegionEntry {
    protected AbstractOplogDiskRegionEntry(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public abstract void setDiskId(RegionEntry var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePhase1(InternalRegion region, boolean clear) throws RegionClearedException {
        AbstractOplogDiskRegionEntry abstractOplogDiskRegionEntry = this;
        synchronized (abstractOplogDiskRegionEntry) {
            DiskEntry.Helper.removeFromDisk(this, region, clear);
            this._removePhase1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePhase2() {
        Object syncObj = this.getDiskId();
        if (syncObj == null) {
            syncObj = this;
        }
        DiskId diskId = syncObj;
        synchronized (diskId) {
            super.removePhase2();
        }
    }

    @Override
    public boolean fillInValue(InternalRegion region, InitialImageOperation.Entry entry, ByteArrayDataInput in, DistributionManager mgr, KnownVersion version) {
        return DiskEntry.Helper.fillInValue(this, entry, region.getDiskRegion(), region, version);
    }

    @Override
    public boolean isOverflowedToDisk(InternalRegion region, DistributedRegion.DiskPosition diskPosition) {
        return DiskEntry.Helper.isOverflowedToDisk(this, region.getDiskRegion(), diskPosition);
    }

    @Override
    public Object getValue(RegionEntryContext context) {
        return DiskEntry.Helper.faultInValue(this, (InternalRegion)context);
    }

    @Override
    public Object getValueRetain(RegionEntryContext context) {
        return DiskEntry.Helper.faultInValueRetain(this, (InternalRegion)context);
    }

    @Override
    public Object getValueInVMOrDiskWithoutFaultIn(InternalRegion region) {
        return DiskEntry.Helper.getValueInVMOrDiskWithoutFaultIn(this, region);
    }

    @Override
    public Object getValueOffHeapOrDiskWithoutFaultIn(InternalRegion region) {
        return DiskEntry.Helper.getValueOffHeapOrDiskWithoutFaultIn(this, region);
    }

    @Override
    public Object getValueOnDisk(InternalRegion region) throws EntryNotFoundException {
        return DiskEntry.Helper.getValueOnDisk(this, region.getDiskRegion());
    }

    @Override
    public Object getSerializedValueOnDisk(InternalRegion region) throws EntryNotFoundException {
        return DiskEntry.Helper.getSerializedValueOnDisk(this, region.getDiskRegion());
    }

    @Override
    public Object getValueOnDiskOrBuffer(InternalRegion region) throws EntryNotFoundException {
        return DiskEntry.Helper.getValueOnDiskOrBuffer(this, region.getDiskRegion(), region);
    }

    @Override
    public DiskEntry getPrev() {
        return this.getDiskId().getPrev();
    }

    @Override
    public DiskEntry getNext() {
        return this.getDiskId().getNext();
    }

    @Override
    public void setPrev(DiskEntry v) {
        this.getDiskId().setPrev(v);
    }

    @Override
    public void setNext(DiskEntry v) {
        this.getDiskId().setNext(v);
    }

    @Override
    public void persistConflictingTag(InternalRegion region, VersionTag tag) {
        DiskEntry.Helper.updateVersionOnly(this, region, tag);
        this.setRecentlyUsed(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        InternalRegion lr;
        DiskId did = this.getDiskId();
        boolean checkConflicts = true;
        if (did != null && (lr = (InternalRegion)cacheEvent.getRegion()) != null && lr.getDiskRegion().isReadyForRecovery()) {
            DiskId diskId = did;
            synchronized (diskId) {
                checkConflicts = !EntryBits.isRecoveredFromDisk(did.getUserBits());
            }
        }
        this.processVersionTag(cacheEvent, checkConflicts);
    }

    @Override
    public boolean isRemovedFromDisk() {
        return Token.isRemovedFromDisk(this.getValueAsToken());
    }
}

