/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.statalerts;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.internal.admin.StatAlert;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.statalerts.BaseDecoratorImpl;
import org.apache.geode.internal.admin.statalerts.FunctionHelper;

public class FunctionDecoratorImpl
extends BaseDecoratorImpl {
    private static final long serialVersionUID = -4857857489413081553L;
    protected short functorId = (short)-1;
    public static final String ID = "NonSystemFunction";

    public FunctionDecoratorImpl() {
    }

    public FunctionDecoratorImpl(StatAlertDefinition definition, short functorId) {
        super(definition);
        this.functorId = functorId;
    }

    public short getFunctionID() {
        return this.functorId;
    }

    public boolean isSystemWide() {
        return false;
    }

    @Override
    public boolean verify(StatisticsFactory factory) {
        return super.verify(factory) && -1 != this.functorId;
    }

    @Override
    public String toString() {
        return super.toString() + "Function ID:" + this.functorId + "\n";
    }

    @Override
    public boolean evaluate(Number[] params) {
        return super.evaluate(params) && this.canApplyFunction(params);
    }

    @Override
    public boolean evaluate() {
        return this.evaluate(this.getValue());
    }

    @Override
    public StatAlert evaluateAndAlert(Number[] params) {
        return this.evaluate(params) ? super.evaluateAndAlert(params) : null;
    }

    @Override
    public StatAlert evaluateAndAlert() {
        return this.evaluate() ? super.evaluateAndAlert() : null;
    }

    @Override
    public Number[] getValue() {
        return FunctionHelper.applyFunction(this.functorId, super.getValue());
    }

    @Override
    public Number[] getValue(Number[] vals) {
        return FunctionHelper.applyFunction(this.functorId, vals);
    }

    protected boolean canApplyFunction(Number[] vals) {
        return FunctionHelper.applyFunction(this.functorId, vals) != null;
    }

    @Override
    public boolean hasDecorator(String decoratorID) {
        return ID.equalsIgnoreCase(decoratorID) || super.hasDecorator(decoratorID);
    }

    @Override
    public StatAlertDefinition getDecorator(String decoratorID) {
        return ID.equalsIgnoreCase(decoratorID) ? this : super.getDecorator(decoratorID);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writePrimitiveShort(this.functorId, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.functorId = DataSerializer.readPrimitiveShort(in);
    }
}

