/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.GemFireMemberStatus;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class RefreshMemberSnapshotResponse
extends AdminResponse {
    GemFireMemberStatus snapshot;

    public static RefreshMemberSnapshotResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        RefreshMemberSnapshotResponse m = new RefreshMemberSnapshotResponse();
        m.setRecipient(recipient);
        try {
            InternalDistributedSystem sys = dm.getSystem();
            InternalCache c = (InternalCache)CacheFactory.getInstance(sys);
            m.snapshot = new GemFireMemberStatus(c);
        }
        catch (Exception ignore) {
            m.snapshot = null;
        }
        return m;
    }

    public GemFireMemberStatus getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.snapshot, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.snapshot = (GemFireMemberStatus)DataSerializer.readObject(in);
    }

    public int getDSFID() {
        return 1068;
    }

    @Override
    public String toString() {
        return "RefreshMemberSnapshotResponse from " + this.getRecipient() + " snapshot=" + this.snapshot;
    }
}

