/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.distributed.internal.FlowControlParams;
import org.apache.geode.internal.Config;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.SystemAdmin;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.util.ArgumentRedactor;

public abstract class AbstractConfig
implements Config {
    private static final String GEM_FIRE_PROPERTIES_USING_DEFAULT_VALUES = "### GemFire Properties using default values ###";
    private static final String GEM_FIRE_PROPERTIES_DEFINED_WITH_PREFIX = "### GemFire Properties defined with ";
    private static final String GEM_FIRE_PROPERTIES_DEFINED_WITH_SUFFIX = " ###";

    public String toString() {
        return super.toString();
    }

    @Override
    public String toLoggerString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printSourceSection(ConfigSource.runtime(), printWriter);
        this.printSourceSection(ConfigSource.sysprop(), printWriter);
        this.printSourceSection(ConfigSource.api(), printWriter);
        for (ConfigSource fileSource : this.getFileSources()) {
            this.printSourceSection(fileSource, printWriter);
        }
        this.printSourceSection(ConfigSource.xml(), printWriter);
        this.printSourceSection(ConfigSource.launcher(), printWriter);
        this.printSourceSection(null, printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public Map<String, String> getConfigPropsFromSource(ConfigSource source) {
        HashMap<String, String> configProps = new HashMap<String, String>();
        String[] validAttributeNames = this.getAttributeNames();
        Map<String, ConfigSource> sm = this.getAttSourceMap();
        for (String name : validAttributeNames) {
            if (source == null && sm.get(name) != null || source != null && !source.equals(sm.get(name))) continue;
            configProps.put(name, this.getAttribute(name));
        }
        return configProps;
    }

    public Map<String, String> getConfigPropsDefinedUsingFiles() {
        HashMap<String, String> configProps = new HashMap<String, String>();
        for (ConfigSource fileSource : this.getFileSources()) {
            configProps.putAll(this.getConfigPropsFromSource(fileSource));
        }
        return configProps;
    }

    @Override
    public Properties toProperties() {
        String[] attNames;
        SortedProperties result = new SortedProperties();
        for (String name : attNames = this.getAttributeNames()) {
            result.setProperty(name, this.getAttribute(name));
        }
        return result;
    }

    @Override
    public void toFile(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.toProperties().store(out, null);
        }
    }

    @Override
    public boolean sameAs(Config other) {
        String[] validAttributeNames;
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        for (String name : validAttributeNames = this.getAttributeNames()) {
            Object otherAtt;
            Object thisAtt = this.getAttributeObject(name);
            if (thisAtt == (otherAtt = other.getAttributeObject(name))) continue;
            if (thisAtt == null) {
                return false;
            }
            if (thisAtt.getClass().isArray()) {
                int otherLength;
                int thisLength = Array.getLength(thisAtt);
                if (thisLength != (otherLength = Array.getLength(otherAtt))) {
                    return false;
                }
                for (int j = 0; j < thisLength; ++j) {
                    Object otherArrObj;
                    Object thisArrObj = Array.get(thisAtt, j);
                    if (thisArrObj == (otherArrObj = Array.get(otherAtt, j))) continue;
                    if (thisArrObj == null) {
                        return false;
                    }
                    if (thisArrObj.equals(otherArrObj)) continue;
                    return false;
                }
                continue;
            }
            if (thisAtt.equals(otherAtt)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getAttribute(String name) {
        Object result = this.getAttributeObject(name);
        if (result instanceof String) {
            return (String)result;
        }
        if (name.equalsIgnoreCase("membership-port-range")) {
            int[] value = (int[])result;
            return "" + value[0] + "-" + value[1];
        }
        if (result.getClass().isArray() && name.startsWith("ssl-")) {
            return SystemAdmin.join((Object[])result, ",");
        }
        if (result.getClass().isArray()) {
            return SystemAdmin.join((Object[])result);
        }
        if (result instanceof InetAddress) {
            InetAddress addr = (InetAddress)result;
            String addrName = addr.isMulticastAddress() || !SocketCreator.resolve_dns ? addr.getHostAddress() : addr.getHostName();
            return addrName;
        }
        return result.toString();
    }

    @Override
    public ConfigSource getAttributeSource(String name) {
        return this.getAttSourceMap().get(name);
    }

    @Override
    public void setAttribute(String name, String value, ConfigSource source) {
        Object attObjectValue;
        block18: {
            Class valueType = this.getAttributeType(name);
            try {
                if (valueType.equals(String.class)) {
                    attObjectValue = value;
                    break block18;
                }
                if (valueType.equals(String[].class)) {
                    attObjectValue = StringUtils.isBlank((CharSequence)value) ? new String[]{} : value.split(",");
                    break block18;
                }
                if (valueType.equals(Integer.class)) {
                    attObjectValue = Integer.valueOf((String)value);
                    break block18;
                }
                if (valueType.equals(Long.class)) {
                    attObjectValue = Long.valueOf((String)value);
                    break block18;
                }
                if (valueType.equals(Boolean.class)) {
                    attObjectValue = Boolean.valueOf((String)value);
                    break block18;
                }
                if (valueType.equals(File.class)) {
                    attObjectValue = new File((String)value);
                    break block18;
                }
                if (valueType.equals(int[].class)) {
                    int minus = value.indexOf(45);
                    if (minus <= 0) {
                        throw new IllegalArgumentException("expected a setting in the form X-Y but found no dash for attribute " + name);
                    }
                    int[] tempValue = new int[]{Integer.parseInt(value.substring(0, minus)), Integer.parseInt(value.substring(minus + 1))};
                    attObjectValue = tempValue;
                    break block18;
                }
                if (valueType.equals(InetAddress.class)) {
                    try {
                        attObjectValue = InetAddress.getByName((String)value);
                        break block18;
                    }
                    catch (UnknownHostException ex) {
                        throw new IllegalArgumentException(String.format("%s value %s must be a valid host name. %s", name, value, ex));
                    }
                }
                if (valueType.equals(FlowControlParams.class)) {
                    int waitTime;
                    float threshold;
                    int allowance;
                    String[] values = value.split(",");
                    if (values.length != 3) {
                        throw new IllegalArgumentException(String.format("%s value %s must have three elements separated by commas", name, value));
                    }
                    try {
                        allowance = Integer.parseInt(values[0].trim());
                        threshold = Float.parseFloat(values[1].trim());
                        waitTime = Integer.parseInt(values[2].trim());
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format("%s value %s must be composed of an integer, a float, and an integer", name, value));
                    }
                    attObjectValue = new FlowControlParams(allowance, threshold, waitTime);
                    break block18;
                }
                if (valueType.isArray() && SecurableCommunicationChannel.class.equals(valueType.getComponentType())) {
                    attObjectValue = this.commaDelimitedStringToSecurableCommunicationChannels((String)value);
                    break block18;
                }
                throw new InternalGemFireException(String.format("unhandled attribute type %s for %s.", valueType, name));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("%s value %s must be a number.", name, value));
            }
        }
        this.setAttributeObject(name, attObjectValue, source);
    }

    @Override
    public String getAttributeDescription(String name) {
        this.checkAttributeName(name);
        if (!this.getAttDescMap().containsKey(name)) {
            throw new InternalGemFireException(String.format("unhandled attribute name %s.", name));
        }
        return (String)this.getAttDescMap().get(name);
    }

    protected String _getUnmodifiableMsg(String name) {
        return String.format("The %s configuration attribute can not be modified.", name);
    }

    protected abstract Map getAttDescMap();

    protected abstract Map<String, ConfigSource> getAttSourceMap();

    protected boolean _modifiableDefault() {
        return false;
    }

    protected void checkAttributeName(String name) {
        Object[] validAttNames = this.getAttributeNames();
        if (!Arrays.asList(validAttNames).contains(name.toLowerCase())) {
            throw new IllegalArgumentException(String.format("Unknown configuration attribute name %s. Valid attribute names are: %s .", name, SystemAdmin.join(validAttNames)));
        }
    }

    private List<ConfigSource> getFileSources() {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        for (ConfigSource cs : this.getAttSourceMap().values()) {
            if (cs.getType() != ConfigSource.Type.FILE && cs.getType() != ConfigSource.Type.SECURE_FILE || result.contains(cs)) continue;
            result.add(cs);
        }
        return result;
    }

    private void printSourceSection(ConfigSource source, PrintWriter printWriter) {
        String[] validAttributeNames = this.getAttributeNames();
        boolean sourceFound = false;
        Map<String, ConfigSource> sourceMap = this.getAttSourceMap();
        boolean sourceIsSecured = source != null && source.getType() == ConfigSource.Type.SECURE_FILE;
        for (String name : validAttributeNames) {
            if (source != null ? !source.equals(sourceMap.get(name)) : sourceMap.get(name) != null) continue;
            if (!sourceFound) {
                sourceFound = true;
                if (source == null) {
                    printWriter.println(GEM_FIRE_PROPERTIES_USING_DEFAULT_VALUES);
                } else {
                    printWriter.println(GEM_FIRE_PROPERTIES_DEFINED_WITH_PREFIX + source.getDescription() + GEM_FIRE_PROPERTIES_DEFINED_WITH_SUFFIX);
                }
            }
            if (name.equals("security-shiro-init")) continue;
            String attributeValueToPrint = source == null ? this.getAttribute(name) : (sourceIsSecured ? ArgumentRedactor.getRedacted() : ArgumentRedactor.redactArgumentIfNecessary(name, this.getAttribute(name)));
            printWriter.print(name);
            printWriter.print('=');
            printWriter.println(attributeValueToPrint);
        }
    }

    private SecurableCommunicationChannel[] commaDelimitedStringToSecurableCommunicationChannels(String tokenizeString) {
        StringTokenizer stringTokenizer = new StringTokenizer(tokenizeString, ",");
        SecurableCommunicationChannel[] returnArray = new SecurableCommunicationChannel[stringTokenizer.countTokens()];
        for (int i = 0; i < returnArray.length; ++i) {
            String name = stringTokenizer.nextToken();
            try {
                returnArray[i] = SecurableCommunicationChannel.getEnum(name);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return returnArray;
    }

    protected static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 7156507110684631135L;

        protected SortedProperties() {
        }

        @Override
        public synchronized Enumeration keys() {
            return Collections.enumeration(new TreeSet<Object>(this.keySet()));
        }
    }
}

