/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.Ordered;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class SortedResultSet
extends TreeSet
implements SelectResults,
Ordered,
DataSerializableFixedID {
    private static final long serialVersionUID = 5184711453750319224L;
    private ObjectType elementType;

    public SortedResultSet() {
    }

    SortedResultSet(Collection c) {
        super(c);
    }

    SortedResultSet(SelectResults sr) {
        super(sr);
        this.setElementType(sr.getCollectionType().getElementType());
    }

    SortedResultSet(ObjectType elementType) {
        this.setElementType(elementType);
    }

    SortedResultSet(Comparator c) {
        super(c);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SortedResultSet)) {
            return false;
        }
        if (!this.elementType.equals(((SortedResultSet)other).elementType)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.elementType.hashCode();
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (elementType instanceof StructType) {
            throw new IllegalArgumentException("This collection does not support struct elements");
        }
        this.elementType = elementType;
    }

    public List asList() {
        return new ArrayList(this);
    }

    public Set asSet() {
        return this;
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(SortedResultSet.class, this.elementType);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public int occurrences(Object element) {
        return this.contains(element) ? 1 : 0;
    }

    public int getDSFID() {
        return 29;
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.elementType = (ObjectType)context.getDeserializer().readObject(in);
        for (int j = size; j > 0; --j) {
            this.add(context.getDeserializer().readObject(in));
        }
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeInt(this.size());
        context.getSerializer().writeObject((Object)this.elementType, out);
        for (Object o : this) {
            context.getSerializer().writeObject(o, out);
        }
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    @Override
    public boolean dataPreordered() {
        return false;
    }
}

