/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.parse.OQLLexerTokenTypes;
import org.apache.geode.pdx.PdxInstance;

public abstract class CompiledArithmetic
extends AbstractCompiledValue
implements OQLLexerTokenTypes {
    public final CompiledValue _left;
    public final CompiledValue _right;

    CompiledArithmetic(CompiledValue left, CompiledValue right) {
        this._left = left;
        this._right = right;
    }

    @Override
    public List getChildren() {
        ArrayList<CompiledValue> list = new ArrayList<CompiledValue>();
        list.add(this._left);
        list.add(this._right);
        return list;
    }

    @Override
    public abstract int getType();

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object left = this._left.evaluate(context);
        Object right = this._right.evaluate(context);
        if (context.isCqQueryContext() && left instanceof Region.Entry) {
            left = ((Region.Entry)left).getValue();
        }
        if (context.isCqQueryContext() && right instanceof Region.Entry) {
            right = ((Region.Entry)right).getValue();
        }
        if (left == null || right == null) {
            throw new TypeMismatchException("Cannot evaluate arithmetic operations on null values");
        }
        if (!context.getCache().getPdxReadSerialized()) {
            if (left instanceof PdxInstance && !(right instanceof PdxInstance) && ((PdxInstance)left).getClassName().equals(right.getClass().getName())) {
                left = ((PdxInstance)left).getObject();
            } else if (right instanceof PdxInstance && !(left instanceof PdxInstance) && ((PdxInstance)right).getClassName().equals(left.getClass().getName())) {
                right = ((PdxInstance)right).getObject();
            }
        }
        if (!(left instanceof Number) || !(right instanceof Number)) {
            throw new TypeMismatchException("Arithmetic Operations can only be applied to numbers");
        }
        Number num1 = (Number)left;
        Number num2 = (Number)right;
        try {
            if (num1 instanceof Double) {
                if (num2 instanceof Double) {
                    return this.evaluateArithmeticOperation((Double)num1, (Double)num2);
                }
                return this.evaluateArithmeticOperation((Double)num1, num2.doubleValue());
            }
            if (num2 instanceof Double) {
                return this.evaluateArithmeticOperation(num1.doubleValue(), (Double)num2);
            }
            if (num1 instanceof Float) {
                if (num2 instanceof Float) {
                    return this.evaluateArithmeticOperation((Float)num1, (Float)num2);
                }
                return this.evaluateArithmeticOperation((Float)num1, new Float(num2.doubleValue()));
            }
            if (num2 instanceof Float) {
                return this.evaluateArithmeticOperation(new Float(num1.doubleValue()), (Float)num2);
            }
            if (num1 instanceof Long) {
                if (num2 instanceof Long) {
                    return this.evaluateArithmeticOperation((Long)num1, (Long)num2);
                }
                long l1 = num1.longValue();
                long l2 = num2.longValue();
                return this.evaluateArithmeticOperation(l1, l2);
            }
            if (num2 instanceof Long) {
                long l1 = num1.longValue();
                long l2 = num2.longValue();
                return this.evaluateArithmeticOperation(l1, l2);
            }
            if (num1 instanceof Integer) {
                if (num2 instanceof Integer) {
                    return this.evaluateArithmeticOperation((Integer)num1, (Integer)num2);
                }
                int i1 = num1.intValue();
                int i2 = num2.intValue();
                return this.evaluateArithmeticOperation(i1, i2);
            }
            if (num2 instanceof Integer) {
                int i1 = num1.intValue();
                int i2 = num2.intValue();
                return this.evaluateArithmeticOperation(i1, i2);
            }
            if (num1 instanceof Short) {
                if (num2 instanceof Short) {
                    return this.evaluateArithmeticOperation((Short)num1, (Short)num2);
                }
                short s1 = num1.shortValue();
                short s2 = num2.shortValue();
                return this.evaluateArithmeticOperation(s1, s2);
            }
            if (num2 instanceof Short) {
                short s1 = num1.shortValue();
                short s2 = num2.shortValue();
                return this.evaluateArithmeticOperation(s1, s2);
            }
        }
        catch (ArithmeticException e) {
            throw new QueryInvocationTargetException(e);
        }
        throw new TypeMismatchException("Unable to apply arithmetic operation on non number");
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        context.addDependencies(this, this._left.computeDependencies(context));
        return context.addDependencies(this, this._right.computeDependencies(context));
    }

    public abstract Double evaluateArithmeticOperation(Double var1, Double var2);

    public abstract Float evaluateArithmeticOperation(Float var1, Float var2);

    public abstract Long evaluateArithmeticOperation(Long var1, Long var2);

    public abstract Integer evaluateArithmeticOperation(Integer var1, Integer var2);

    public abstract Integer evaluateArithmeticOperation(Short var1, Short var2);
}

