/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.CacheServer;
import org.apache.geode.admin.CacheServerConfig;
import org.apache.geode.admin.CacheVm;
import org.apache.geode.admin.CacheVmConfig;
import org.apache.geode.admin.ManagedEntityConfig;
import org.apache.geode.admin.SystemMemberType;
import org.apache.geode.admin.internal.AdminDistributedSystemImpl;
import org.apache.geode.admin.internal.CacheServerConfigImpl;
import org.apache.geode.admin.internal.ManagedSystemMemberImpl;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.remote.RemoteApplicationVM;

@Deprecated
public class CacheServerImpl
extends ManagedSystemMemberImpl
implements CacheVm,
CacheServer {
    @MakeNotStatic
    private static int newCacheServers = 0;
    private final CacheServerConfigImpl config;

    public CacheServerImpl(AdminDistributedSystemImpl system, CacheVmConfig config) throws AdminException {
        super(system, config);
        this.config = (CacheServerConfigImpl)config;
        this.config.setManagedEntity(this);
    }

    public CacheServerImpl(AdminDistributedSystemImpl system, GemFireVM vm) throws AdminException {
        super(system, vm);
        this.config = new CacheServerConfigImpl(vm);
    }

    @Override
    public SystemMemberType getType() {
        return SystemMemberType.CACHE_VM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNewId() {
        Class<CacheServerImpl> clazz = CacheServerImpl.class;
        synchronized (CacheServerImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return "CacheVm" + ++newCacheServers;
        }
    }

    @Override
    public void start() throws AdminException {
        if (!this.needToStart()) {
            return;
        }
        this.config.validate();
        this.controller.start(this);
        this.config.setManagedEntity(this);
    }

    @Override
    public void stop() {
        if (!this.needToStop()) {
            return;
        }
        this.controller.stop(this);
        this.config.setManagedEntity(null);
    }

    @Override
    public boolean isRunning() {
        DistributionManager dm = ((AdminDistributedSystemImpl)this.getDistributedSystem()).getDistributionManager();
        if (dm == null) {
            try {
                return this.controller.isRunning(this);
            }
            catch (IllegalStateException e) {
                return false;
            }
        }
        return dm.getDistributionManagerIdsIncludingAdmin().contains(this.getDistributedMember());
    }

    @Override
    public CacheServerConfig getConfig() {
        return this.config;
    }

    @Override
    public CacheVmConfig getVmConfig() {
        return this.config;
    }

    @Override
    public ManagedEntityConfig getEntityConfig() {
        return this.getConfig();
    }

    @Override
    public String getEntityType() {
        return "Cache Vm";
    }

    @Override
    public String getStartCommand() {
        String classpath;
        StringBuilder sb = new StringBuilder();
        sb.append(this.controller.getProductExecutable(this, "cacheserver"));
        sb.append(" start -dir=");
        sb.append(this.getConfig().getWorkingDirectory());
        String file = this.getConfig().getCacheXMLFile();
        if (file != null && file.length() > 0) {
            sb.append(" ");
            sb.append("cache-xml-file");
            sb.append("=");
            sb.append(file);
        }
        if ((classpath = this.getConfig().getClassPath()) != null && classpath.length() > 0) {
            sb.append(" -classpath=");
            sb.append(classpath);
        }
        this.appendConfiguration(sb);
        return sb.toString().trim();
    }

    @Override
    public String getStopCommand() {
        String sb = this.controller.getProductExecutable(this, "cacheserver") + " stop -dir=" + this.getConfig().getWorkingDirectory();
        return sb.trim();
    }

    @Override
    public String getIsRunningCommand() {
        String sb = this.controller.getProductExecutable(this, "cacheserver") + " status -dir=" + this.getConfig().getWorkingDirectory();
        return sb.trim();
    }

    @Override
    public boolean isPrimaryForDurableClient(String durableClientId) {
        RemoteApplicationVM vm = (RemoteApplicationVM)this.getGemFireVM();
        boolean isPrimary = false;
        if (vm != null) {
            isPrimary = vm.isPrimaryForDurableClient(durableClientId);
        }
        return isPrimary;
    }
}

