/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.geode.datasource.PooledDataSourceFactory;

public class JdbcPooledDataSourceFactory
implements PooledDataSourceFactory {
    public DataSource createDataSource(Properties poolProperties, Properties dataSourceProperties) {
        Properties hikariProperties = this.convertToHikari(poolProperties);
        HikariConfig config = new HikariConfig(hikariProperties);
        config.setDataSourceProperties(dataSourceProperties);
        return new HikariDataSource(config);
    }

    Properties convertToHikari(Properties poolProperties) {
        int MILLIS_PER_SECOND = 1000;
        Properties result = new Properties();
        for (String name : poolProperties.stringPropertyNames()) {
            String hikariName = this.convertToCamelCase(name);
            String hikariValue = poolProperties.getProperty(name);
            if (name.equals("connection-url")) {
                hikariName = "jdbcUrl";
            } else if (name.equals("jdbc-driver-class")) {
                hikariName = "driverClassName";
            } else if (name.equals("user-name")) {
                hikariName = "username";
            } else if (name.equals("max-pool-size")) {
                hikariName = "maximumPoolSize";
            } else if (name.equals("idle-timeout-seconds")) {
                hikariName = "idleTimeout";
                hikariValue = String.valueOf(Integer.parseInt(hikariValue) * 1000);
            }
            result.setProperty(hikariName, hikariValue);
        }
        return result;
    }

    private String convertToCamelCase(String name) {
        StringBuilder nameBuilder = new StringBuilder(name.length());
        boolean capitalizeNextChar = false;
        for (char c : name.toCharArray()) {
            if (c == '-') {
                capitalizeNextChar = true;
                continue;
            }
            if (capitalizeNextChar) {
                nameBuilder.append(Character.toUpperCase(c));
            } else {
                nameBuilder.append(c);
            }
            capitalizeNextChar = false;
        }
        return nameBuilder.toString();
    }
}

