/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.CqClosedException;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqState;
import org.apache.geode.cache.query.CqStatistics;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.cq.internal.CqServiceImpl;
import org.apache.geode.cache.query.cq.internal.CqStatisticsImpl;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledRegion;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.CqQueryVsdStats;
import org.apache.geode.cache.query.internal.CqStateImpl;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class CqQueryImpl
implements InternalCqQuery {
    private static final Logger logger = LogService.getLogger();
    protected String cqName;
    protected String queryString;
    LocalRegion cqBaseRegion;
    protected Query query = null;
    InternalLogWriter securityLogWriter;
    protected CqServiceImpl cqService;
    protected String regionName;
    protected boolean isDurable = false;
    private CqStatisticsImpl cqStats;
    protected CqQueryVsdStats stats;
    protected final CqStateImpl cqState = new CqStateImpl();
    private ExecutionContext queryExecutionContext = null;
    public static TestHook testHook = null;

    public CqQueryImpl() {
    }

    public CqQueryImpl(CqServiceImpl cqService, String cqName, String queryString, boolean isDurable) {
        this.cqName = cqName;
        this.queryString = queryString;
        this.securityLogWriter = (InternalLogWriter)cqService.getCache().getSecurityLoggerI18n();
        this.cqService = cqService;
        this.isDurable = isDurable;
    }

    @Override
    public String getName() {
        return this.cqName;
    }

    @Override
    public void setName(String cqName) {
        this.cqName = cqName;
    }

    @Override
    public void setCqService(CqService cqService) {
        this.cqService = (CqServiceImpl)cqService;
    }

    @Override
    public String getRegionName() {
        return this.regionName;
    }

    void updateCqCreateStats() {
        DistributedSystem factory = this.cqService.getCache().getDistributedSystem();
        this.stats = new CqQueryVsdStats(factory, this.getServerCqName());
        this.cqStats = new CqStatisticsImpl(this);
        this.cqService.stats().incCqsStopped();
        this.cqService.stats().incCqsCreated();
        this.cqService.stats().incCqsOnClient();
    }

    void validateCq() {
        List fromClause;
        InternalCache cache = this.cqService.getInternalCache();
        DefaultQuery locQuery = (DefaultQuery)cache.getLocalQueryService().newQuery(this.queryString);
        this.query = locQuery;
        Object[] parameters = new Object[]{};
        CompiledSelect select = locQuery.getSimpleSelect();
        if (select == null) {
            throw new UnsupportedOperationException("CQ queries must be a select statement only");
        }
        if (select.isDistinct()) {
            throw new UnsupportedOperationException("select DISTINCT queries not supported in CQ");
        }
        Set<String> regionsInQuery = locQuery.getRegionsInQuery(parameters);
        if (regionsInQuery.size() > 1 || regionsInQuery.size() < 1) {
            throw new UnsupportedOperationException("CQ queries must reference one and only one region");
        }
        this.regionName = regionsInQuery.iterator().next();
        HashSet regions = new HashSet();
        CompiledValue whereClause = select.getWhereClause();
        if (whereClause != null) {
            whereClause.getRegionsInQuery(regions, parameters);
            if (!regions.isEmpty()) {
                throw new UnsupportedOperationException("The WHERE clause in CQ queries cannot refer to a region");
            }
        }
        if ((fromClause = select.getIterators()).size() > 1) {
            throw new UnsupportedOperationException("CQ queries cannot have more than one iterator in the FROM clause");
        }
        CompiledIteratorDef itrDef = (CompiledIteratorDef)fromClause.get(0);
        if (!(itrDef.getCollectionExpr() instanceof CompiledRegion)) {
            throw new UnsupportedOperationException("CQ queries must have a region path only as the first iterator in the FROM clause");
        }
        List projs = select.getProjectionAttributes();
        if (projs != null) {
            throw new UnsupportedOperationException("CQ queries do not support projections");
        }
        List<CompiledSortCriterion> orderBys = select.getOrderByAttrs();
        if (orderBys != null) {
            throw new UnsupportedOperationException("CQ queries do not support ORDER BY");
        }
        this.setQueryExecutionContext(new QueryExecutionContext(null, (InternalCache)this.cqService.getCache(), true));
    }

    void removeFromCqMap() throws CqException {
        try {
            this.cqService.removeCq(this.getServerCqName());
        }
        catch (Exception ex) {
            String errMsg = "Failed to remove Continuous Query From the repository. CqName: %s Error : %s";
            Object[] errMsgArgs = new Object[]{this.cqName, ex.getLocalizedMessage()};
            String msg = String.format(errMsg, errMsgArgs);
            logger.error(msg);
            throw new CqException(msg, ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Removed CQ from the CQ repository. CQ Name: {}", (Object)this.cqName);
        }
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public CqStatistics getStatistics() {
        return this.cqStats;
    }

    @Override
    public LocalRegion getCqBaseRegion() {
        return this.cqBaseRegion;
    }

    protected abstract void cleanup() throws CqException;

    String getBaseRegionName() {
        return this.regionName;
    }

    @Override
    public abstract String getServerCqName();

    @Override
    public CqState getState() {
        return this.cqState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCqState(int state) {
        if (this.isClosed()) {
            throw new CqClosedException(String.format("CQ is closed, CqName : %s", this.cqName));
        }
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (state == 1) {
                this.cqState.setState(1);
                this.cqService.stats().incCqsActive();
                this.cqService.stats().decCqsStopped();
            } else if (state == 0) {
                this.cqState.setState(0);
                this.cqService.stats().incCqsStopped();
                this.cqService.stats().decCqsActive();
            } else if (state == 3) {
                this.cqState.setState(state);
            }
        }
    }

    void updateStats(CqEvent cqEvent) {
        this.stats.updateStats(cqEvent);
    }

    @Override
    public boolean isRunning() {
        return this.cqState.isRunning();
    }

    @Override
    public boolean isStopped() {
        return this.cqState.isStopped();
    }

    @Override
    public boolean isClosed() {
        return this.cqState.isClosed();
    }

    public boolean isClosing() {
        return this.cqState.isClosing();
    }

    @Override
    public boolean isDurable() {
        return this.isDurable;
    }

    @Override
    public CqQueryVsdStats getVsdStats() {
        return this.stats;
    }

    ExecutionContext getQueryExecutionContext() {
        return this.queryExecutionContext;
    }

    private void setQueryExecutionContext(ExecutionContext queryExecutionContext) {
        this.queryExecutionContext = queryExecutionContext;
    }

    public static interface TestHook {
        public void pauseUntilReady();

        public void ready();

        public int numQueuedEvents();

        public void setEventCount(int var1);
    }
}

