---
title: "Overview"
weight: 1
type: docs
aliases:
- /connectors/pipeline-connectors/overview
---
<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# Connectors

Flink CDC provides several source and sink connectors to interact with external
systems. You can use these connectors out-of-box, by adding released JARs to
your Flink CDC environment, and specifying the connector in your YAML pipeline
definition.

## Supported Connectors

| Connector                                                                        | Supported Type | External System                                                                                                                                                                                                                                                                                                                                                                                        | Download Page                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
|----------------------------------------------------------------------------------|----------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Apache Doris]({{< ref "docs/connectors/pipeline-connectors/doris" >}})          | Sink           | <li> [Apache Doris](https://doris.apache.org/): 1.2.x, 2.x.x, 3.x.x                                                                                                                                                                                                                                                                                                                                    | [3.3.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-doris/3.3.0/flink-cdc-pipeline-connector-doris-3.3.0.jar), [3.2.1](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-doris/3.2.1/flink-cdc-pipeline-connector-doris-3.2.1.jar), [3.2.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-doris/3.2.0/flink-cdc-pipeline-connector-doris-3.2.0.jar), [3.1.1](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-doris/3.1.1/flink-cdc-pipeline-connector-doris-3.1.1.jar), [3.1.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-doris/3.1.0/flink-cdc-pipeline-connector-doris-3.1.0.jar)                                         |
| [Elasticsearch]({{< ref "docs/connectors/pipeline-connectors/elasticsearch" >}}) | Sink           | <li> [Elasticsearch](https://www.elastic.co/elasticsearch): 6.x, 7.x, 8.x                                                                                                                                                                                                                                                                                                                              | [3.3.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-elasticsearch/3.3.0/flink-cdc-pipeline-connector-elasticsearch-3.3.0.jar)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [Kafka]({{< ref "docs/connectors/pipeline-connectors/kafka" >}})                 | Sink           | <li> [Kafka](https://kafka.apache.org/)                                                                                                                                                                                                                                                                                                                                                                | [3.3.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-kafka/3.3.0/flink-cdc-pipeline-connector-kafka-3.3.0.jar), [3.2.1](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-kafka/3.2.1/flink-cdc-pipeline-connector-kafka-3.2.1.jar), [3.2.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-kafka/3.2.0/flink-cdc-pipeline-connector-kafka-3.2.0.jar), [3.1.1](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-kafka/3.1.1/flink-cdc-pipeline-connector-kafka-3.1.1.jar), [3.1.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-kafka/3.1.0/flink-cdc-pipeline-connector-kafka-3.1.0.jar)                                         |
| [MySQL]({{< ref "docs/connectors/pipeline-connectors/mysql" >}})                 | Source         | <li> [MySQL](https://dev.mysql.com/doc): 5.6, 5.7, 8.0.x <li> [RDS MySQL](https://www.aliyun.com/product/rds/mysql): 5.6, 5.7, 8.0.x <li> [PolarDB MySQL](https://www.aliyun.com/product/polardb): 5.6, 5.7, 8.0.x <li> [Aurora MySQL](https://aws.amazon.com/cn/rds/aurora): 5.6, 5.7, 8.0.x <li> [MariaDB](https://mariadb.org): 10.x <li> [PolarDB X](https://github.com/ApsaraDB/galaxysql): 2.0.1 | [3.3.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-mysql/3.3.0/flink-cdc-pipeline-connector-mysql-3.3.0.jar), [3.2.1](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-mysql/3.2.1/flink-cdc-pipeline-connector-mysql-3.2.1.jar), [3.2.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-mysql/3.2.0/flink-cdc-pipeline-connector-mysql-3.2.0.jar), [3.1.1](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-mysql/3.1.1/flink-cdc-pipeline-connector-mysql-3.1.1.jar), [3.1.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-mysql/3.1.0/flink-cdc-pipeline-connector-mysql-3.1.0.jar)                                         |
| [OceanBase]({{< ref "docs/connectors/pipeline-connectors/oceanbase" >}})         | Sink           | <li> [OceanBase](https://www.oceanbase.com/): 3.x, 4.x                                                                                                                                                                                                                                                                                                                                                 | [3.3.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-oceanbase/3.3.0/flink-cdc-pipeline-connector-oceanbase-3.3.0.jar)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [Paimon]({{< ref "docs/connectors/pipeline-connectors/paimon" >}})               | Sink           | <li> [Paimon](https://paimon.apache.org/): 0.6, 0.7, 0.8, 0.9, 1.0                                                                                                                                                                                                                                                                                                                                     | [3.3.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-paimon/3.3.0/flink-cdc-pipeline-connector-paimon-3.3.0.jar), [3.2.1](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-paimon/3.2.1/flink-cdc-pipeline-connector-paimon-3.2.1.jar), [3.2.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-paimon/3.2.0/flink-cdc-pipeline-connector-paimon-3.2.0.jar), [3.1.1](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-paimon/3.1.1/flink-cdc-pipeline-connector-paimon-3.1.1.jar), [3.1.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-paimon/3.1.0/flink-cdc-pipeline-connector-paimon-3.1.0.jar)                               |
| [StarRocks]({{< ref "docs/connectors/pipeline-connectors/starrocks" >}})         | Sink           | <li> [StarRocks](https://www.starrocks.io/): 2.x, 3.x                                                                                                                                                                                                                                                                                                                                                  | [3.3.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-starrocks/3.3.0/flink-cdc-pipeline-connector-starrocks-3.3.0.jar), [3.2.1](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-starrocks/3.2.1/flink-cdc-pipeline-connector-starrocks-3.2.1.jar), [3.2.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-starrocks/3.2.0/flink-cdc-pipeline-connector-starrocks-3.2.0.jar), [3.1.1](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-starrocks/3.1.1/flink-cdc-pipeline-connector-starrocks-3.1.1.jar), [3.1.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-starrocks/3.1.0/flink-cdc-pipeline-connector-starrocks-3.1.0.jar) |
| [MaxCompute]({{< ref "docs/connectors/pipeline-connectors/maxcompute" >}})       | Sink           | <li> [MaxCompute](https://www.aliyun.com/product/maxcompute)                                                                                                                                                                                                                                                                                                                                           | [3.3.0](https://repo1.maven.org/maven2/org/apache/flink/flink-cdc-pipeline-connector-maxcompute/3.3.0/flink-cdc-pipeline-connector-maxcompute-3.3.0.jar)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                                                                                             |


## Supported Flink Versions
The following table shows the version mapping between Flink<sup>®</sup> CDC Pipeline Connectors and Flink<sup>®</sup>

|    Flink<sup>®</sup> CDC Version    |                                                        Flink<sup>®</sup> Version                                                         | Pipeline Source |                          Pipeline Sink                          |                   Notes                   |
|:-----------------------------------:|:----------------------------------------------------------------------------------------------------------------------------------------:|:---------------:|:---------------------------------------------------------------:|:-----------------------------------------:|
| <font color="DarkCyan">3.0.x</font> |                        <font color="MediumVioletRed">1.17.\*</font>, <font color="MediumVioletRed">1.18.\*</font>                        |      Mysql      |                         StarRocks,Doris                         |                                           |
| <font color="DarkCyan">3.1.x</font> | <font color="MediumVioletRed">1.17.\*</font>, <font color="MediumVioletRed">1.18.\*</font>, <font color="MediumVioletRed">1.19.\*</font> |      Mysql      |                  StarRocks,Doris,Paimon,Kafka                   | only flink-cdc 3.1.1 support flink 1.19.* |
| <font color="DarkCyan">3.2.x</font> | <font color="MediumVioletRed">1.17.\*</font>, <font color="MediumVioletRed">1.18.\*</font>, <font color="MediumVioletRed">1.19.\*</font> |      Mysql      |           StarRocks,Doris,Paimon,Kafka,ElasticSearch            |                                           |
| <font color="DarkCyan">3.3.x</font> |                        <font color="MediumVioletRed">1.19.\*</font>, <font color="MediumVioletRed">1.20.\*</font>                        |      Mysql      | StarRocks,Doris,Paimon,Kafka,ElasticSearch,OceanBase,MaxCompute |                                           |
| <font color="DarkCyan">3.4.x</font> |                        <font color="MediumVioletRed">1.19.\*</font>, <font color="MediumVioletRed">1.20.\*</font>                        |      Mysql      | StarRocks,Doris,Paimon,Kafka,ElasticSearch,OceanBase,MaxCompute |                                           |


## Develop Your Own Connector

If provided connectors cannot fulfill your requirement, you can always develop
your own connector to get your external system involved in Flink CDC pipelines.
Check out [Flink CDC APIs]({{< ref "docs/developer-guide/understand-flink-cdc-api" >}})
to learn how to develop your own connectors.

{{< top >}}
