/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterTableOperation;

@Internal
public class AlterTableRenameOperation
extends AlterTableOperation {
    private final ObjectIdentifier newTableIdentifier;

    public AlterTableRenameOperation(ObjectIdentifier tableIdentifier, ObjectIdentifier newTableIdentifier, boolean ignoreIfNotExists) {
        super(tableIdentifier, ignoreIfNotExists);
        this.newTableIdentifier = newTableIdentifier;
    }

    public ObjectIdentifier getNewTableIdentifier() {
        return this.newTableIdentifier;
    }

    @Override
    public String asSummaryString() {
        return String.format("ALTER TABLE %s%s RENAME TO %s", this.ignoreIfTableNotExists ? "IF EXISTS " : "", this.tableIdentifier.asSummaryString(), this.newTableIdentifier.asSummaryString());
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        Catalog catalog = ctx.getCatalogManager().getCatalogOrThrowException(this.getTableIdentifier().getCatalogName());
        try {
            catalog.renameTable(this.getTableIdentifier().toObjectPath(), this.getNewTableIdentifier().getObjectName(), this.ignoreIfTableNotExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (TableAlreadyExistException | TableNotExistException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

