/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.ShowCreateUtil;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ShowOperation;

@Internal
public class ShowCreateViewOperation
implements ShowOperation {
    private final ObjectIdentifier viewIdentifier;

    public ShowCreateViewOperation(ObjectIdentifier sqlIdentifier) {
        this.viewIdentifier = sqlIdentifier;
    }

    public ObjectIdentifier getViewIdentifier() {
        return this.viewIdentifier;
    }

    @Override
    public String asSummaryString() {
        return String.format("SHOW CREATE VIEW %s", this.viewIdentifier.asSummaryString());
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ContextResolvedTable table = ctx.getCatalogManager().getTable(this.viewIdentifier).orElseThrow(() -> new ValidationException(String.format("Could not execute SHOW CREATE VIEW. View with identifier %s does not exist.", this.viewIdentifier.asSerializableString())));
        String resultRow = ShowCreateUtil.buildShowCreateViewRow(table.getResolvedTable(), this.viewIdentifier, table.isTemporary());
        return TableResultUtils.buildStringArrayResult("result", new String[]{resultRow});
    }
}

