/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.runtime.dto.FailedDTOHolder;
import org.osgi.framework.ServiceReference;

public class FailureStateHandler {
    private final Map<AbstractInfo<?>, FailureStatus> serviceFailures = new ConcurrentHashMap();

    public void clear() {
        this.serviceFailures.clear();
    }

    public void addFailure(AbstractInfo<?> info, int reason, Exception ex) {
        this.addFailure(info, 0L, reason, ex);
    }

    public void addFailure(AbstractInfo<?> info, int reason) {
        this.addFailure(info, 0L, reason);
    }

    public void addFailure(AbstractInfo<?> info, long contextId, int reason) {
        this.addFailure(info, contextId, reason, null);
    }

    public void addFailure(AbstractInfo<?> info, long contextId, int reason, Exception ex) {
        Set<Long> contexts;
        String type = info.getType();
        ServiceReference<?> ref = info.getServiceReference();
        Object serviceInfo = ref == null ? " with id " + String.valueOf(info.getServiceId()) : "";
        if (reason == 1) {
            SystemLogger.LOGGER.debug(SystemLogger.formatMessage(ref, "Ignoring unmatching " + type + " service" + (String)serviceInfo));
        } else if (reason == 3) {
            SystemLogger.LOGGER.debug(SystemLogger.formatMessage(ref, "Ignoring shadowed " + type + " service" + (String)serviceInfo));
        } else if (reason == 5) {
            SystemLogger.LOGGER.error(SystemLogger.formatMessage(ref, "Ignoring ungettable " + type + " service" + (String)serviceInfo), (Throwable)ex);
        } else if (reason == 6) {
            SystemLogger.LOGGER.debug(SystemLogger.formatMessage(ref, "Ignoring invalid " + type + " service" + (String)serviceInfo));
        } else if (reason == 1) {
            SystemLogger.LOGGER.debug(SystemLogger.formatMessage(ref, "Ignoring unmatched " + type + " service" + (String)serviceInfo));
        } else if (reason == 2) {
            SystemLogger.LOGGER.debug(SystemLogger.formatMessage(ref, "Servlet context " + String.valueOf(contextId) + " failure: Ignoring " + type + " service" + (String)serviceInfo));
        } else if (reason == 0) {
            SystemLogger.LOGGER.error(SystemLogger.formatMessage(ref, "Exception while registering " + type + " service" + (String)serviceInfo), (Throwable)ex);
        }
        FailureStatus status = this.serviceFailures.get(info);
        if (status == null) {
            status = new FailureStatus();
            this.serviceFailures.put(info, status);
        }
        contexts = (contexts = status.reasonToContextsMapping.get(reason)) == null ? new HashSet<Long>() : new HashSet<Long>(contexts);
        contexts.add(contextId);
        status.reasonToContextsMapping.put(reason, contexts);
    }

    public boolean remove(AbstractInfo<?> info) {
        return this.remove(info, 0L);
    }

    public boolean removeAll(AbstractInfo<?> info) {
        boolean result = this.remove(info, 0L);
        this.serviceFailures.remove(info);
        return result;
    }

    public boolean remove(AbstractInfo<?> info, long contextId) {
        FailureStatus status = this.serviceFailures.get(info);
        if (status != null) {
            Iterator<Map.Entry<Integer, Set<Long>>> i = status.reasonToContextsMapping.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Integer, Set<Long>> entry = i.next();
                if (!entry.getValue().contains(contextId)) continue;
                if (entry.getValue().size() == 1) {
                    i.remove();
                } else {
                    HashSet set = new HashSet(entry.getValue());
                    set.remove(contextId);
                    entry.setValue(set);
                }
                return true;
            }
        }
        return false;
    }

    public void getRuntimeInfo(FailedDTOHolder failedDTOHolder) {
        for (Map.Entry<AbstractInfo<?>, FailureStatus> entry : this.serviceFailures.entrySet()) {
            for (Map.Entry<Integer, Set<Long>> status : entry.getValue().reasonToContextsMapping.entrySet()) {
                for (long contextId : status.getValue()) {
                    failedDTOHolder.add(entry.getKey(), contextId, status.getKey());
                }
            }
        }
    }

    private static final class FailureStatus {
        public final Map<Integer, Set<Long>> reasonToContextsMapping = new ConcurrentHashMap<Integer, Set<Long>>();

        private FailureStatus() {
        }
    }
}

