/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.executor.async;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.core.impl.executor.ExecutionResult;
import org.apache.felix.hc.core.impl.executor.HealthCheckExecutorThreadPool;
import org.apache.felix.hc.core.impl.executor.HealthCheckFuture;
import org.apache.felix.hc.core.impl.executor.HealthCheckResultCache;
import org.apache.felix.hc.core.impl.scheduling.AsyncIntervalJob;
import org.apache.felix.hc.core.impl.scheduling.AsyncJob;
import org.apache.felix.hc.core.impl.scheduling.CronJobFactory;
import org.apache.felix.hc.core.impl.util.HealthCheckFilter;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AsyncHealthCheckExecutor.class}, immediate=true)
public class AsyncHealthCheckExecutor
implements ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncHealthCheckExecutor.class);
    private Map<HealthCheckMetadata, ExecutionResult> asyncResultsByDescriptor = new ConcurrentHashMap<HealthCheckMetadata, ExecutionResult>();
    private Map<HealthCheckMetadata, AsyncJob> registeredJobs = new HashMap<HealthCheckMetadata, AsyncJob>();
    private BundleContext bundleContext;
    @Reference
    HealthCheckExecutorThreadPool healthCheckExecutorThreadPool;
    @Reference
    CronJobFactory cronJobFactory;

    @Activate
    protected final void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        ServiceReference<HealthCheck>[] healthCheckReferences;
        this.bundleContext = bundleContext;
        this.bundleContext.addServiceListener((ServiceListener)this, "(objectclass=" + HealthCheck.class.getName() + ")");
        int count = 0;
        HealthCheckFilter healthCheckFilter = new HealthCheckFilter(bundleContext);
        for (ServiceReference<HealthCheck> serviceReference : healthCheckReferences = healthCheckFilter.getHealthCheckServiceReferences(HealthCheckSelector.empty(), false)) {
            HealthCheckMetadata healthCheckMetadata = new HealthCheckMetadata(serviceReference);
            if (!this.isAsync(healthCheckMetadata) || !this.scheduleHealthCheck(healthCheckMetadata)) continue;
            ++count;
        }
        LOG.debug("Scheduled {} jobs for asynchronous health checks during bundle startup", (Object)count);
    }

    @Deactivate
    protected final void deactivate() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.bundleContext = null;
        LOG.debug("Unscheduling {} jobs for asynchronous health checks", (Object)this.registeredJobs.size());
        for (HealthCheckMetadata healthCheckDescriptor : new LinkedList<HealthCheckMetadata>(this.registeredJobs.keySet())) {
            this.unscheduleHealthCheck(healthCheckDescriptor);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.bundleContext == null) {
            return;
        }
        ServiceReference serviceReference = event.getServiceReference();
        boolean isHealthCheck = serviceReference.isAssignableTo(this.bundleContext.getBundle(), HealthCheck.class.getName());
        if (isHealthCheck) {
            HealthCheckMetadata healthCheckMetadata = new HealthCheckMetadata(serviceReference);
            int eventType = event.getType();
            if (eventType == 1) {
                LOG.debug("Received service event REGISTERED for health check {}", (Object)healthCheckMetadata);
                this.scheduleHealthCheck(healthCheckMetadata);
            } else if (eventType == 4) {
                LOG.debug("Received service event UNREGISTERING for health check {}", (Object)healthCheckMetadata);
                this.unscheduleHealthCheck(healthCheckMetadata);
            } else if (eventType == 2) {
                LOG.debug("Received service event MODIFIED for health check {}", (Object)healthCheckMetadata);
                this.unscheduleHealthCheck(healthCheckMetadata);
                this.scheduleHealthCheck(healthCheckMetadata);
            }
        }
    }

    private boolean scheduleHealthCheck(HealthCheckMetadata descriptor) {
        try {
            AsyncJob healthCheckAsyncJob = null;
            if (this.isAsyncCron(descriptor)) {
                healthCheckAsyncJob = this.cronJobFactory.createAsyncCronJob(this.getAsyncJob(descriptor), "job-hc-" + descriptor.getTitle().replaceAll("\\s+", "-"), "async-healthchecks", descriptor.getAsyncCronExpression());
            } else if (this.isAsyncInterval(descriptor)) {
                healthCheckAsyncJob = new AsyncIntervalJob(this.getAsyncJob(descriptor), this.healthCheckExecutorThreadPool, descriptor.getAsyncIntervalInSec());
            }
            if (healthCheckAsyncJob != null) {
                healthCheckAsyncJob.schedule();
                this.registeredJobs.put(descriptor, healthCheckAsyncJob);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOG.warn("Could not schedule async health check for " + descriptor + ". Exception: " + e, (Throwable)e);
            return false;
        }
    }

    private Runnable getAsyncJob(final HealthCheckMetadata descriptor) {
        return new Runnable(){

            @Override
            public void run() {
                LOG.debug("Running job {}", (Object)this);
                HealthCheckFuture healthCheckFuture = new HealthCheckFuture(descriptor, AsyncHealthCheckExecutor.this.bundleContext, new HealthCheckFuture.Callback(){

                    @Override
                    public void finished(HealthCheckExecutionResult result) {
                        AsyncHealthCheckExecutor.this.updateWith(result);
                    }
                });
                healthCheckFuture.run();
            }

            public String toString() {
                return descriptor.toString();
            }
        };
    }

    private boolean unscheduleHealthCheck(HealthCheckMetadata descriptor) {
        AsyncJob job = this.registeredJobs.remove(descriptor);
        if (job != null) {
            return job.unschedule();
        }
        LOG.debug("No job was unregistered for descriptor {}", (Object)descriptor);
        return false;
    }

    public void collectAsyncResults(List<HealthCheckMetadata> healthCheckDescriptors, Collection<HealthCheckExecutionResult> results, HealthCheckResultCache cache) {
        Iterator<HealthCheckMetadata> checksIt = healthCheckDescriptors.iterator();
        TreeSet<ExecutionResult> asyncResults = new TreeSet<ExecutionResult>();
        while (checksIt.hasNext()) {
            HealthCheckMetadata healthCheckMetadata = checksIt.next();
            if (!this.isAsync(healthCheckMetadata)) continue;
            ExecutionResult result = this.asyncResultsByDescriptor.get(healthCheckMetadata);
            if (result == null) {
                result = this.handleMissingResult(healthCheckMetadata);
            }
            asyncResults.add(result);
            checksIt.remove();
        }
        LOG.debug("Caching {} results from async results", (Object)asyncResults.size());
        for (ExecutionResult result : asyncResults) {
            cache.updateWith(result);
        }
        LOG.debug("Adding {} results from async results", (Object)asyncResults.size());
        results.addAll(asyncResults);
    }

    private ExecutionResult handleMissingResult(HealthCheckMetadata healthCheckMetadata) {
        ExecutionResult result = this.isAsyncCron(healthCheckMetadata) ? (this.registeredJobs.containsKey(healthCheckMetadata) ? new ExecutionResult(healthCheckMetadata, new Result(Result.Status.OK, "Async Health Check with cron expression '" + healthCheckMetadata.getAsyncCronExpression() + "' has not yet been executed."), 0L) : new ExecutionResult(healthCheckMetadata, new Result(Result.Status.WARN, "Async Health Check with cron expression '" + healthCheckMetadata.getAsyncCronExpression() + "' is never executed because of misconfiguration."), 0L)) : new ExecutionResult(healthCheckMetadata, new Result(Result.Status.OK, "Async Health Check with interval '" + healthCheckMetadata.getAsyncIntervalInSec() + "' has not yet been executed."), 0L);
        return result;
    }

    public void updateWith(HealthCheckExecutionResult result) {
        if (this.isAsync(result.getHealthCheckMetadata())) {
            this.asyncResultsByDescriptor.put(result.getHealthCheckMetadata(), (ExecutionResult)result);
            LOG.debug("Updated result for async hc {} with {}", (Object)result.getHealthCheckMetadata(), (Object)result);
        }
    }

    private boolean isAsync(HealthCheckMetadata healthCheckMetadata) {
        return this.isAsyncCron(healthCheckMetadata) || this.isAsyncInterval(healthCheckMetadata);
    }

    private boolean isAsyncCron(HealthCheckMetadata healthCheckMetadata) {
        return StringUtils.isNotBlank(healthCheckMetadata.getAsyncCronExpression());
    }

    private boolean isAsyncInterval(HealthCheckMetadata healthCheckMetadata) {
        return healthCheckMetadata.getAsyncIntervalInSec() != null && healthCheckMetadata.getAsyncIntervalInSec() > 0L;
    }
}

