/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.executor;

import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.core.impl.executor.ExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempUnavailableGracePeriodEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(TempUnavailableGracePeriodEvaluator.class);
    private final Map<Long, Date> firstTempUnavailableDateByServiceId = new ConcurrentHashMap<Long, Date>();
    private final long temporarilyAvailableGracePeriodInMs;

    public TempUnavailableGracePeriodEvaluator(long temporarilyAvailableGracePeriodInMs) {
        this.temporarilyAvailableGracePeriodInMs = temporarilyAvailableGracePeriodInMs;
        LOG.debug("Configured temporarilyAvailableGracePeriodInMs: {}", (Object)temporarilyAvailableGracePeriodInMs);
    }

    void updateTemporarilyUnavailableTimestampWith(HealthCheckExecutionResult result) {
        ExecutionResult executionResult = (ExecutionResult)result;
        if (executionResult.getHealthCheckResult().getStatus() == Result.Status.TEMPORARILY_UNAVAILABLE) {
            if (!this.firstTempUnavailableDateByServiceId.containsKey(executionResult.getServiceId())) {
                this.firstTempUnavailableDateByServiceId.put(executionResult.getServiceId(), executionResult.getFinishedAt());
            }
        } else {
            this.firstTempUnavailableDateByServiceId.remove(executionResult.getServiceId());
        }
    }

    void evaluateGracePeriodForTemporarilyUnavailableResults(List<HealthCheckExecutionResult> results) {
        ListIterator<HealthCheckExecutionResult> resultsIt = results.listIterator();
        while (resultsIt.hasNext()) {
            Date firstTempUnavailableDate;
            ExecutionResult executionResult = (ExecutionResult)resultsIt.next();
            if (executionResult.getHealthCheckResult().getStatus() != Result.Status.TEMPORARILY_UNAVAILABLE || (firstTempUnavailableDate = this.firstTempUnavailableDateByServiceId.get(executionResult.getServiceId())) == null) continue;
            long timestampForCritical = firstTempUnavailableDate.getTime() + this.temporarilyAvailableGracePeriodInMs;
            if (executionResult.getFinishedAt().getTime() < timestampForCritical) continue;
            ResultLog resultLog = new ResultLog();
            for (ResultLog.Entry entry : executionResult.getHealthCheckResult()) {
                resultLog.add(entry);
            }
            resultLog.add(new ResultLog.Entry(Result.Status.CRITICAL, "Grace period for being temporarily unavailable exceeded by " + FormattingResultLog.msHumanReadable((long)(executionResult.getFinishedAt().getTime() - timestampForCritical)) + " (configured grace period: " + FormattingResultLog.msHumanReadable((long)this.temporarilyAvailableGracePeriodInMs) + ")"));
            executionResult = new ExecutionResult(executionResult.getHealthCheckMetadata(), new Result(resultLog), executionResult.getFinishedAt(), executionResult.getElapsedTimeInMs(), false);
            resultsIt.set(executionResult);
        }
    }

    public String toString() {
        return "[TempUnavailableGracePeriodTester count checks currently TEMPORARILY_UNAVAILABLE: " + this.firstTempUnavailableDateByServiceId.size() + "]";
    }
}

