/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Processor;
import aQute.lib.collections.ExtList;
import aQute.lib.spring.SpringXMLType;
import aQute.libg.generics.Create;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.felix.bundleplugin.BlueprintPlugin;
import org.apache.felix.bundleplugin.DependencyEmbedder;
import org.apache.felix.bundleplugin.DependencyExcluder;
import org.apache.felix.bundleplugin.JarPluginConfiguration;
import org.apache.felix.bundleplugin.JpaPlugin;
import org.apache.felix.bundleplugin.ManifestPlugin;
import org.apache.felix.bundleplugin.ManifestWriter;
import org.apache.felix.bundleplugin.RelativizePath;
import org.apache.maven.archiver.ManifestSection;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.osgi.DefaultMaven2OsgiConverter;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="bundle", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class BundlePlugin
extends AbstractMojo {
    @Parameter(property="manifestLocation", defaultValue="${project.build.outputDirectory}/META-INF")
    protected File manifestLocation;
    @Parameter(property="niceManifest", defaultValue="false")
    protected boolean niceManifest;
    @Parameter(property="dumpInstructions")
    protected File dumpInstructions;
    @Parameter(property="dumpClasspath")
    protected File dumpClasspath;
    @Parameter(property="unpackBundle")
    protected boolean unpackBundle;
    @Parameter(property="excludeDependencies")
    protected String excludeDependencies;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter
    protected String classifier;
    @Parameter
    protected String packaging;
    @Parameter
    protected boolean createDependencyReducedPom;
    @Parameter(defaultValue="${basedir}/dependency-reduced-pom.xml")
    protected File dependencyReducedPomLocation;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File scrLocation;
    @Parameter
    protected boolean exportScr;
    @Component
    private MavenProjectHelper m_projectHelper;
    @Component
    private ArchiverManager m_archiverManager;
    @Component
    private ArtifactHandlerManager m_artifactHandlerManager;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    protected MavenProjectBuilder mavenProjectBuilder;
    @Component
    protected DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactCollector artifactCollector;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Parameter(readonly=true, required=true, defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter
    protected List<String> supportedProjectTypes = Arrays.asList("jar", "bundle");
    @Parameter
    protected List<String> noWarningProjectTypes = Collections.emptyList();
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}")
    private String buildDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter
    private Map<String, String> instructions = new LinkedHashMap<String, String>();
    private final Maven2OsgiConverter m_maven2OsgiConverter = new DefaultMaven2OsgiConverter();
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession m_mavenSession;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Component
    protected BuildContext buildContext;
    @Parameter(defaultValue="false", property="bundle.skip")
    private boolean skip = false;
    private static final String MAVEN_SYMBOLICNAME = "maven-symbolicname";
    private static final String MAVEN_RESOURCES = "{maven-resources}";
    private static final String MAVEN_TEST_RESOURCES = "{maven-test-resources}";
    private static final String LOCAL_PACKAGES = "{local-packages}";
    private static final String MAVEN_SOURCES = "{maven-sources}";
    private static final String MAVEN_TEST_SOURCES = "{maven-test-sources}";
    private static final String BUNDLE_PLUGIN_EXTENSION = "BNDExtension-";
    private static final String BUNDLE_PLUGIN_PREPEND_EXTENSION = "BNDPrependExtension-";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String NL = System.getProperty("line.separator");

    protected Maven2OsgiConverter getMaven2OsgiConverter() {
        return this.m_maven2OsgiConverter;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Map<String, String> getInstructions() {
        return this.instructions;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Bundle plugin");
            return;
        }
        String projectType = this.getProject().getArtifact().getType();
        if (!this.supportedProjectTypes.contains(projectType)) {
            if (!this.noWarningProjectTypes.contains(projectType)) {
                this.getLog().warn((CharSequence)("Ignoring project type " + projectType + " - supportedProjectTypes = " + this.supportedProjectTypes));
            }
            return;
        }
        try {
            this.execute(this.instructions, this.getClasspath(this.project));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error calculating classpath for project " + this.project, (Exception)e);
        }
    }

    protected static Map<String, String> transformDirectives(Map<String, String> originalInstructions) {
        LinkedHashMap<String, String> transformedInstructions = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e : originalInstructions.entrySet()) {
            String value;
            String key = e.getKey();
            if (key.startsWith("_")) {
                key = "-" + key.substring(1);
            }
            value = null == (value = e.getValue()) ? "" : value.replaceAll("\\p{Blank}*[\r\n]\\p{Blank}*", "");
            if ("-wab".equals(key) && value.isEmpty()) {
                value = "src/main/webapp/";
            }
            transformedInstructions.put(key, value);
        }
        return transformedInstructions;
    }

    protected boolean reportErrors(String prefix, Analyzer analyzer) {
        List errors = analyzer.getErrors();
        List warnings = analyzer.getWarnings();
        for (String msg : warnings) {
            this.getLog().warn((CharSequence)(prefix + " : " + msg));
        }
        boolean hasErrors = false;
        String fileNotFound = "Input file does not exist: ";
        for (String msg : errors) {
            if (msg.startsWith(fileNotFound) && msg.endsWith("~")) {
                String duplicate = Processor.removeDuplicateMarker((String)msg.substring(fileNotFound.length()));
                this.getLog().warn((CharSequence)(prefix + " : Duplicate path '" + duplicate + "' in Include-Resource"));
                continue;
            }
            this.getLog().error((CharSequence)(prefix + " : " + msg));
            hasErrors = true;
        }
        return hasErrors;
    }

    protected void execute(Map<String, String> originalInstructions, ClassPathItem[] classpath) throws MojoExecutionException {
        try {
            boolean customPackaging;
            String failok;
            File jarFile = new File(this.getBuildDirectory(), this.getBundleName(this.project));
            Builder builder = this.buildOSGiBundle(this.project, originalInstructions, classpath);
            boolean hasErrors = this.reportErrors("Bundle " + this.project.getArtifact(), (Analyzer)builder);
            if (hasErrors && (null == (failok = builder.getProperty("-failok")) || "false".equalsIgnoreCase(failok))) {
                jarFile.delete();
                throw new MojoFailureException("Error(s) found in bundle configuration");
            }
            this.getLog().info((CharSequence)("Building bundle: " + jarFile.getPath()));
            jarFile.getParentFile().mkdirs();
            builder.getJar().write(jarFile);
            Artifact mainArtifact = this.project.getArtifact();
            if ("bundle".equals(mainArtifact.getType())) {
                mainArtifact.setArtifactHandler(this.m_artifactHandlerManager.getArtifactHandler("jar"));
            }
            boolean customClassifier = null != this.classifier && this.classifier.trim().length() > 0;
            boolean bl = customPackaging = null != this.packaging && this.packaging.trim().length() > 0;
            if (customClassifier && customPackaging) {
                this.m_projectHelper.attachArtifact(this.project, this.packaging, this.classifier, jarFile);
            } else if (customClassifier) {
                this.m_projectHelper.attachArtifact(this.project, jarFile, this.classifier);
            } else if (customPackaging) {
                this.m_projectHelper.attachArtifact(this.project, this.packaging, jarFile);
            } else {
                mainArtifact.setFile(jarFile);
            }
            if (this.unpackBundle) {
                this.unpackBundle(jarFile);
            }
            if (this.manifestLocation != null) {
                File outputFile = new File(this.manifestLocation, "MANIFEST.MF");
                try {
                    ManifestPlugin.writeManifest((Analyzer)builder, outputFile, this.niceManifest, this.exportScr, this.scrLocation, this.buildContext, this.getLog());
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Error trying to write Manifest to file " + outputFile), (Throwable)e);
                }
            }
            builder.close();
        }
        catch (MojoFailureException e) {
            this.getLog().error((CharSequence)e.getLocalizedMessage());
            throw new MojoExecutionException("Error(s) found in bundle configuration", (Exception)((Object)e));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"An internal error occurred", (Throwable)e);
            throw new MojoExecutionException("Internal error in maven-bundle-plugin", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Builder getOSGiBuilder(MavenProject currentProject, Map<String, String> originalInstructions, ClassPathItem[] classpath) throws Exception {
        String[] enabled;
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getDefaultProperties(currentProject));
        properties.putAll(BundlePlugin.transformDirectives(originalInstructions));
        if (new MavenArchiver().parseOutputTimestamp(this.outputTimestamp) != null) {
            properties.put("-reproducible", this.outputTimestamp);
        }
        HashMap<String, String> addProps = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : currentProject.getProperties().entrySet()) {
            String currentValue;
            String oKey;
            String key = entry.getKey().toString();
            if (key.startsWith(BUNDLE_PLUGIN_EXTENSION)) {
                oKey = key.substring(BUNDLE_PLUGIN_EXTENSION.length());
                currentValue = properties.getProperty(oKey);
                if (currentValue == null) {
                    addProps.put(oKey, entry.getValue().toString());
                } else {
                    addProps.put(oKey, currentValue + ',' + entry.getValue());
                }
            }
            if (!key.startsWith(BUNDLE_PLUGIN_PREPEND_EXTENSION)) continue;
            oKey = key.substring(BUNDLE_PLUGIN_PREPEND_EXTENSION.length());
            currentValue = properties.getProperty(oKey);
            if (currentValue == null) {
                addProps.put(oKey, entry.getValue().toString());
                continue;
            }
            addProps.put(oKey, entry.getValue() + "," + currentValue);
        }
        properties.putAll((Map<?, ?>)addProps);
        for (String key : addProps.keySet()) {
            properties.remove(BUNDLE_PLUGIN_EXTENSION + key);
            properties.remove(BUNDLE_PLUGIN_PREPEND_EXTENSION + key);
        }
        if (properties.getProperty("Bundle-Activator") != null && properties.getProperty("Bundle-Activator").isEmpty()) {
            properties.remove("Bundle-Activator");
        }
        if (properties.containsKey("-disable-plugin")) {
            String[] disabled = properties.remove("-disable-plugin").toString().replaceAll(" ", "").split(",");
            enabled = properties.getProperty("-plugin", "").replaceAll(" ", "").split(",");
            LinkedHashSet<String> plugin = new LinkedHashSet<String>();
            plugin.addAll(Arrays.asList(enabled));
            plugin.removeAll(Arrays.asList(disabled));
            StringBuilder sb = new StringBuilder();
            for (String s : plugin) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(s);
            }
            properties.setProperty("-plugin", sb.toString());
        }
        Builder builder = new Builder();
        enabled = BundlePlugin.class;
        synchronized (BundlePlugin.class) {
            builder.setBase(BundlePlugin.getBase(currentProject));
            // ** MonitorExit[enabled] (shouldn't be in output)
            builder.setProperties(BundlePlugin.sanitize(properties));
            if (classpath != null) {
                ArrayList<Jar> jars = new ArrayList<Jar>();
                for (int i = 0; i < classpath.length; ++i) {
                    if (!classpath[i].file.exists()) continue;
                    jars.add(new Jar(classpath[i].id, classpath[i].file));
                }
                builder.setClasspath(jars);
            }
            return builder;
        }
    }

    protected static Properties sanitize(Properties properties) {
        Properties sanitizedEntries = new Properties();
        Iterator<Map.Entry<Object, Object>> itr = properties.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            if (!(entry.getKey() instanceof String)) {
                String key = BundlePlugin.sanitize(entry.getKey());
                if (!properties.containsKey(key)) {
                    sanitizedEntries.setProperty(key, BundlePlugin.sanitize(entry.getValue()));
                }
                itr.remove();
                continue;
            }
            if (entry.getValue() instanceof String) continue;
            entry.setValue(BundlePlugin.sanitize(entry.getValue()));
        }
        properties.putAll((Map<?, ?>)sanitizedEntries);
        return properties;
    }

    protected static String sanitize(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Iterable) {
            String delim = "";
            StringBuilder buf = new StringBuilder();
            for (Object i : (Iterable)value) {
                buf.append(delim).append(i);
                delim = ", ";
            }
            return buf.toString();
        }
        if (value.getClass().isArray()) {
            String delim = "";
            StringBuilder buf = new StringBuilder();
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                buf.append(delim).append(Array.get(value, i));
                delim = ", ";
            }
            return buf.toString();
        }
        return String.valueOf(value);
    }

    protected void addMavenInstructions(MavenProject currentProject, Builder builder) throws Exception {
        StringBuilder buf;
        if (currentProject.getBasedir() != null) {
            BundlePlugin.includeMavenResources(currentProject, (Analyzer)builder, this.getLog());
            BundlePlugin.addLocalPackages(this.outputDirectory, (Analyzer)builder);
            BundlePlugin.addMavenSourcePath(currentProject, (Analyzer)builder, this.getLog());
        }
        Collection<Artifact> embeddableArtifacts = this.getEmbeddableArtifacts(currentProject, (Analyzer)builder);
        DependencyEmbedder dependencyEmbedder = new DependencyEmbedder(this.getLog(), embeddableArtifacts);
        dependencyEmbedder.processHeaders((Analyzer)builder);
        Collection<Artifact> embeddedArtifacts = dependencyEmbedder.getEmbeddedArtifacts();
        if (!embeddedArtifacts.isEmpty() && this.createDependencyReducedPom) {
            HashSet<String> embeddedIds = new HashSet<String>();
            for (Artifact artifact : embeddedArtifacts) {
                embeddedIds.add(this.getId(artifact));
            }
            this.createDependencyReducedPom(embeddedIds);
        }
        if (this.dumpInstructions != null || this.getLog().isDebugEnabled()) {
            buf = new StringBuilder();
            this.getLog().debug((CharSequence)("BND Instructions:" + NL + BundlePlugin.dumpInstructions(builder.getProperties(), buf)));
            if (this.dumpInstructions != null) {
                this.getLog().info((CharSequence)("Writing BND instructions to " + this.dumpInstructions));
                this.dumpInstructions.getParentFile().mkdirs();
                FileUtils.fileWrite((File)this.dumpInstructions, (String)("# BND instructions" + NL + buf));
            }
        }
        if (this.dumpClasspath != null || this.getLog().isDebugEnabled()) {
            buf = new StringBuilder();
            this.getLog().debug((CharSequence)("BND Classpath:" + NL + BundlePlugin.dumpClasspath(builder.getClasspath(), buf)));
            if (this.dumpClasspath != null) {
                this.getLog().info((CharSequence)("Writing BND classpath to " + this.dumpClasspath));
                this.dumpClasspath.getParentFile().mkdirs();
                FileUtils.fileWrite((File)this.dumpClasspath, (String)("# BND classpath" + NL + buf));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDependencyReducedPom(Set<String> artifactsToRemove) throws IOException, ProjectBuildingException, DependencyGraphBuilderException {
        Model model = this.project.getOriginalModel();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        boolean modified = false;
        ArrayList<Dependency> transitiveDeps = new ArrayList<Dependency>();
        for (Object artifact : this.project.getArtifacts()) {
            if ("pom".equals(artifact.getType())) continue;
            Dependency dep = new Dependency();
            dep.setArtifactId(artifact.getArtifactId());
            if (artifact.hasClassifier()) {
                dep.setClassifier(artifact.getClassifier());
            }
            dep.setGroupId(artifact.getGroupId());
            dep.setOptional(artifact.isOptional());
            dep.setScope(artifact.getScope());
            dep.setType(artifact.getType());
            dep.setVersion(artifact.getVersion());
            transitiveDeps.add(dep);
        }
        List origDeps = this.project.getDependencies();
        for (Dependency d : origDeps) {
            dependencies.add(d);
            String id = this.getId(d);
            if (!artifactsToRemove.contains(id)) continue;
            modified = true;
            dependencies.remove(d);
        }
        if (modified) {
            while (modified) {
                File f;
                model.setDependencies(dependencies);
                if (this.dependencyReducedPomLocation == null) {
                    this.dependencyReducedPomLocation = new File(this.project.getBasedir(), "dependency-reduced-pom.xml");
                }
                if ((f = this.dependencyReducedPomLocation).exists()) {
                    f.delete();
                }
                XmlStreamWriter w = WriterFactory.newXmlWriter((File)f);
                String origRelativePath = null;
                String replaceRelativePath = null;
                if (model.getParent() != null) {
                    origRelativePath = model.getParent().getRelativePath();
                }
                replaceRelativePath = origRelativePath;
                if (origRelativePath == null) {
                    origRelativePath = "../pom.xml";
                }
                if (model.getParent() != null) {
                    File parentFile = new File(this.project.getBasedir(), model.getParent().getRelativePath()).getCanonicalFile();
                    if (!parentFile.isFile()) {
                        parentFile = new File(parentFile, "pom.xml");
                    }
                    parentFile = parentFile.getCanonicalFile();
                    String relPath = RelativizePath.convertToRelativePath(parentFile, f);
                    model.getParent().setRelativePath(relPath);
                }
                try {
                    new MavenXpp3Writer().write((Writer)w, model);
                }
                finally {
                    if (model.getParent() != null) {
                        model.getParent().setRelativePath(replaceRelativePath);
                    }
                    w.close();
                }
                MavenProject p2 = this.mavenProjectBuilder.build(f, this.localRepository, null);
                modified = this.updateExcludesInDeps(p2, dependencies, transitiveDeps);
            }
            this.project.setFile(this.dependencyReducedPomLocation);
        }
    }

    private String getId(Artifact artifact) {
        return this.getId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier());
    }

    private String getId(Dependency dependency) {
        return this.getId(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getClassifier());
    }

    private String getId(String groupId, String artifactId, String type, String classifier) {
        return groupId + ":" + artifactId + ":" + type + ":" + (classifier != null ? classifier : "");
    }

    public boolean updateExcludesInDeps(MavenProject project, List<Dependency> dependencies, List<Dependency> transitiveDeps) throws DependencyGraphBuilderException {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
        request.setProject(project);
        request.setRepositorySession(this.session.getRepositorySession());
        DependencyNode node = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)request, null);
        boolean modified = false;
        for (DependencyNode n2 : node.getChildren()) {
            block1: for (DependencyNode n3 : n2.getChildren()) {
                boolean found = false;
                for (Dependency dep : transitiveDeps) {
                    if (!dep.getArtifactId().equals(n3.getArtifact().getArtifactId()) || !dep.getGroupId().equals(n3.getArtifact().getGroupId())) continue;
                    found = true;
                }
                if (found) continue;
                for (Dependency dep : dependencies) {
                    if (!dep.getArtifactId().equals(n2.getArtifact().getArtifactId()) || !dep.getGroupId().equals(n2.getArtifact().getGroupId())) continue;
                    Exclusion exclusion = new Exclusion();
                    exclusion.setArtifactId(n3.getArtifact().getArtifactId());
                    exclusion.setGroupId(n3.getArtifact().getGroupId());
                    dep.addExclusion(exclusion);
                    modified = true;
                    continue block1;
                }
            }
        }
        return modified;
    }

    protected Builder buildOSGiBundle(MavenProject currentProject, Map<String, String> originalInstructions, ClassPathItem[] classpath) throws Exception {
        Builder builder = this.getOSGiBuilder(currentProject, originalInstructions, classpath);
        this.addMavenInstructions(currentProject, builder);
        builder.build();
        this.mergeMavenManifest(currentProject, builder);
        return builder;
    }

    protected static StringBuilder dumpInstructions(Properties properties, StringBuilder buf) {
        try {
            buf.append("#-----------------------------------------------------------------------" + NL);
            Properties stringProperties = new Properties();
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = properties.getProperty(key);
                if (value == null) continue;
                stringProperties.setProperty(key, value);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            stringProperties.store(out, null);
            buf.append(out.toString("8859_1"));
            buf.append("#-----------------------------------------------------------------------").append(NL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return buf;
    }

    protected static StringBuilder dumpClasspath(List<Jar> classpath, StringBuilder buf) {
        try {
            buf.append("#-----------------------------------------------------------------------").append(NL);
            buf.append("-classpath:\\").append(NL);
            Iterator<Jar> i = classpath.iterator();
            while (i.hasNext()) {
                File path = i.next().getSource();
                if (path == null) continue;
                buf.append(' ').append(path.toString()).append(i.hasNext() ? ",\\" : "").append(NL);
            }
            buf.append("#-----------------------------------------------------------------------").append(NL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return buf;
    }

    protected static StringBuilder dumpManifest(Manifest manifest, StringBuilder buf) {
        try {
            buf.append("#-----------------------------------------------------------------------").append(NL);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ManifestWriter.outputManifest(manifest, out, true);
            buf.append(out.toString("UTF8"));
            buf.append("#-----------------------------------------------------------------------").append(NL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return buf;
    }

    protected static void includeMavenResources(MavenProject currentProject, Analyzer analyzer, Log log) {
        String mavenResourcePaths = BundlePlugin.getMavenResourcePaths(currentProject, false);
        String mavenTestResourcePaths = BundlePlugin.getMavenResourcePaths(currentProject, true);
        String includeResource = analyzer.getProperty("Include-Resource");
        if (includeResource != null) {
            if (includeResource.contains(MAVEN_RESOURCES) || includeResource.contains(MAVEN_TEST_RESOURCES)) {
                String combinedResource = StringUtils.replace((String)includeResource, (String)MAVEN_RESOURCES, (String)mavenResourcePaths);
                if ((combinedResource = StringUtils.replace((String)combinedResource, (String)MAVEN_TEST_RESOURCES, (String)mavenTestResourcePaths)).length() > 0) {
                    analyzer.setProperty("Include-Resource", combinedResource);
                } else {
                    analyzer.unsetProperty("Include-Resource");
                }
            } else if (mavenResourcePaths.length() > 0) {
                log.warn((CharSequence)("Include-Resource: overriding " + mavenResourcePaths + " with " + includeResource + " (add " + MAVEN_RESOURCES + " if you want to include the maven resources)"));
            }
        } else if (mavenResourcePaths.length() > 0) {
            analyzer.setProperty("Include-Resource", mavenResourcePaths);
        }
    }

    protected void mergeMavenManifest(MavenProject currentProject, Builder builder) throws Exception {
        Jar jar = builder.getJar();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("BND Manifest:" + NL + BundlePlugin.dumpManifest(jar.getManifest(), new StringBuilder())));
        }
        boolean addMavenDescriptor = currentProject.getBasedir() != null;
        try {
            MavenArchiveConfiguration archiveConfig = JarPluginConfiguration.getArchiveConfiguration(currentProject);
            String mavenManifestText = new MavenArchiver().getManifest(this.session, currentProject, archiveConfig).toString();
            addMavenDescriptor = addMavenDescriptor && archiveConfig.isAddMavenDescriptor();
            Manifest mavenManifest = new Manifest();
            File externalManifestFile = archiveConfig.getManifestFile();
            if (null != externalManifestFile) {
                if (!externalManifestFile.isAbsolute()) {
                    externalManifestFile = new File(currentProject.getBasedir(), externalManifestFile.getPath());
                }
                if (externalManifestFile.exists() && !externalManifestFile.equals(new File(this.manifestLocation, "MANIFEST.MF"))) {
                    FileInputStream mis = new FileInputStream(externalManifestFile);
                    mavenManifest.read(mis);
                    ((InputStream)mis).close();
                }
            }
            mavenManifest.read(new ByteArrayInputStream(mavenManifestText.getBytes("UTF8")));
            if (!archiveConfig.isManifestSectionsEmpty()) {
                List sections = archiveConfig.getManifestSections();
                for (ManifestSection section : sections) {
                    Attributes attributes = new Attributes();
                    if (!section.isManifestEntriesEmpty()) {
                        Map entries = section.getManifestEntries();
                        for (Map.Entry entry : entries.entrySet()) {
                            attributes.putValue((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    mavenManifest.getEntries().put(section.getName(), attributes);
                }
            }
            Attributes mainMavenAttributes = mavenManifest.getMainAttributes();
            mainMavenAttributes.putValue("Created-By", this.createdBy("Apache Maven Bundle Plugin", "org.apache.felix", "maven-bundle-plugin"));
            String[] removeHeaders = builder.getProperty("-removeheaders", "").split(",");
            for (int i = 0; i < removeHeaders.length; ++i) {
                Iterator<Object> j = mainMavenAttributes.keySet().iterator();
                while (j.hasNext()) {
                    if (!j.next().toString().matches(removeHeaders[i].trim())) continue;
                    j.remove();
                }
            }
            Properties properties = builder.getProperties();
            Manifest bundleManifest = jar.getManifest();
            if (properties.containsKey("Merge-Headers")) {
                Instructions instructions = new Instructions((Collection)ExtList.from((String)builder.getProperty("Merge-Headers")));
                BundlePlugin.mergeManifest(instructions, bundleManifest, mavenManifest);
            } else {
                bundleManifest.getMainAttributes().putAll((Map<?, ?>)mainMavenAttributes);
                bundleManifest.getEntries().putAll(mavenManifest.getEntries());
            }
            String importPackages = bundleManifest.getMainAttributes().getValue("Import-Package");
            if (importPackages != null) {
                Parameters values;
                Set<String> optionalPackages = this.getOptionalPackages(currentProject);
                try (Analyzer analyzer = new Analyzer();){
                    values = analyzer.parseHeader(importPackages);
                }
                for (Map.Entry entry : values.entrySet()) {
                    String pkg = (String)entry.getKey();
                    Map options = (Map)entry.getValue();
                    if (options.containsKey("resolution:") || !optionalPackages.contains(pkg)) continue;
                    options.put("resolution:", "optional");
                }
                String result = Processor.printClauses((Map)values);
                bundleManifest.getMainAttributes().putValue("Import-Package", result);
            }
            jar.setManifest(bundleManifest);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Unable to merge Maven manifest: " + e.getLocalizedMessage()));
        }
        if (addMavenDescriptor) {
            this.doMavenMetadata(currentProject, jar);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Final Manifest:" + NL + BundlePlugin.dumpManifest(jar.getManifest(), new StringBuilder())));
        }
        builder.setJar(jar);
    }

    private static String getCreatedByVersion(String groupId, String artifactId) {
        try {
            Properties properties = PropertyUtils.loadProperties((InputStream)MavenArchiver.class.getResourceAsStream("/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties"));
            return properties.getProperty("version");
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private String createdBy(String description, String groupId, String artifactId) {
        String createdBy = description;
        String version = BundlePlugin.getCreatedByVersion(groupId, artifactId);
        if (version != null) {
            createdBy = createdBy + " " + version;
        }
        return createdBy;
    }

    protected static void mergeManifest(Instructions instructions, Manifest ... manifests) throws IOException {
        for (int i = manifests.length - 2; i >= 0; --i) {
            Manifest mergedManifest = manifests[i];
            Manifest manifest = manifests[i + 1];
            Attributes mergedMainAttributes = mergedManifest.getMainAttributes();
            Attributes mainAttributes = manifest.getMainAttributes();
            Attributes filteredMainAttributes = BundlePlugin.filterAttributes(instructions, mainAttributes, null);
            if (!filteredMainAttributes.isEmpty()) {
                BundlePlugin.mergeAttributes(mergedMainAttributes, filteredMainAttributes);
            }
            Map<String, Attributes> mergedEntries = mergedManifest.getEntries();
            Map<String, Attributes> entries = manifest.getEntries();
            for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                String name = entry.getKey();
                Attributes attributes = entry.getValue();
                Attributes filteredAttributes = BundlePlugin.filterAttributes(instructions, attributes, null);
                if (filteredAttributes.isEmpty()) continue;
                Attributes mergedAttributes = mergedManifest.getAttributes(name);
                if (mergedAttributes != null) {
                    BundlePlugin.mergeAttributes(mergedAttributes, filteredAttributes);
                    continue;
                }
                mergedEntries.put(name, filteredAttributes);
            }
        }
    }

    private static Attributes filterAttributes(Instructions instructions, Attributes source, Set<Instruction> nomatch) {
        Attributes result = new Attributes();
        TreeMap<String, Object> keys = new TreeMap<String, Object>();
        for (Object object : source.keySet()) {
            keys.put(object.toString(), object);
        }
        ArrayList filters = new ArrayList(instructions.keySet());
        if (nomatch == null) {
            nomatch = Create.set();
        }
        for (Instruction instruction : filters) {
            boolean match = false;
            Iterator i = keys.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                if (!instruction.matches(key)) continue;
                match = true;
                if (!instruction.isNegated()) {
                    Object name = entry.getValue();
                    Object value = source.get(name);
                    result.put(name, value);
                }
                i.remove();
            }
            if (match || instruction.isAny()) continue;
            nomatch.add(instruction);
        }
        Iterator iterator = nomatch.iterator();
        while (iterator.hasNext()) {
            Instruction instruction;
            instruction = (Instruction)iterator.next();
            if (instruction.isLiteral() && !instruction.isNegated()) {
                Object key = keys.get(instruction.getLiteral());
                if (key != null) {
                    Object value = source.get(key);
                    result.put(key, value);
                }
                iterator.remove();
                continue;
            }
            if (instruction.isNegated()) {
                iterator.remove();
                continue;
            }
            if (!instruction.isOptional()) continue;
            iterator.remove();
        }
        return result;
    }

    private static void mergeAttributes(Attributes ... attributesArray) throws IOException {
        for (int i = attributesArray.length - 2; i >= 0; --i) {
            Attributes mergedAttributes = attributesArray[i];
            Attributes attributes = attributesArray[i + 1];
            for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                Parameters clauses;
                Parameters mergedClauses;
                String value;
                Object name = entry.getKey();
                String oldValue = (String)mergedAttributes.put(name, value = (String)entry.getValue());
                if (oldValue == null || (mergedClauses = OSGiHeader.parseHeader((String)oldValue)).isEqual(clauses = OSGiHeader.parseHeader((String)value))) continue;
                for (Map.Entry clauseEntry : clauses.entrySet()) {
                    String clause = (String)clauseEntry.getKey();
                    Attrs attrs = (Attrs)clauseEntry.getValue();
                    Attrs mergedAttrs = mergedClauses.get(clause);
                    if (mergedAttrs == null) {
                        mergedClauses.put(clause, attrs);
                        continue;
                    }
                    if (mergedAttrs.isEqual(attrs)) continue;
                    for (Map.Entry adentry : attrs.entrySet()) {
                        String adname = (String)adentry.getKey();
                        String ad = (String)adentry.getValue();
                        if (mergedAttrs.containsKey(adname)) {
                            Attrs.Type type = attrs.getType(adname);
                            switch (type) {
                                case VERSIONS: 
                                case STRINGS: 
                                case LONGS: 
                                case DOUBLES: {
                                    ExtList mergedAd = ExtList.from((String)mergedAttrs.get(adname));
                                    ExtList.from((String)ad).addAll((Collection)ExtList.from((String)ad));
                                    mergedAttrs.put(adname, mergedAd.join());
                                }
                            }
                            continue;
                        }
                        mergedAttrs.put(adname, ad);
                    }
                }
                mergedAttributes.put(name, Processor.printClauses((Map)mergedClauses));
            }
        }
    }

    protected Set<String> getOptionalPackages(MavenProject currentProject) throws IOException, MojoExecutionException {
        ArrayList<Artifact> inscope = new ArrayList<Artifact>();
        Collection<Artifact> artifacts = this.getSelectedDependencies(currentProject.getArtifacts());
        for (Artifact artifact : artifacts) {
            if (!artifact.getArtifactHandler().isAddedToClasspath()) continue;
            inscope.add(artifact);
        }
        HashSet<String> optionalArtifactIds = new HashSet<String>();
        for (Artifact artifact : inscope) {
            if (!artifact.isOptional()) continue;
            String id = artifact.toString();
            if (artifact.getScope() != null) {
                id = id.replaceFirst(":[^:]*$", "");
            }
            optionalArtifactIds.add(id);
        }
        HashSet required = new HashSet();
        HashSet<String> optional = new HashSet<String>();
        for (Artifact artifact : inscope) {
            File file = this.getFile(artifact);
            if (file == null) continue;
            Jar jar = new Jar(artifact.getArtifactId(), file);
            if (this.isTransitivelyOptional(optionalArtifactIds, artifact)) {
                optional.addAll(jar.getPackages());
            } else {
                required.addAll(jar.getPackages());
            }
            jar.close();
        }
        optional.removeAll(required);
        return optional;
    }

    protected boolean isTransitivelyOptional(HashSet<String> optionalArtifactIds, Artifact artifact) {
        List trail = artifact.getDependencyTrail();
        for (String next : trail) {
            if (!optionalArtifactIds.contains(next)) continue;
            return true;
        }
        return false;
    }

    private void unpackBundle(File jarFile) {
        File outputDir = this.getOutputDirectory();
        if (null == outputDir) {
            outputDir = new File(this.getBuildDirectory(), "classes");
        }
        try {
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            UnArchiver unArchiver = this.m_archiverManager.getUnArchiver("jar");
            unArchiver.setDestDirectory(outputDir);
            unArchiver.setSourceFile(jarFile);
            unArchiver.extract();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Problem unpacking " + jarFile + " to " + outputDir), (Throwable)e);
        }
    }

    protected static String removeTagFromInstruction(String instruction, String tag) {
        StringBuffer buf = new StringBuffer();
        String[] clauses = instruction.split(",");
        for (int i = 0; i < clauses.length; ++i) {
            String clause = clauses[i].trim();
            if (tag.equals(clause)) continue;
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(clause);
        }
        return buf.toString();
    }

    private static Map<String, String> getProperties(Model projectModel, String prefix) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        Method[] methods = Model.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("get")) continue;
            try {
                Object v = methods[i].invoke((Object)projectModel, null);
                if (v == null) continue;
                name = prefix + Character.toLowerCase(name.charAt(3)) + name.substring(4);
                if (v.getClass().isArray()) {
                    properties.put(name, Arrays.asList((Object[])v).toString());
                    continue;
                }
                properties.put(name, v.toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }

    private static StringBuffer printLicenses(List<License> licenses) {
        if (licenses == null || licenses.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (License l : licenses) {
            String url = l.getUrl();
            if (url == null) continue;
            sb.append(del);
            sb.append(url);
            del = ", ";
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb;
    }

    private void doMavenMetadata(MavenProject currentProject, Jar jar) throws IOException {
        String path = "META-INF/maven/" + currentProject.getGroupId() + "/" + currentProject.getArtifactId();
        File pomFile = currentProject.getFile();
        if (pomFile == null || !pomFile.exists()) {
            pomFile = new File(currentProject.getBasedir(), "pom.xml");
        }
        if (pomFile.exists()) {
            jar.putResource(path + "/pom.xml", (aQute.bnd.osgi.Resource)new FileResource(pomFile));
        }
        Properties p = new Properties();
        p.put("version", currentProject.getVersion());
        p.put("groupId", currentProject.getGroupId());
        p.put("artifactId", currentProject.getArtifactId());
        jar.putResource(path + "/pom.properties", (aQute.bnd.osgi.Resource)new EmbeddedResource(this.toFileContentAsBytes(p), System.currentTimeMillis()));
    }

    private byte[] toFileContentAsBytes(Properties properties) {
        byte[] bytes;
        try {
            String line;
            StringWriter sw = new StringWriter();
            properties.store(sw, null);
            BufferedReader r = new BufferedReader(new StringReader(sw.toString()));
            StringWriter stringWriter = new StringWriter();
            while ((line = r.readLine()) != null) {
                if (line.startsWith("#")) continue;
                stringWriter.append(line).append(NL);
            }
            bytes = stringWriter.getBuffer().toString().getBytes(StandardCharsets.ISO_8859_1);
            r.close();
            sw.close();
            stringWriter.close();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error while converting properties to file content. Returning empty array.", (Throwable)e);
            bytes = new byte[]{};
        }
        return bytes;
    }

    protected ClassPathItem[] getClasspath(MavenProject currentProject) throws IOException, MojoExecutionException {
        ArrayList<ClassPathItem> list = new ArrayList<ClassPathItem>(currentProject.getArtifacts().size() + 1);
        if (this.getOutputDirectory() != null && this.getOutputDirectory().exists()) {
            list.add(new ClassPathItem(".", this.getOutputDirectory()));
        }
        Collection<Artifact> artifacts = this.getSelectedDependencies(currentProject.getArtifacts());
        for (Artifact artifact : artifacts) {
            if (!artifact.getArtifactHandler().isAddedToClasspath() || "test".equals(artifact.getScope())) continue;
            File file = this.getFile(artifact);
            if (file == null) {
                this.getLog().warn((CharSequence)("File is not available for artifact " + artifact + " in project " + currentProject.getArtifact()));
                continue;
            }
            ClassPathItem jar = new ClassPathItem(artifact.getArtifactId(), file);
            list.add(jar);
        }
        ClassPathItem[] cp = new ClassPathItem[list.size()];
        list.toArray(cp);
        return cp;
    }

    private Collection<Artifact> getSelectedDependencies(Collection<Artifact> artifacts) throws MojoExecutionException {
        if (null == this.excludeDependencies || this.excludeDependencies.isEmpty()) {
            return artifacts;
        }
        if ("true".equalsIgnoreCase(this.excludeDependencies)) {
            return Collections.emptyList();
        }
        LinkedHashSet<Artifact> selectedDependencies = new LinkedHashSet<Artifact>(artifacts);
        DependencyExcluder excluder = new DependencyExcluder(artifacts);
        excluder.processHeaders(this.excludeDependencies);
        selectedDependencies.removeAll(excluder.getExcludedArtifacts());
        return selectedDependencies;
    }

    protected File getFile(Artifact artifact) {
        return artifact.getFile();
    }

    private static void header(Properties properties, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return;
        }
        properties.put(key, value.toString().replaceAll("[\r\n]", ""));
    }

    protected String convertVersionToOsgi(String version) {
        return this.getMaven2OsgiConverter().getVersion(version);
    }

    protected String getBundleName(MavenProject currentProject) {
        String extension;
        try {
            extension = currentProject.getArtifact().getArtifactHandler().getExtension();
        }
        catch (Throwable e) {
            extension = currentProject.getArtifact().getType();
        }
        if (StringUtils.isEmpty((String)extension) || "bundle".equals(extension) || "pom".equals(extension)) {
            extension = "jar";
        }
        if (null != this.classifier && this.classifier.trim().length() > 0) {
            return this.finalName + '-' + this.classifier + '.' + extension;
        }
        return this.finalName + '.' + extension;
    }

    protected String getBuildDirectory() {
        return this.buildDirectory;
    }

    protected void setBuildDirectory(String _buildirectory) {
        this.buildDirectory = _buildirectory;
    }

    protected Properties getDefaultProperties(MavenProject currentProject) {
        String bsn;
        Properties properties = new Properties();
        try {
            bsn = this.getMaven2OsgiConverter().getBundleSymbolicName(currentProject.getArtifact());
        }
        catch (Exception e) {
            bsn = currentProject.getGroupId() + "." + currentProject.getArtifactId();
        }
        properties.put(MAVEN_SYMBOLICNAME, bsn);
        properties.put("Bundle-SymbolicName", bsn);
        properties.put("Import-Package", "*");
        properties.put("Bundle-Version", this.getMaven2OsgiConverter().getVersion(currentProject.getVersion()));
        properties.put("-removeheaders", "Include-Resource,Private-Package");
        BundlePlugin.header(properties, "Bundle-Description", currentProject.getDescription());
        StringBuffer licenseText = BundlePlugin.printLicenses(currentProject.getLicenses());
        if (licenseText != null) {
            BundlePlugin.header(properties, "Bundle-License", licenseText);
        }
        BundlePlugin.header(properties, "Bundle-Name", currentProject.getName());
        if (currentProject.getOrganization() != null) {
            if (currentProject.getOrganization().getName() != null) {
                String organizationName = currentProject.getOrganization().getName();
                BundlePlugin.header(properties, "Bundle-Vendor", organizationName);
                properties.put("project.organization.name", organizationName);
                properties.put("pom.organization.name", organizationName);
            }
            if (currentProject.getOrganization().getUrl() != null) {
                String organizationUrl = currentProject.getOrganization().getUrl();
                BundlePlugin.header(properties, "Bundle-DocURL", organizationUrl);
                properties.put("project.organization.url", organizationUrl);
                properties.put("pom.organization.url", organizationUrl);
            }
        }
        properties.putAll((Map<?, ?>)currentProject.getProperties());
        properties.putAll((Map<?, ?>)currentProject.getModel().getProperties());
        Iterator i = currentProject.getFilters().iterator();
        while (i.hasNext()) {
            File filterFile = new File((String)i.next());
            if (!filterFile.isFile()) continue;
            try {
                properties.putAll((Map<?, ?>)PropertyUtils.loadProperties((File)filterFile));
            }
            catch (IOException iOException) {}
        }
        if (this.m_mavenSession != null) {
            try {
                Properties sessionProperties = this.m_mavenSession.getExecutionProperties();
                Enumeration<?> e = sessionProperties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (key.length() <= 0 || Character.isUpperCase(key.charAt(0))) continue;
                    properties.put(key, sessionProperties.getProperty(key));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Problem with Maven session properties: " + e.getLocalizedMessage()));
            }
        }
        properties.putAll(BundlePlugin.getProperties(currentProject.getModel(), "project.build."));
        properties.putAll(BundlePlugin.getProperties(currentProject.getModel(), "pom."));
        properties.putAll(BundlePlugin.getProperties(currentProject.getModel(), "project."));
        properties.put("project.baseDir", BundlePlugin.getBase(currentProject));
        properties.put("project.build.directory", this.getBuildDirectory());
        properties.put("project.build.outputdirectory", this.getOutputDirectory());
        properties.put("classifier", this.classifier == null ? "" : this.classifier);
        BundlePlugin.header(properties, "-plugin", BlueprintPlugin.class.getName() + "," + SpringXMLType.class.getName() + "," + JpaPlugin.class.getName());
        return properties;
    }

    protected static File getBase(MavenProject currentProject) {
        return currentProject.getBasedir() != null ? currentProject.getBasedir() : new File("");
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected void setOutputDirectory(File _outputDirectory) {
        this.outputDirectory = _outputDirectory;
    }

    private static void addLocalPackages(File outputDirectory, Analyzer analyzer) throws IOException {
        Packages packages = new Packages();
        if (outputDirectory != null && outputDirectory.isDirectory()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(outputDirectory);
            scanner.setIncludes(new String[]{"**/*.class"});
            scanner.addDefaultExcludes();
            scanner.scan();
            Object[] paths = scanner.getIncludedFiles();
            Arrays.sort(paths);
            for (int i = 0; i < paths.length; ++i) {
                packages.put(analyzer.getPackageRef(BundlePlugin.getPackageName((String)paths[i])));
            }
        }
        Packages exportedPkgs = new Packages();
        Packages privatePkgs = new Packages();
        boolean noprivatePackages = "!*".equals(analyzer.getProperty("Private-Package"));
        for (Descriptors.PackageRef pkg : packages.keySet()) {
            privatePkgs.put(pkg);
            String fqn = pkg.getFQN();
            if (!noprivatePackages && (".".equals(fqn) || fqn.contains(".internal") || fqn.contains(".impl"))) continue;
            exportedPkgs.put(pkg);
        }
        Properties properties = analyzer.getProperties();
        String exported = properties.getProperty("Export-Package");
        if (exported == null) {
            if (!properties.containsKey("-exportcontents")) {
                for (Object attrs : exportedPkgs.values()) {
                    attrs.put("-split-package:", "merge-first");
                }
                properties.setProperty("Export-Package", Processor.printClauses((Map)exportedPkgs));
            } else {
                properties.setProperty("Export-Package", "");
            }
        } else if (exported.indexOf(LOCAL_PACKAGES) >= 0) {
            String newExported = StringUtils.replace((String)exported, (String)LOCAL_PACKAGES, (String)Processor.printClauses((Map)exportedPkgs));
            properties.setProperty("Export-Package", newExported);
        }
        String internal = properties.getProperty("Private-Package");
        if (internal == null) {
            if (!privatePkgs.isEmpty()) {
                for (Attrs attrs : privatePkgs.values()) {
                    attrs.put("-split-package:", "merge-first");
                }
                properties.setProperty("Private-Package", Processor.printClauses((Map)privatePkgs));
            } else {
                properties.setProperty("Private-Package", "!*");
            }
        } else if (internal.indexOf(LOCAL_PACKAGES) >= 0) {
            String newInternal = StringUtils.replace((String)internal, (String)LOCAL_PACKAGES, (String)Processor.printClauses((Map)privatePkgs));
            properties.setProperty("Private-Package", newInternal);
        }
    }

    private static String getPackageName(String filename) {
        int n = filename.lastIndexOf(File.separatorChar);
        return n < 0 ? "." : filename.substring(0, n).replace(File.separatorChar, '.');
    }

    private static List<Resource> getMavenResources(MavenProject currentProject, boolean test) {
        ArrayList<Resource> resources = new ArrayList<Resource>(test ? currentProject.getTestResources() : currentProject.getResources());
        if (currentProject.getCompileSourceRoots() != null) {
            List<String> packageInfoIncludes = Collections.singletonList("**/packageinfo");
            for (String sourceRoot : currentProject.getCompileSourceRoots()) {
                Resource packageInfoResource = new Resource();
                packageInfoResource.setDirectory(sourceRoot);
                packageInfoResource.setIncludes(packageInfoIncludes);
                resources.add(packageInfoResource);
            }
        }
        return resources;
    }

    /*
     * WARNING - void declaration
     */
    protected static String getMavenResourcePaths(MavenProject currentProject, boolean test) {
        String basePath = currentProject.getBasedir().getAbsolutePath();
        LinkedHashSet<String> pathSet = new LinkedHashSet<String>();
        for (Resource resource : BundlePlugin.getMavenResources(currentProject, test)) {
            String sourcePath = resource.getDirectory();
            String targetPath = resource.getTargetPath();
            if (!new File(sourcePath).exists() || targetPath != null && targetPath.indexOf("..") >= 0) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(sourcePath);
            if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                scanner.setIncludes(resource.getIncludes().toArray(EMPTY_STRING_ARRAY));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES);
            }
            if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                scanner.setExcludes(resource.getExcludes().toArray(EMPTY_STRING_ARRAY));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            Object[] f = scanner.getIncludedFiles();
            Arrays.sort(f);
            List<Object> includedFiles = Arrays.asList(f);
            for (String string : includedFiles) {
                void var12_12;
                String path = sourcePath + '/' + string;
                if (path.startsWith(basePath)) {
                    path = path.length() == basePath.length() ? "." : path.substring(basePath.length() + 1);
                }
                if (File.separatorChar != '/') {
                    String string2 = string.replace(File.separatorChar, '/');
                    path = path.replace(File.separatorChar, '/');
                }
                path = (String)var12_12 + '=' + path;
                if (targetPath != null) {
                    path = targetPath + '/' + path;
                }
                if (resource.isFiltering()) {
                    path = '{' + path + '}';
                }
                pathSet.add(path);
            }
        }
        StringBuffer resourcePaths = new StringBuffer();
        Iterator i = pathSet.iterator();
        while (i.hasNext()) {
            resourcePaths.append((String)i.next());
            if (!i.hasNext()) continue;
            resourcePaths.append(',');
        }
        return resourcePaths.toString();
    }

    protected Collection<Artifact> getEmbeddableArtifacts(MavenProject currentProject, Analyzer analyzer) throws MojoExecutionException {
        String embedTransitive = analyzer.getProperty("Embed-Transitive");
        Set artifacts = Boolean.valueOf(embedTransitive) != false ? currentProject.getArtifacts() : currentProject.getDependencyArtifacts();
        return this.getSelectedDependencies(artifacts);
    }

    protected static void addMavenSourcePath(MavenProject currentProject, Analyzer analyzer, Log log) {
        StringBuilder mavenSourcePaths = new StringBuilder();
        StringBuilder mavenTestSourcePaths = new StringBuilder();
        HashMap<StringBuilder, List> map = new HashMap<StringBuilder, List>(2);
        map.put(mavenSourcePaths, currentProject.getCompileSourceRoots());
        map.put(mavenTestSourcePaths, currentProject.getTestCompileSourceRoots());
        for (Map.Entry entry : map.entrySet()) {
            List compileSourceRoots = (List)entry.getValue();
            if (compileSourceRoots == null) continue;
            StringBuilder sourcePaths = (StringBuilder)entry.getKey();
            Iterator i = compileSourceRoots.iterator();
            while (i.hasNext()) {
                if (sourcePaths.length() > 0) {
                    sourcePaths.append(',');
                }
                sourcePaths.append((String)i.next());
            }
        }
        String sourcePath = analyzer.getProperty("-sourcepath");
        if (sourcePath != null) {
            if (sourcePath.contains(MAVEN_SOURCES) || sourcePath.contains(MAVEN_TEST_SOURCES)) {
                String combinedSource = StringUtils.replace((String)sourcePath, (String)MAVEN_SOURCES, (String)mavenSourcePaths.toString());
                if ((combinedSource = StringUtils.replace((String)combinedSource, (String)MAVEN_TEST_SOURCES, (String)mavenTestSourcePaths.toString())).length() > 0) {
                    analyzer.setProperty("-sourcepath", combinedSource);
                } else {
                    analyzer.unsetProperty("-sourcepath");
                }
            } else if (mavenSourcePaths.length() > 0) {
                log.warn((CharSequence)("-sourcepath: overriding " + mavenSourcePaths + " with " + sourcePath + " (add " + MAVEN_SOURCES + " if you want to include the maven sources)"));
            } else if (mavenTestSourcePaths.length() > 0) {
                log.warn((CharSequence)("-sourcepath: overriding " + mavenTestSourcePaths + " with " + sourcePath + " (add " + MAVEN_TEST_SOURCES + " if you want to include the maven test sources)"));
            }
        } else if (mavenSourcePaths.length() > 0) {
            analyzer.setProperty("-sourcepath", mavenSourcePaths.toString());
        }
    }

    static class ClassPathItem {
        final String id;
        final File file;

        public ClassPathItem(String id, File file) {
            this.id = id;
            this.file = file;
        }
    }
}

