/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.postgresql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.QueryFailedException;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandlerBase;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.dbms.postgresql.DBCommandPostgres;
import org.apache.empire.dbms.postgresql.PostgresDDLGenerator;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMSHandlerPostgreSQL
extends DBMSHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(DBMSHandlerPostgreSQL.class);
    protected static final String[] POSTGRES_KEYWORDS = new String[]{"ALL", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASYMMETRIC", "AUTHORIZATION", "BETWEEN", "BINARY", "BOTH", "CASE", "CAST", "CHECK", "COLLATE", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "EXCEPT", "FALSE", "FOR", "FOREIGN", "FREEZE", "FROM", "FULL", "GRANT", "HAVING", "ILIKE", "IN", "INITIALLY", "INNER", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NEW", "NOT", "NOTNULL", "NULL", "OFF", "OFFSET", "OLD", "ON", "ONLY", "OR", "ORDER", "OUTER", "OVERLAPS", "PLACING", "PRIMARY", "REFERENCES", "RETURNING", "RIGHT", "SESSION_USER", "SIMILAR", "SOME", "SYMMETRIC", "THEN", "TO", "TRAILING", "TRUE", "UNION", "UNIQUE", "USING", "VERBOSE", "WHEN", "WHERE", "WITH"};
    private String databaseName;
    private boolean usePostgresSerialType = true;
    private DBDDLGenerator<?> ddlGenerator = null;

    public DBMSHandlerPostgreSQL() {
        super(POSTGRES_KEYWORDS);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isUsePostgresSerialType() {
        return this.usePostgresSerialType;
    }

    public void setUsePostgresSerialType(boolean usePostgresSerialType) {
        this.usePostgresSerialType = usePostgresSerialType;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public void attachDatabase(DBDatabase db, Connection conn) {
        super.attachDatabase(db, conn);
        if (this.isUsePostgresSerialType()) {
            this.initSerialSequenceNames(db, conn);
        }
    }

    @Override
    public DBCommandPostgres createCommand(boolean autoPrepareStmt) {
        return new DBCommandPostgres(this, autoPrepareStmt);
    }

    @Override
    public boolean isSupported(DBMSFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return true;
            }
            case SEQUENCES: {
                return true;
            }
            case SEQUENCE_NEXTVAL: {
                return true;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSQLPhrase(DBSqlPhrase phrase) {
        switch (phrase) {
            case SQL_NULL: {
                return "null";
            }
            case SQL_PARAMETER: {
                return " ? ";
            }
            case SQL_RENAME_TABLE: {
                return " ";
            }
            case SQL_RENAME_COLUMN: {
                return " AS ";
            }
            case SQL_DATABASE_LINK: {
                return "@";
            }
            case SQL_QUOTES_OPEN: {
                return "\"";
            }
            case SQL_QUOTES_CLOSE: {
                return "\"";
            }
            case SQL_CONCAT_EXPR: {
                return "? || {0}";
            }
            case SQL_BOOLEAN_TRUE: {
                return "TRUE";
            }
            case SQL_BOOLEAN_FALSE: {
                return "FALSE";
            }
            case SQL_CURRENT_DATE: {
                return "CURRENT_DATE";
            }
            case SQL_DATE_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_CURRENT_TIME: {
                return "CURRENT_TIME";
            }
            case SQL_TIME_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_CURRENT_DATETIME: {
                return "NOW()";
            }
            case SQL_DATETIME_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_CURRENT_TIMESTAMP: {
                return "NOW()";
            }
            case SQL_TIMESTAMP_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_FUNC_COALESCE: {
                return "coalesce(?, {0})";
            }
            case SQL_FUNC_SUBSTRING: {
                return "substring(?, {0:INTEGER})";
            }
            case SQL_FUNC_SUBSTRINGEX: {
                return "substring(?, {0:INTEGER}, {1:INTEGER})";
            }
            case SQL_FUNC_REPLACE: {
                return "replace(?, {0}, {1})";
            }
            case SQL_FUNC_REVERSE: {
                return "reverse(?)";
            }
            case SQL_FUNC_STRINDEX: {
                return "strpos(?, {0})";
            }
            case SQL_FUNC_STRINDEXFROM: {
                return null;
            }
            case SQL_FUNC_LENGTH: {
                return "length(?)";
            }
            case SQL_FUNC_UPPER: {
                return "upper(?)";
            }
            case SQL_FUNC_LOWER: {
                return "lower(?)";
            }
            case SQL_FUNC_TRIM: {
                return "trim(?)";
            }
            case SQL_FUNC_LTRIM: {
                return "ltrim(?)";
            }
            case SQL_FUNC_RTRIM: {
                return "rtrim(?)";
            }
            case SQL_FUNC_ESCAPE: {
                return "? escape {0:VARCHAR}";
            }
            case SQL_FUNC_CONTAINS: {
                return "to_tsvector(?) @@ to_tsquery({0:VARCHAR})";
            }
            case SQL_FUNC_ABS: {
                return "abs(?)";
            }
            case SQL_FUNC_ROUND: {
                return "round(?,{0})";
            }
            case SQL_FUNC_TRUNC: {
                return "truncate(?,{0})";
            }
            case SQL_FUNC_CEILING: {
                return "ceiling(?)";
            }
            case SQL_FUNC_FLOOR: {
                return "floor(?)";
            }
            case SQL_FUNC_MOD: {
                return "mod(?,{0})";
            }
            case SQL_FUNC_FORMAT: {
                return "format({0:VARCHAR}, ?)";
            }
            case SQL_FUNC_DAY: {
                return "extract(day from ?)";
            }
            case SQL_FUNC_MONTH: {
                return "extract(month from ?)";
            }
            case SQL_FUNC_YEAR: {
                return "extract(year from ?)";
            }
            case SQL_FUNC_SUM: {
                return "sum(?)";
            }
            case SQL_FUNC_MAX: {
                return "max(?)";
            }
            case SQL_FUNC_MIN: {
                return "min(?)";
            }
            case SQL_FUNC_AVG: {
                return "avg(?)";
            }
            case SQL_FUNC_STRAGG: {
                return "STRING_AGG(DISTINCT ? {0} ORDER BY {1})";
            }
            case SQL_FUNC_DECODE: {
                return "case ? {0} end";
            }
            case SQL_FUNC_DECODE_SEP: {
                return " ";
            }
            case SQL_FUNC_DECODE_PART: {
                return "when {0} then {1}";
            }
            case SQL_FUNC_DECODE_ELSE: {
                return "else {0}";
            }
        }
        return phrase.getSqlDefault();
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case BOOL: {
                return "CAST(? AS BOOL)";
            }
            case INTEGER: {
                return "CAST(? AS INTEGER)";
            }
            case DECIMAL: {
                return "CAST(? AS DECIMAL)";
            }
            case FLOAT: {
                return "CAST(? AS DOUBLE PRECISION)";
            }
            case DATE: {
                return "CAST(? AS DATE)";
            }
            case TIME: {
                return "CAST(? AS TIME)";
            }
            case DATETIME: 
            case TIMESTAMP: {
                return "CAST(? AS TIMESTAMP)";
            }
            case VARCHAR: 
            case CHAR: {
                if (format instanceof String) {
                    return "to_char(?, '" + format.toString() + "')";
                }
                return "?::text";
            }
            case BLOB: {
                return "CAST(? AS bytea)";
            }
            case CLOB: {
                return "CAST(? AS TEXT)";
            }
        }
        log.error("getConvertPhrase: unknown type (" + String.valueOf((Object)destType));
        return "?";
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        String sqlCmd = "SELECT nextval(?)";
        try {
            Object val = this.querySingleValue(sqlCmd, new Object[]{seqName}, DataType.INTEGER, conn);
            if (val == null) {
                log.error("getNextSequenceValue: Invalid sequence value for sequence " + seqName);
            }
            return val;
        }
        catch (SQLException sqle) {
            throw new QueryFailedException(this, sqlCmd, seqName, sqle);
        }
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        String seqName = StringUtils.toString(column.getDefaultValue());
        if (StringUtils.isEmpty(seqName)) {
            throw new InvalidArgumentException("column", column);
        }
        DBSQLBuilder sql = this.createSQLBuilder();
        sql.append("nextval('");
        column.getDatabase().appendQualifiedName(sql, seqName, false);
        sql.append("')");
        return column.getDatabase().getValueExpr(sql.toString(), DataType.INTEGER);
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    public PostgresDDLGenerator getDDLGenerator() {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new PostgresDDLGenerator(this);
        }
        return (PostgresDDLGenerator)this.ddlGenerator;
    }

    @Override
    public void getDDLScript(DBDDLGenerator.DDLActionType type, DBObject dbo, DBSQLScript script) {
        this.getDDLGenerator().getDDLScript(type, dbo, script);
    }

    @Override
    public Object getResultValue(ResultSet rset, int columnIndex, DataType dataType) throws SQLException {
        switch (dataType) {
            case BLOB: {
                return rset.getBytes(columnIndex);
            }
            case CLOB: {
                return rset.getString(columnIndex);
            }
        }
        return super.getResultValue(rset, columnIndex, dataType);
    }

    protected void initSerialSequenceNames(DBDatabase db, Connection conn) {
        HashMap<String, DBTableColumn> identiyColumns = new HashMap<String, DBTableColumn>();
        for (DBTable t : db.getTables()) {
            DBColumn[] key = t.getKeyColumns();
            if (key == null || key.length <= 0 || key[0].getDataType() != DataType.AUTOINC) continue;
            String name = key[0].getFullName();
            DBTableColumn col = (DBTableColumn)key[0];
            identiyColumns.put(name, col);
            log.info("Initial sequence name for {} is {}", (Object)name, col.getDefaultValue());
        }
        if (conn == null) {
            return;
        }
        for (DBTableColumn col : identiyColumns.values()) {
            String seqName = this.getSequenceName(col, conn);
            col.setDefaultValue(seqName);
            log.info("New sequence name for {} is {}", (Object)col.getFullName(), (Object)seqName);
        }
    }

    private String getSequenceName(DBTableColumn column, Connection conn) {
        String sqlCmd = "SELECT pg_get_serial_sequence(?, ?)";
        Object[] sqlParams = new Object[]{column.getRowSet().getName().toLowerCase(), column.getName().toLowerCase()};
        try {
            String seqName = StringUtils.toString(this.querySingleValue(sqlCmd, sqlParams, DataType.VARCHAR, conn));
            if (seqName == null) {
                log.error("getNextSequenceName: Invalid sequence value for column " + column.getName());
            }
            return seqName;
        }
        catch (SQLException sqle) {
            throw new QueryFailedException(this, sqlCmd, StringUtils.arrayToString(sqlParams), sqle);
        }
    }
}

