/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Collection;
import java.util.Map;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public abstract class DBCaseExpr
extends DBColumnExpr {
    private final DBDatabase database;
    private DBRowSet rowset;
    private boolean aggregateFunc;
    private DBColumn updateColumn = null;
    private DataType dataType = DataType.UNKNOWN;
    private Class<Enum<?>> enumType = null;

    protected DBCaseExpr(DBDatabase db) {
        this.database = db;
        this.rowset = null;
        this.aggregateFunc = false;
    }

    protected DBCaseExpr(DBColumnExpr caseExpr) {
        if (caseExpr == null) {
            throw new InvalidArgumentException("caseExpr", caseExpr);
        }
        this.database = caseExpr.getDatabase();
        this.rowset = caseExpr.getRowSet();
        this.aggregateFunc = caseExpr.isAggregate();
    }

    public final DBDatabase getDatabase() {
        return this.database;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return this.enumType;
    }

    @Override
    public DBRowSet getRowSet() {
        return this.rowset;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.updateColumn;
    }

    @Override
    public boolean isAggregate() {
        return this.aggregateFunc;
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, this.getDataType());
        }
        elem.setAttribute("function", "case");
        return elem;
    }

    protected boolean isNull(Object value) {
        return value == null || value instanceof DBValueExpr && ((DBValueExpr)value).getValue() == null;
    }

    protected boolean isNotNull(Object value) {
        return !this.isNull(value);
    }

    protected void init(Map<?, ?> valueMap, Object elseValue) {
        DBColumnExpr sourceExpr = this.getSourceColumnExpr(valueMap.values(), elseValue);
        if (sourceExpr != null) {
            this.rowset = sourceExpr.getRowSet();
            this.updateColumn = sourceExpr.getUpdateColumn();
            this.dataType = sourceExpr.getDataType();
            this.enumType = sourceExpr.getEnumType();
        }
        for (Map.Entry<?, ?> entry : valueMap.entrySet()) {
            Object value;
            Object key = entry.getKey();
            if (key instanceof DBCompareExpr && this.rowset == null) {
                this.rowset = ((DBCompareExpr)key).getRowSet();
            }
            if (key instanceof DBCompareColExpr) {
                key = ((DBCompareColExpr)key).getColumnExpr();
            }
            if (key instanceof DBColumnExpr && ((DBColumnExpr)key).isAggregate()) {
                this.aggregateFunc = true;
            }
            if ((value = entry.getValue()) instanceof DBColumnExpr && ((DBColumnExpr)entry.getValue()).isAggregate()) {
                this.aggregateFunc = true;
            }
            if (this.dataType != DataType.UNKNOWN) continue;
            this.initDataTypeFromValue(value);
        }
        if (this.dataType == DataType.UNKNOWN) {
            this.initDataTypeFromValue(elseValue);
        }
    }

    protected DBColumnExpr getSourceColumnExpr(Collection<?> values, Object elseValue) {
        for (Object val : values) {
            if (!(val instanceof DBColumnExpr) || val instanceof DBValueExpr) continue;
            return (DBColumnExpr)val;
        }
        if (elseValue instanceof DBColumnExpr && !(elseValue instanceof DBValueExpr)) {
            return (DBColumnExpr)elseValue;
        }
        return null;
    }

    protected void initDataTypeFromValue(Object value) {
        if (value instanceof Enum) {
            this.enumType = value.getClass();
            this.dataType = DataType.VARCHAR;
        } else if (value instanceof DBColumnExpr) {
            this.dataType = ((DBColumnExpr)value).getDataType();
            this.enumType = ((DBColumnExpr)value).getEnumType();
        } else if (!this.isNull(value) && !(value instanceof DBExpr)) {
            this.dataType = DataType.fromJavaType(value.getClass());
        }
    }
}

