/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import org.apache.empire.commons.StringUtils;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBTable;

public class DBIndex
extends DBObject {
    private String name;
    private DBIndexType type;
    private DBColumn[] columns;
    private DBTable table;
    private String options;

    public DBIndex(String name, DBIndexType type, DBColumn[] columns) {
        this.name = name;
        this.type = type;
        this.columns = columns;
    }

    public DBTable getTable() {
        return this.table;
    }

    void setTable(DBTable table) {
        this.table = table;
    }

    public DBDatabase getDatabase() {
        return this.table != null ? this.table.getDatabase() : null;
    }

    public String getName() {
        return this.name;
    }

    public DBColumn[] getColumns() {
        return this.columns;
    }

    public DBColumn getColumn(int index) {
        return this.columns[index];
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public boolean compareColumns(DBColumn[] columns) {
        if (columns == null || columns.length != this.columns.length) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].equals(this.columns[i])) continue;
            return false;
        }
        return true;
    }

    public DBColumnExpr[] getExpressions() {
        return this.columns;
    }

    public String getFullName() {
        String schema = this.getDatabase().getSchema();
        return schema != null ? StringUtils.concat(schema, ".", this.name) : this.name;
    }

    public DBIndexType getType() {
        return this.type;
    }

    public String getOptions() {
        return this.options;
    }

    public DBIndex setOptions(String options) {
        this.options = options;
        return this;
    }

    public boolean contains(DBColumn col) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!col.equals(this.columns[i])) continue;
            return true;
        }
        return false;
    }

    public int getColumnPos(DBColumn col) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!col.equals(this.columns[i])) continue;
            return i;
        }
        return -1;
    }

    public static enum DBIndexType {
        STANDARD(false),
        FULLTEXT(false),
        UNIQUE(true),
        UNIQUE_ALLOW_NULL(true),
        PRIMARY_KEY(true);

        private final boolean unique;

        private DBIndexType(boolean unique) {
            this.unique = unique;
        }

        public boolean isUnique() {
            return this.unique;
        }
    }
}

