/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.commons.beanutils.MethodUtils;

public enum DataType {
    UNKNOWN,
    INTEGER,
    AUTOINC,
    VARCHAR,
    DATE,
    TIME,
    DATETIME,
    TIMESTAMP,
    CHAR,
    FLOAT,
    DECIMAL,
    BOOL,
    CLOB,
    BLOB,
    UNIQUEID;


    public boolean isText() {
        return this == VARCHAR || this == CHAR || this == CLOB;
    }

    public boolean isNumeric() {
        return this == INTEGER || this == DECIMAL || this == FLOAT || this == AUTOINC;
    }

    public boolean isDate() {
        return this == DATE || this == DATETIME || this == TIMESTAMP || this == TIME;
    }

    public boolean isBoolean() {
        return this == BOOL;
    }

    public boolean isCompatible(DataType other) {
        if (this == other) {
            return true;
        }
        if (this == UNKNOWN || other == UNKNOWN) {
            return true;
        }
        if (this.isText() && other.isText()) {
            return true;
        }
        if (this.isNumeric() && other.isNumeric()) {
            return true;
        }
        return this.isDate() && other.isDate();
    }

    public static DataType fromJavaType(Class<?> javaType) {
        if (javaType.isPrimitive()) {
            javaType = MethodUtils.getPrimitiveWrapper(javaType);
        }
        if (javaType == String.class) {
            return VARCHAR;
        }
        if (javaType == Character.class || javaType == Character[].class) {
            return CHAR;
        }
        if (javaType == Integer.class || javaType == Long.class || javaType == Short.class) {
            return INTEGER;
        }
        if (Number.class.isAssignableFrom(javaType)) {
            return DECIMAL;
        }
        if (javaType == Timestamp.class) {
            return TIMESTAMP;
        }
        if (Date.class.isAssignableFrom(javaType) || javaType == LocalDateTime.class) {
            return DATETIME;
        }
        if (javaType == LocalDate.class) {
            return DATE;
        }
        if (javaType == Boolean.class) {
            return BOOL;
        }
        if (javaType == byte[].class) {
            return BLOB;
        }
        return UNKNOWN;
    }
}

