/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.dolphinscheduler.api.enums;

import java.util.Locale;
import java.util.Optional;

import lombok.Getter;

import org.springframework.context.i18n.LocaleContextHolder;

/**
 * status enum      // todo #4855 One category one interval
 */
public enum Status {

    SUCCESS(0, "success", "成功"),

    INTERNAL_SERVER_ERROR_ARGS(10000, "Internal Server Error: {0}", "服务端异常: {0}"),

    REQUEST_PARAMS_NOT_VALID_ERROR(10001, "request parameter {0} is not valid", "请求参数[{0}]无效"),
    TASK_TIMEOUT_PARAMS_ERROR(10002, "task timeout parameter is not valid", "任务超时参数无效"),
    USER_NAME_EXIST(10003, "user name already exists", "用户名已存在"),
    USER_NAME_NULL(10004, "user name is null", "用户名不能为空"),
    HDFS_OPERATION_ERROR(10006, "hdfs operation error", "hdfs操作错误"),
    TASK_INSTANCE_NOT_FOUND(10008, "task instance not found", "任务实例不存在"),
    OS_TENANT_CODE_EXIST(10009, "os tenant code {0} already exists", "操作系统租户[{0}]已存在"),
    USER_NOT_EXIST(10010, "user {0} not exists", "用户[{0}]不存在"),
    ALERT_GROUP_NOT_EXIST(10011, "alarm group not found", "告警组不存在"),
    ALERT_GROUP_EXIST(10012, "alarm group already exists", "告警组名称已存在"),
    USER_NAME_PASSWD_ERROR(10013, "user name or password error", "用户名或密码错误"),
    LOGIN_SESSION_FAILED(10014, "create session failed!", "创建session失败"),
    DATASOURCE_EXIST(10015, "data source name already exists", "数据源名称已存在"),
    DATASOURCE_CONNECT_FAILED(10016, "data source connection failed", "建立数据源连接失败"),
    TENANT_NOT_EXIST(10017, "tenant [{0}] not exists", "租户[{0}]不存在"),
    PROJECT_NOT_FOUND(10018, "project {0} not found ", "项目[{0}]不存在"),
    PROJECT_ALREADY_EXISTS(10019, "project {0} already exists", "项目名称[{0}]已存在"),
    TASK_INSTANCE_NOT_EXISTS(10020, "task instance {0} does not exist", "任务实例[{0}]不存在"),
    TASK_INSTANCE_NOT_SUB_WORKFLOW_INSTANCE(10021, "task instance {0} is not sub workflow instance",
            "任务实例[{0}]不是子流程实例"),
    SCHEDULE_CRON_NOT_EXISTS(10022, "scheduler crontab {0} does not exist", "调度配置定时表达式[{0}]不存在"),
    SCHEDULE_CRON_ONLINE_FORBID_UPDATE(10023, "online status does not allow update operations", "调度配置上线状态不允许修改"),
    SCHEDULE_CRON_CHECK_FAILED(10024, "scheduler crontab expression validation failure: {0}", "调度配置定时表达式验证失败: {0}"),
    MASTER_NOT_EXISTS(10025, "master does not exist", "无可用master节点"),
    SCHEDULE_STATUS_UNKNOWN(10026, "unknown status: {0}", "未知状态: {0}"),
    CREATE_ALERT_GROUP_ERROR(10027, "create alert group error", "创建告警组错误"),
    QUERY_ALL_ALERTGROUP_ERROR(10028, "query all alertgroup error", "查询告警组错误"),
    LIST_PAGING_ALERT_GROUP_ERROR(10029, "list paging alert group error", "分页查询告警组错误"),
    UPDATE_ALERT_GROUP_ERROR(10030, "update alert group error", "更新告警组错误"),
    DELETE_ALERT_GROUP_ERROR(10031, "delete alert group error", "删除告警组错误"),
    ALERT_GROUP_GRANT_USER_ERROR(10032, "alert group grant user error", "告警组授权用户错误"),
    CREATE_DATASOURCE_ERROR(10033, "create datasource error", "创建数据源错误"),
    UPDATE_DATASOURCE_ERROR(10034, "update datasource error", "更新数据源错误"),
    QUERY_DATASOURCE_ERROR(10035, "query datasource error", "查询数据源错误"),
    CONNECT_DATASOURCE_FAILURE(10036, "connect datasource failure", "建立数据源连接失败"),
    CONNECTION_TEST_FAILURE(10037, "connection test failure", "测试数据源连接失败"),
    DELETE_DATA_SOURCE_FAILURE(10038, "delete data source failure", "删除数据源失败"),
    VERIFY_DATASOURCE_NAME_FAILURE(10039, "verify datasource name failure", "验证数据源名称失败"),
    UNAUTHORIZED_DATASOURCE(10040, "unauthorized datasource", "未经授权的数据源"),
    AUTHORIZED_DATA_SOURCE(10041, "authorized data source", "授权数据源失败"),
    LOGIN_SUCCESS(10042, "login success", "登录成功"),
    USER_LOGIN_FAILURE(10043, "user login failure", "用户登录失败"),
    LIST_WORKERS_ERROR(10044, "list workers error", "查询worker列表错误"),
    LIST_MASTERS_ERROR(10045, "list masters error", "查询master列表错误"),
    UPDATE_PROJECT_ERROR(10046, "update project error", "更新项目信息错误"),
    QUERY_PROJECT_DETAILS_BY_CODE_ERROR(10047, "query project details by code error", "查询项目详细信息错误"),
    CREATE_PROJECT_ERROR(10048, "create project error", "创建项目错误"),
    LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR(10049, "login user query project list paging error", "分页查询项目列表错误"),
    DELETE_PROJECT_ERROR(10050, "delete project error", "删除项目错误"),
    QUERY_UNAUTHORIZED_PROJECT_ERROR(10051, "query unauthorized project error", "查询未授权项目错误"),
    QUERY_AUTHORIZED_PROJECT(10052, "query authorized project", "查询授权项目错误"),
    QUERY_QUEUE_LIST_ERROR(10053, "query queue list error", "查询队列列表错误"),
    CREATE_RESOURCE_ERROR(10054, "create resource error", "创建资源错误"),
    UPDATE_RESOURCE_ERROR(10055, "update resource error", "更新资源错误"),
    QUERY_RESOURCES_LIST_ERROR(10056, "query resources list error", "查询资源列表错误"),
    QUERY_RESOURCES_LIST_PAGING(10057, "query resources list paging", "分页查询资源列表错误"),
    DELETE_RESOURCE_ERROR(10058, "delete resource error", "删除资源错误"),
    VERIFY_RESOURCE_BY_NAME_AND_TYPE_ERROR(10059, "verify resource by name and type error", "资源名称或类型验证错误"),
    VIEW_RESOURCE_FILE_ON_LINE_ERROR(10060, "view resource file online error", "查看资源文件错误"),
    CREATE_RESOURCE_FILE_ON_LINE_ERROR(10061, "create resource file online error", "创建资源文件错误"),
    RESOURCE_FILE_IS_EMPTY(10062, "resource file is empty", "资源文件内容不能为空"),
    EDIT_RESOURCE_FILE_ON_LINE_ERROR(10063, "edit resource file online error", "更新资源文件错误"),
    DOWNLOAD_RESOURCE_FILE_ERROR(10064, "download resource file error", "下载资源文件错误"),
    QUERY_DATASOURCE_BY_TYPE_ERROR(10069, "query datasource by type error", "查询数据源信息错误"),
    AUTHORIZED_FILE_RESOURCE_ERROR(10072, "authorized file resource error", "授权资源文件错误"),
    AUTHORIZE_RESOURCE_TREE(10073, "authorize resource tree display error", "授权资源目录树错误"),
    CREATE_SCHEDULE_ERROR(10076, "create schedule error", "创建调度配置错误"),
    UPDATE_SCHEDULE_ERROR(10077, "update schedule error", "更新调度配置错误"),
    PUBLISH_SCHEDULE_ONLINE_ERROR(10078, "publish schedule online error", "上线调度配置错误"),
    OFFLINE_SCHEDULE_ERROR(10079, "offline schedule error", "下线调度配置错误"),
    QUERY_SCHEDULE_LIST_PAGING_ERROR(10080, "query schedule list paging error", "分页查询调度配置列表错误"),
    QUERY_SCHEDULE_LIST_ERROR(10081, "query schedule list error", "查询调度配置列表错误"),
    QUERY_TASK_LIST_PAGING_ERROR(10082, "query task list paging error", "分页查询任务列表错误"),
    QUERY_TASK_RECORD_LIST_PAGING_ERROR(10083, "query task record list paging error", "分页查询任务记录错误"),
    CREATE_TENANT_ERROR(10084, "create tenant error", "创建租户错误"),
    QUERY_TENANT_LIST_PAGING_ERROR(10085, "query tenant list paging error", "分页查询租户列表错误"),
    QUERY_TENANT_LIST_ERROR(10086, "query tenant list error", "查询租户列表错误"),
    UPDATE_TENANT_ERROR(10087, "update tenant error", "更新租户错误"),
    DELETE_TENANT_BY_ID_ERROR(10088, "delete tenant by id error", "删除租户错误"),
    VERIFY_OS_TENANT_CODE_ERROR(10089, "verify os tenant code error", "操作系统租户验证错误"),
    CREATE_USER_ERROR(10090, "create user error", "创建用户错误"),
    QUERY_USER_LIST_PAGING_ERROR(10091, "query user list paging error", "分页查询用户列表错误"),
    UPDATE_USER_ERROR(10092, "update user error", "更新用户错误"),
    DELETE_USER_BY_ID_ERROR(10093, "delete user by id error", "删除用户错误"),
    GRANT_PROJECT_ERROR(10094, "grant project error", "授权项目错误"),
    GRANT_RESOURCE_ERROR(10095, "grant resource error", "授权资源错误"),
    GRANT_DATASOURCE_ERROR(10097, "grant datasource error", "授权数据源错误"),
    GET_USER_INFO_ERROR(10098, "get user info error", "获取用户信息错误"),
    USER_LIST_ERROR(10099, "user list error", "查询用户列表错误"),
    VERIFY_USERNAME_ERROR(10100, "verify username error", "用户名验证错误"),
    UNAUTHORIZED_USER_ERROR(10101, "unauthorized user error", "查询未授权用户错误"),
    AUTHORIZED_USER_ERROR(10102, "authorized user error", "查询授权用户错误"),
    QUERY_TASK_INSTANCE_LOG_ERROR(10103, "view task instance log error: {0}", "查询任务实例日志错误: {0}"),
    DOWNLOAD_TASK_INSTANCE_LOG_FILE_ERROR(10104, "download task instance log file error", "下载任务日志文件错误"),
    CREATE_WORKFLOW_DEFINITION_ERROR(10105, "create workflow definition error", "创建工作流错误"),
    VERIFY_WORKFLOW_DEFINITION_NAME_UNIQUE_ERROR(10106, "verify workflow definition name unique error", "工作流定义名称验证错误"),
    UPDATE_WORKFLOW_DEFINITION_ERROR(10107, "update workflow definition error", "更新工作流定义错误"),
    RELEASE_WORKFLOW_DEFINITION_ERROR(10108, "release workflow definition error", "上线工作流错误"),
    QUERY_DETAIL_OF_WORKFLOW_DEFINITION_ERROR(10109, "query detail of workflow definition error", "查询工作流详细信息错误"),
    QUERY_WORKFLOW_DEFINITION_LIST(10110, "query workflow definition list", "查询工作流列表错误"),
    ENCAPSULATION_TREEVIEW_STRUCTURE_ERROR(10111, "encapsulation treeview structure error", "查询工作流树形图数据错误"),
    GET_TASKS_LIST_BY_WORKFLOW_DEFINITION_CODE_ERROR(10112, "get tasks list by workflow definition code error",
            "查询工作流定义节点信息错误"),
    QUERY_WORKFLOW_INSTANCE_LIST_PAGING_ERROR(10113, "query workflow instance list paging error", "分页查询工作流实例列表错误"),
    QUERY_TASK_LIST_BY_WORKFLOW_INSTANCE_ID_ERROR(10114, "query task list by workflow instance id error", "查询任务实例列表错误"),
    UPDATE_WORKFLOW_INSTANCE_ERROR(10115, "update workflow instance error", "更新工作流实例错误"),
    QUERY_WORKFLOW_INSTANCE_BY_ID_ERROR(10116, "query workflow instance by id error", "查询工作流实例错误"),
    DELETE_WORKFLOW_INSTANCE_BY_ID_ERROR(10117, "delete workflow instance by id error", "删除工作流实例错误"),
    QUERY_SUB_WORKFLOW_INSTANCE_DETAIL_INFO_BY_TASK_ID_ERROR(10118,
            "query sub workflow instance detail info by task id error", "查询子流程任务实例错误"),
    QUERY_PARENT_WORKFLOW_INSTANCE_DETAIL_INFO_BY_SUB_WORKFLOW_INSTANCE_ID_ERROR(10119,
            "query parent workflow instance detail info by sub workflow instance id error", "查询子流程该工作流实例错误"),
    QUERY_WORKFLOW_INSTANCE_ALL_VARIABLES_ERROR(10120, "query workflow instance all variables error", "查询工作流自定义变量信息错误"),
    ENCAPSULATION_WORKFLOW_INSTANCE_GANTT_STRUCTURE_ERROR(10121,
            "encapsulation workflow instance gantt structure error",
            "查询工作流实例甘特图数据错误"),
    QUERY_WORKFLOW_DEFINITION_LIST_PAGING_ERROR(10122, "query workflow definition list paging error", "分页查询工作流定义列表错误"),
    SIGN_OUT_ERROR(10123, "sign out error", "退出错误"),
    OS_TENANT_CODE_HAS_ALREADY_EXISTS(10124, "os tenant code has already exists", "操作系统租户已存在"),
    IP_IS_EMPTY(10125, "ip is empty", "IP地址不能为空"),
    SCHEDULE_CRON_REALEASE_NEED_NOT_CHANGE(10126, "schedule release is already {0}", "调度配置上线错误[{0}]"),
    CREATE_QUEUE_ERROR(10127, "create queue error", "创建队列错误"),
    QUEUE_NOT_EXIST(10128, "queue {0} not exists", "队列ID[{0}]不存在"),
    QUEUE_VALUE_EXIST(10129, "queue value {0} already exists", "队列值[{0}]已存在"),
    QUEUE_NAME_EXIST(10130, "queue name {0} already exists", "队列名称[{0}]已存在"),
    UPDATE_QUEUE_ERROR(10131, "update queue error", "更新队列信息错误"),
    NEED_NOT_UPDATE_QUEUE(10132, "no content changes, no updates are required", "数据未变更，不需要更新队列信息"),
    VERIFY_QUEUE_ERROR(10133, "verify queue error", "验证队列信息错误"),
    NAME_NULL(10134, "name must be not null", "名称不能为空"),
    NAME_EXIST(10135, "name {0} already exists", "名称[{0}]已存在"),
    SAVE_ERROR(10136, "save error", "保存错误"),
    DELETE_PROJECT_ERROR_DEFINES_NOT_NULL(10137, "please delete the workflow definitions in project first!",
            "请先删除全部工作流定义"),
    QUERY_ALL_WORKFLOW_COUNT_ERROR(10138, "query all workflow count error", "查询所有工作流数量错误"),
    QUERY_WORKFLOW_STATES_COUNT_ERROR(10139, "query all workflow states count error", "查询所有工作流状态数量错误"),
    QUERY_ONE_WORKFLOW_STATE_COUNT_ERROR(10140, "query one workflow state count error", "查询工作流状态数量错误"),
    QUERY_TASK_STATES_COUNT_ERROR(10141, "query all task states count error", "查询所有任务状态数量错误"),
    QUERY_ONE_TASK_STATES_COUNT_ERROR(10142, "query one task states count error", "查询任务状态数量错误"),
    BATCH_DELETE_WORKFLOW_INSTANCE_BY_IDS_ERROR(10117, "batch delete workflow instance by ids {0} error",
            "批量删除工作流实例错误: {0}"),
    PREVIEW_SCHEDULE_ERROR(10139, "preview schedule error", "预览调度配置错误"),
    PARSE_TO_CRON_EXPRESSION_ERROR(10140, "parse cron to cron expression error", "解析调度表达式错误"),
    SCHEDULE_START_TIME_END_TIME_SAME(10141, "The start time must not be the same as the end", "开始时间不能和结束时间一样"),
    DELETE_TENANT_BY_ID_FAIL(10142,
            "delete tenant by id fail, for there are {0} workflow instances in executing using it",
            "删除租户失败，有[{0}]个运行中的工作流实例正在使用"),
    DELETE_TENANT_BY_ID_FAIL_DEFINES(10143, "delete tenant by id fail, for there are {0} workflow definitions using it",
            "删除租户失败，有[{0}]个工作流定义正在使用"),
    DELETE_TENANT_BY_ID_FAIL_USERS(10144, "delete tenant by id fail, for there are {0} users using it",
            "删除租户失败，有[{0}]个用户正在使用"),
    DELETE_WORKER_GROUP_BY_ID_FAIL(10145,
            "delete worker group by id fail, for there are {0} workflow instances in executing using it",
            "删除Worker分组失败，有[{0}]个运行中的工作流实例正在使用"),
    QUERY_WORKER_GROUP_FAIL(10146, "query worker group fail ", "查询worker分组失败"),
    DELETE_WORKER_GROUP_FAIL(10147, "delete worker group fail ", "删除worker分组失败"),
    USER_DISABLED(10148, "The current user is disabled", "当前用户已停用"),
    COPY_WORKFLOW_DEFINITION_ERROR(10149, "copy workflow definition from {0} to {1} error : {2}",
            "从{0}复制工作流到{1}错误 : {2}"),
    MOVE_WORKFLOW_DEFINITION_ERROR(10150, "move workflow definition from {0} to {1} error : {2}",
            "从{0}移动工作流到{1}错误 : {2}"),
    SWITCH_WORKFLOW_DEFINITION_VERSION_ERROR(10151, "Switch workflow definition version error", "切换工作流版本出错"),
    SWITCH_WORKFLOW_DEFINITION_VERSION_NOT_EXIST_WORKFLOW_DEFINITION_ERROR(10152,
            "Switch workflow definition version error: not exists workflow definition, [workflow definition id {0}]",
            "切换工作流版本出错：工作流不存在，[工作流id {0}]"),
    SWITCH_WORKFLOW_DEFINITION_VERSION_NOT_EXIST_WORKFLOW_DEFINITION_VERSION_ERROR(10153,
            "Switch workflow definition version error: not exists workflow definition version, [workflow definition id {0}] [version number {1}]",
            "切换工作流版本出错：工作流版本信息不存在，[工作流id {0}] [版本号 {1}]"),
    QUERY_WORKFLOW_DEFINITION_VERSIONS_ERROR(10154, "query workflow definition versions error", "查询工作流历史版本信息出错"),
    DELETE_WORKFLOW_DEFINITION_VERSION_ERROR(10156, "delete workflow definition version error", "删除工作流历史版本出错"),

    QUERY_USER_CREATED_PROJECT_ERROR(10157, "query user created project error error", "查询用户创建的项目错误"),
    WORKFLOW_DEFINITION_CODES_IS_EMPTY(10158, "workflow definition codes is empty", "工作流CODES不能为空"),
    BATCH_COPY_WORKFLOW_DEFINITION_ERROR(10159, "batch copy workflow definition error", "复制工作流错误"),
    BATCH_MOVE_WORKFLOW_DEFINITION_ERROR(10160, "batch move workflow definition error", "移动工作流错误"),
    QUERY_WORKFLOW_LINEAGE_ERROR(10161, "query workflow lineage error", "查询血缘失败"),
    QUERY_AUTHORIZED_AND_USER_CREATED_PROJECT_ERROR(10162, "query authorized and user created project error error",
            "查询授权的和用户创建的项目错误"),
    DELETE_WORKFLOW_DEFINITION_EXECUTING_FAIL(10163,
            "delete workflow definition by code fail, for there are {0} workflow instances in executing using it",
            "删除工作流定义失败，有[{0}]个运行中的工作流实例正在使用"),
    CHECK_OS_TENANT_CODE_ERROR(10164, "Tenant code invalid, should follow linux's users naming conventions",
            "非法的租户名，需要遵守 Linux 用户命名规范"),
    FORCE_TASK_SUCCESS_ERROR(10165, "force task success error", "强制成功任务实例错误"),
    TASK_INSTANCE_STATE_OPERATION_ERROR(10166,
            "the status of task instance {0} is {1},Cannot perform force success operation",
            "任务实例[{0}]的状态是[{1}]，无法执行强制成功操作"),
    DATASOURCE_TYPE_NOT_EXIST(10167, "data source type not exist", "数据源类型不存在"),
    WORKFLOW_DEFINITION_NAME_EXIST(10168, "workflow definition name {0} already exists", "工作流定义名称[{0}]已存在"),
    DATASOURCE_DB_TYPE_ILLEGAL(10169, "datasource type illegal", "数据源类型参数不合法"),
    DATASOURCE_PORT_ILLEGAL(10170, "datasource port illegal", "数据源端口参数不合法"),
    DATASOURCE_OTHER_PARAMS_ILLEGAL(10171, "datasource other params illegal", "数据源其他参数不合法"),
    DATASOURCE_NAME_ILLEGAL(10172, "datasource name illegal", "数据源名称不合法"),
    DATASOURCE_HOST_ILLEGAL(10173, "datasource host illegal", "数据源HOST不合法"),
    DELETE_WORKER_GROUP_NOT_EXIST(10174, "delete worker group not exist ", "删除worker分组不存在"),
    CREATE_WORKER_GROUP_FORBIDDEN_IN_DOCKER(10175, "create worker group forbidden in docker ", "创建worker分组在docker中禁止"),
    DELETE_WORKER_GROUP_FORBIDDEN_IN_DOCKER(10176, "delete worker group forbidden in docker ", "删除worker分组在docker中禁止"),
    WORKER_ADDRESS_INVALID(10177, "worker address {0} invalid", "worker地址[{0}]无效"),
    QUERY_WORKER_ADDRESS_LIST_FAIL(10178, "query worker address list fail ", "查询worker地址列表失败"),
    TRANSFORM_PROJECT_OWNERSHIP(10179, "Please transform project ownership [{0}]", "请先转移项目所有权[{0}]"),
    QUERY_ALERT_GROUP_ERROR(10180, "query alert group error", "查询告警组错误"),
    CURRENT_LOGIN_USER_TENANT_NOT_EXIST(10181, "the tenant of the currently login user is not specified",
            "未指定当前登录用户的租户"),
    REVOKE_PROJECT_ERROR(10182, "revoke project error", "撤销项目授权错误"),
    QUERY_AUTHORIZED_USER(10183, "query authorized user error", "查询拥有项目权限的用户错误"),
    PROJECT_NOT_EXIST(10190, "This project was not found. Please refresh page.", "该项目不存在,请刷新页面"),
    TASK_INSTANCE_HOST_IS_NULL(10191, "task instance host is null", "任务实例host为空"),
    QUERY_EXECUTING_WORKFLOW_ERROR(10192, "query executing workflow error", "查询运行的工作流实例错误"),
    DELETE_WORKFLOW_DEFINITION_USE_BY_OTHER_FAIL(10193,
            "delete workflow definition fail, cause used by other tasks: {0}",
            "删除工作流定义失败，被其他任务引用：{0}"),
    DELETE_TASK_USE_BY_OTHER_FAIL(10194, "delete task {0} fail, the reason is that used by other tasks: {1}",
            "删除任务 {0} 失败，被其他任务引用：{1}"),
    TASK_WITH_DEPENDENT_ERROR(10195, "task used in other tasks", "删除被其他任务引用"),
    TASK_SAVEPOINT_ERROR(10196, "task savepoint error", "任务实例savepoint错误"),
    TASK_STOP_ERROR(10197, "task stop error", "任务实例停止错误"),
    TASK_NAME_DUPLICATE_ERROR(10198, "task name {0} duplicate error", "同一个工作流中任务名称 {0} 重复"),
    LIST_TASK_TYPE_ERROR(10200, "list task type error", "查询任务类型列表错误"),
    DELETE_TASK_TYPE_ERROR(10200, "delete task type error", "删除任务类型错误"),
    ADD_TASK_TYPE_ERROR(10200, "add task type error", "添加任务类型错误"),
    CREATE_WORKFLOW_DEFINITION_LOG_ERROR(10201, "Create workflow definition log error",
            "创建 workflow definition log 对象失败"),
    PARSE_SCHEDULE_PARAM_ERROR(10202, "Parse schedule parameter error, {0}", "解析 schedule 参数错误, {0}"),
    SCHEDULE_NOT_EXISTS(10203, "schedule {0} does not exist", "调度 id {0} 不存在"),
    SCHEDULE_ALREADY_EXISTS(10204, "workflow {0} schedule {1} already exist, please update or delete it",
            "工作流 {0} 的定时 {1} 已经存在，请更新或删除"),
    QUERY_TASK_INSTANCE_ERROR(10205, "query task instance error", "查询任务实例错误"),
    EXECUTE_NOT_DEFINE_TASK(10206, "please save and try again",
            "请先保存后再执行"),

    DELETE_QUEUE_BY_ID_ERROR(10307, "delete queue by id error", "删除队列错误"),
    DELETE_QUEUE_BY_ID_FAIL_USERS(10308, "delete queue by id fail, for there are {0} users using it",
            "删除队列失败，有[{0}]个用户正在使用"),
    DELETE_TENANT_BY_ID_FAIL_TENANTS(10309, "delete queue by id fail, for there are {0} tenants using it",
            "删除队列失败，有[{0}]个租户正在使用"),
    START_NODE_NOT_EXIST_IN_LAST_WORKFLOW(10207, "this node {0} does not exist in the latest workflow definition",
            "该节点 {0} 不存在于最新的流程定义中"),
    LIST_AZURE_DATA_FACTORY_ERROR(10208, "list azure data factory error", "查询AZURE数据工厂列表错误"),
    LIST_AZURE_RESOURCE_GROUP_ERROR(10209, "list azure resource group error", "查询AZURE资源组列表错误"),
    LIST_AZURE_DATA_FACTORY_PIPELINE_ERROR(10210, "list azure data factory pipeline error", "查询AZURE数据工厂pipeline列表错误"),
    NOT_SUPPORT_SSO(10211, "Not support SSO login.", "不支持SSO登录"),
    STATE_CODE_ERROR(10212, "state inconsistency or state and code not pair", "状态码前后不一致或状态码和code不匹配"),

    CREATE_PROJECT_PARAMETER_ERROR(10214, "create project parameter error", "创建项目参数错误"),

    UPDATE_PROJECT_PARAMETER_ERROR(10215, "update project parameter error", "更新项目参数错误"),

    DELETE_PROJECT_PARAMETER_ERROR(10216, "delete project parameter error {0}", "删除项目参数错误 {0}"),

    QUERY_PROJECT_PARAMETER_ERROR(10217, "query project parameter error", "查询项目参数错误"),

    PROJECT_PARAMETER_ALREADY_EXISTS(10218, "project parameter {0} already exists", "项目参数[{0}]已存在"),

    PROJECT_PARAMETER_NOT_EXISTS(10219, "project parameter {0} not exists", "项目参数[{0}]不存在"),

    PROJECT_PARAMETER_CODE_EMPTY(10220, "project parameter code empty", "项目参数code为空"),
    CREATE_PROJECT_PREFERENCE_ERROR(10300, "create project preference error", "创建项目偏好设置错误"),

    UPDATE_PROJECT_PREFERENCE_ERROR(10301, "update project preference error", "更新项目偏好设置错误"),
    QUERY_PROJECT_PREFERENCE_ERROR(10302, "query project preference error", "查询项目偏好设置错误"),
    UPDATE_PROJECT_PREFERENCE_STATE_ERROR(10303, "Failed to update the state of the project preference", "更新项目偏好设置错误"),
    VERSION_INFO_STATE_ERROR(10304, "Failed to obtain project version and address", "获取版本信息错误"),

    OIDC_TOKEN_EXCHANGE_FAILED(15000, "OIDC token exchange failed", "OIDC令牌交换失败"),
    OIDC_ID_TOKEN_ISSUER_INVALID(15001, "Invalid issuer in OIDC ID token", "OIDC ID令牌的颁发者无效"),
    OIDC_ID_TOKEN_AUDIENCE_INVALID(15002, "Invalid audience in OIDC ID token", "OIDC ID令牌的受众无效"),
    OIDC_ID_TOKEN_EXPIRED(15003, "OIDC ID token has expired", "OIDC ID令牌已过期"),

    RESOURCE_NOT_EXIST(20004, "resource not exist", "资源不存在"),
    RESOURCE_EXIST(20005, "resource already exists", "资源已存在"),
    RESOURCE_SUFFIX_NOT_SUPPORT_VIEW(20006, "resource suffix do not support online viewing", "资源文件后缀不支持查看"),
    RESOURCE_SIZE_EXCEED_LIMIT(20007, "upload resource file size exceeds limit", "上传资源文件大小超过限制"),
    RESOURCE_SUFFIX_FORBID_CHANGE(20008, "resource suffix not allowed to be modified", "资源文件后缀不支持修改"),

    HDFS_COPY_FAIL(20010, "hdfs copy {0} -> {1} fail", "hdfs复制失败：[{0}] -> [{1}]"),
    RESOURCE_FILE_EXIST(20011, "resource file {0} already exists in hdfs,please delete it or change name!",
            "资源文件[{0}]在hdfs中已存在，请删除或修改资源名"),
    RESOURCE_FILE_NOT_EXIST(20012, "resource file {0} not exists !", "资源文件[{0}]不存在"),

    RESOURCE_IS_USED(20014, "resource file is used by workflow definition", "资源文件被上线的流程定义使用了"),
    PARENT_RESOURCE_NOT_EXIST(20015, "parent resource not exist", "父资源文件不存在"),

    RESOURCE_NOT_EXIST_OR_NO_PERMISSION(20016,
            "resource not exist or no permission,please view the task node and remove error resource",
            "请检查任务节点并移除无权限或者已删除的资源"),
    RESOURCE_IS_AUTHORIZED(20017, "resource is authorized to user {0},suffix not allowed to be modified",
            "资源文件已授权其他用户[{0}],后缀不允许修改"),
    RESOURCE_HAS_FOLDER(20018, "There are files or folders in the current directory:{0}", "当前目录下有文件或文件夹[{0}]"),

    ILLEGAL_RESOURCE_PATH(20020, "Resource file [{0}] is illegal", "非法的资源路径[{0}]"),

    USER_NO_OPERATION_PERM(30001, "user has no operation privilege", "当前用户没有操作权限"),
    USER_NO_OPERATION_PROJECT_PERM(30002, "user {0} is not has project {1} permission", "当前用户[{0}]没有[{1}]项目的操作权限"),
    USER_NO_WRITE_PROJECT_PERM(30003, "user [{0}] does not have write permission for project [{1}]",
            "当前用户[{0}]没有[{1}]项目的写权限"),

    WORKFLOW_INSTANCE_NOT_EXIST(50001, "workflow instance {0} does not exist", "工作流实例[{0}]不存在"),
    WORKFLOW_INSTANCE_EXIST(50002, "workflow instance {0} already exists", "工作流实例[{0}]已存在"),
    WORKFLOW_DEFINITION_NOT_EXIST(50003, "workflow definition {0} does not exist", "工作流定义[{0}]不存在"),
    WORKFLOW_DEFINITION_NOT_RELEASE(50004, "workflow definition {0} workflow version {1} not online",
            "工作流定义[{0}] 工作流版本[{1}]不是上线状态"),
    SUB_WORKFLOW_DEFINITION_NOT_RELEASE(50004, "exist sub workflow definition not online", "存在子工作流定义不是上线状态"),
    WORKFLOW_INSTANCE_ALREADY_CHANGED(50005, "the status of workflow instance {0} is already {1}",
            "工作流实例[{0}]的状态已经是[{1}]"),
    WORKFLOW_INSTANCE_STATE_OPERATION_ERROR(50006,
            "the status of workflow instance {0} is {1},Cannot perform {2} operation",
            "工作流实例[{0}]的状态是[{1}]，无法执行[{2}]操作"),
    SUB_WORKFLOW_INSTANCE_NOT_EXIST(50007, "the task belong to workflow instance does not exist", "子工作流实例不存在"),
    WORKFLOW_DEFINITION_NOT_ALLOWED_EDIT(50008, "workflow definition {0} does not allow edit", "工作流定义[{0}]不允许修改"),
    WORKFLOW_INSTANCE_EXECUTING_COMMAND(50009, "workflow instance {0} is executing the command, please wait ...",
            "工作流实例[{0}]正在执行命令，请稍等..."),
    WORKFLOW_INSTANCE_NOT_SUB_WORKFLOW_INSTANCE(50010, "workflow instance {0} is not sub workflow instance",
            "工作流实例[{0}]不是子工作流实例"),
    TASK_INSTANCE_STATE_COUNT_ERROR(50011, "task instance state count error", "查询各状态任务实例数错误"),
    COUNT_WORKFLOW_INSTANCE_STATE_ERROR(50012, "count workflow instance state error", "查询各状态流程实例数错误"),
    COUNT_WORKFLOW_DEFINITION_USER_ERROR(50013, "count workflow definition user error", "查询各用户流程定义数错误"),
    START_WORKFLOW_INSTANCE_ERROR(50014, "start workflow instance error", "运行工作流实例错误"),
    BATCH_START_WORKFLOW_INSTANCE_ERROR(50014, "batch start workflow instance error: {0}", "批量运行工作流实例错误: {0}"),
    WORKFLOW_INSTANCE_ERROR(50014, "workflow instance delete error: {0}", "工作流实例删除[{0}]错误"),
    EXECUTE_WORKFLOW_INSTANCE_ERROR(50015, "execute workflow instance error", "操作工作流实例错误"),
    CHECK_WORKFLOW_DEFINITION_ERROR(50016, "check workflow definition error", "工作流定义错误"),
    QUERY_RECIPIENTS_AND_COPYERS_BY_WORKFLOW_DEFINITION_ERROR(50017,
            "query recipients and copyers by workflow definition error", "查询收件人和抄送人错误"),
    DATA_IS_NOT_VALID(50017, "data {0} not valid", "数据[{0}]无效"),
    DATA_IS_NULL(50018, "data {0} is null", "数据[{0}]不能为空"),
    WORKFLOW_NODE_HAS_CYCLE(50019, "workflow node has cycle", "流程节点间存在循环依赖"),
    WORKFLOW_NODE_S_PARAMETER_INVALID(50020, "workflow node {0} parameter invalid", "流程节点[{0}]参数无效"),
    WORKFLOW_DEFINE_STATE_ONLINE(50021, "workflow definition [{0}] is already online", "工作流定义[{0}]已上线"),
    DELETE_WORKFLOW_DEFINE_BY_CODE_ERROR(50022, "delete workflow definition by code error", "删除工作流定义错误"),
    SCHEDULE_STATE_ONLINE(50023, "the status of schedule {0} is already online", "调度配置[{0}]已上线"),
    DELETE_SCHEDULE_BY_ID_ERROR(50024, "delete schedule by id error", "删除调度配置错误"),
    BATCH_DELETE_WORKFLOW_DEFINE_ERROR(50025, "batch delete workflow definition error", "批量删除工作流定义错误"),
    BATCH_DELETE_WORKFLOW_DEFINE_BY_CODES_ERROR(50026, "batch delete workflow definition by codes error: {0}",
            "批量删除工作流定义错误: {0}"),
    DELETE_WORKFLOW_DEFINE_BY_CODES_ERROR(50026, "delete workflow definition by codes error: {0}",
            "删除工作流定义错误: {0}"),
    TENANT_NOT_SUITABLE(50027, "there is not any tenant suitable, please choose a tenant available.",
            "没有合适的租户，请选择可用的租户"),
    EXPORT_WORKFLOW_DEFINE_BY_ID_ERROR(50028, "export workflow definition by id error", "导出工作流定义错误"),
    BATCH_EXPORT_WORKFLOW_DEFINE_BY_IDS_ERROR(50028, "batch export workflow definition by ids error", "批量导出工作流定义错误"),
    IMPORT_WORKFLOW_DEFINE_ERROR(50029, "import workflow definition error", "导入工作流定义错误"),
    TASK_DEFINE_NOT_EXIST(50030, "task definition [{0}] does not exist", "任务定义[{0}]不存在"),
    CREATE_WORKFLOW_TASK_RELATION_ERROR(50032, "create workflow task relation error", "创建工作流任务关系错误"),
    WORKFLOW_TASK_RELATION_NOT_EXIST(50033, "workflow task relation [{0}] does not exist", "工作流任务关系[{0}]不存在"),
    WORKFLOW_TASK_RELATION_EXIST(50034, "workflow task relation is already exist, workflowDefinitionCode:[{0}]",
            "工作流任务关系已存在, workflowDefinitionCode:[{0}]"),
    WORKFLOW_DAG_IS_EMPTY(50035, "workflow dag is empty", "工作流dag是空"),
    CHECK_WORKFLOW_TASK_RELATION_ERROR(50036, "check workflow task relation error", "工作流任务关系参数错误"),
    CREATE_TASK_DEFINITION_ERROR(50037, "create task definition error", "创建任务错误"),
    UPDATE_TASK_DEFINITION_ERROR(50038, "update task definition error", "更新任务定义错误"),
    QUERY_TASK_DEFINITION_VERSIONS_ERROR(50039, "query task definition versions error", "查询任务历史版本信息出错"),
    SWITCH_TASK_DEFINITION_VERSION_ERROR(50040, "Switch task definition version error", "切换任务版本出错"),
    DELETE_TASK_DEFINITION_VERSION_ERROR(50041, "delete task definition version error", "删除任务历史版本出错"),
    DELETE_TASK_DEFINE_BY_CODE_ERROR(50042, "delete task definition by code error", "删除任务定义错误"),
    QUERY_DETAIL_OF_TASK_DEFINITION_ERROR(50043, "query detail of task definition error", "查询任务详细信息错误"),
    QUERY_TASK_DEFINITION_LIST_PAGING_ERROR(50044, "query task definition list paging error", "分页查询任务定义列表错误"),
    TASK_DEFINITION_NAME_EXISTED(50045, "task definition name [{0}] already exists", "任务定义名称[{0}]已经存在"),
    RELEASE_TASK_DEFINITION_ERROR(50046, "release task definition error", "上线任务错误"),
    MOVE_WORKFLOW_TASK_RELATION_ERROR(50047, "move workflow task relation error", "移动任务到其他工作流错误"),
    DELETE_TASK_WORKFLOW_RELATION_ERROR(50048, "delete workflow task relation error", "删除工作流任务关系错误"),
    QUERY_TASK_WORKFLOW_RELATION_ERROR(50049, "query workflow task relation error", "查询工作流任务关系错误"),
    TASK_DEFINITION_STATE_ONLINE(50050, "task definition [{0}] is already online", "任务定义[{0}]已上线"),
    TASK_HAS_DOWNSTREAM(50051, "Task exists downstream [{0}] dependence", "任务存在下游[{0}]依赖"),
    TASK_HAS_UPSTREAM(50052, "Task [{0}] exists upstream dependence", "任务[{0}]存在上游依赖"),
    MAIN_TABLE_USING_VERSION(50053, "the version that the master table is using", "主表正在使用该版本"),
    PROJECT_WORKFLOW_NOT_MATCH(50054, "the project and the workflow is not match", "项目和工作流不匹配"),
    DELETE_EDGE_ERROR(50055, "delete edge error", "删除工作流任务连接线错误"),
    NOT_SUPPORT_UPDATE_TASK_DEFINITION(50056, "task state does not support modification", "当前任务不支持修改"),
    TASK_DEFINITION_NOT_MODIFY_ERROR(50057, "task [{0}] definition not modify error", "任务[{0}]定义未修改错误"),
    BATCH_EXECUTE_WORKFLOW_INSTANCE_ERROR(50058, "change workflow instance status error: {0}", "修改工作实例状态错误: {0}"),
    START_TASK_INSTANCE_ERROR(50059, "start task instance error", "运行任务流实例错误"),
    DELETE_WORKFLOW_DEFINE_ERROR(50060, "delete workflow definition [{0}] error: {1}", "删除工作流定义[{0}]错误: {1}"),
    CREATE_TASK_DEFINITION_LOG_ERROR(50061, "create task definition log {0} error", "创建任务操作记录 {0} 错误"),
    DELETE_TASK_DEFINE_BY_CODE_MSG_ERROR(50062, "delete task definition {0} error", "删除任务定义 {0} 错误"),
    TASK_DEFINITION_NOT_CHANGE(50063, "task definition {0} do not change", "任务定义 {0} 没有变化"),
    TASK_DEFINITION_NOT_EXISTS(50064, "task definition {0} do not exists", "任务定义 {0} 不存在"),
    UPDATE_UPSTREAM_TASK_WORKFLOW_RELATION_ERROR(50065, "update task upstream relation error", "更新任务上游关系错误"),
    CREATE_WORKFLOW_TASK_RELATION_LOG_ERROR(50066, "create workflow task relation log {0}-{1} error",
            "创建任务关系日志 {0}-{1} 错误"),
    WORKFLOW_TASK_RELATION_NOT_EXPECT(50067, "workflow task relation number not expect, expect {0} but get {1}",
            "工作流任务关系数量不符合预期，预期 {0} 但是实际 {1}"),
    WORKFLOW_TASK_RELATION_BATCH_DELETE_ERROR(50068, "batch delete workflow task relation {0} error",
            "批量删除工作流任务关系 {0} 错误"),
    WORKFLOW_TASK_RELATION_BATCH_CREATE_ERROR(50069, "batch create workflow task relation {0} error",
            "批量创建工作流任务关系 {0} 错误"),
    WORKFLOW_TASK_RELATION_BATCH_UPDATE_ERROR(50070, "batch update workflow task relation error",
            "批量修改工作流任务关系错误"),
    UPSTREAM_TASK_NOT_EXISTS(50071, "upstream task want to set dependence do not exists {0}", "指定的上游任务 {0} 不存在"),

    WORKFLOW_INSTANCE_IS_NOT_FINISHED(50071, "the workflow instance is not finished, can not do this operation",
            "工作流实例未结束，不能执行此操作"),

    TASK_PARALLELISM_PARAMS_ERROR(50080, "task parallelism parameter is not valid", "任务并行度参数无效"),
    TASK_COMPLEMENT_DATA_DATE_ERROR(50081, "The range of date for complementing date is not valid", "补数选择的日期范围无效"),

    HDFS_NOT_STARTUP(60001, "hdfs not startup", "hdfs未启用"),
    STORAGE_NOT_STARTUP(60002, "storage not startup", "存储未启用"),
    S3_CANNOT_RENAME(60003, "directory cannot be renamed", "S3无法重命名文件夹"),
    /**
     * for monitor
     */
    QUERY_DATABASE_STATE_ERROR(70001, "query database state error", "查询数据库状态错误"),

    CREATE_ACCESS_TOKEN_ERROR(70010, "create access token error", "创建访问token错误"),
    GENERATE_TOKEN_ERROR(70011, "generate token error", "生成token错误"),
    QUERY_ACCESSTOKEN_LIST_PAGING_ERROR(70012, "query access token list paging error", "分页查询访问token列表错误"),
    UPDATE_ACCESS_TOKEN_ERROR(70013, "update access token error", "更新访问token错误"),
    DELETE_ACCESS_TOKEN_ERROR(70014, "delete access token error", "删除访问token错误"),
    ACCESS_TOKEN_NOT_EXIST(70015, "access token not exist, tokenId {0}", "访问token不存在, {0}"),
    QUERY_ACCESSTOKEN_BY_USER_ERROR(70016, "query access token by user error", "查询访问指定用户的token错误"),

    COMMAND_STATE_COUNT_ERROR(80001, "task instance state count error", "查询各状态任务实例数错误"),
    NEGTIVE_SIZE_NUMBER_ERROR(80002, "query size number error", "查询size错误"),
    START_TIME_BIGGER_THAN_END_TIME_ERROR(80003, "start time bigger than end time error", "开始时间在结束时间之后错误"),
    QUEUE_COUNT_ERROR(90001, "queue count error", "查询队列数据错误"),

    KERBEROS_STARTUP_STATE(100001, "get kerberos startup state error", "获取kerberos启动状态错误"),

    // audit log
    QUERY_AUDIT_LOG_LIST_PAGING(10057, "query resources list paging", "分页查询资源列表错误"),

    // plugin
    PLUGIN_NOT_A_UI_COMPONENT(110001, "query plugin error, this plugin has no UI component", "查询插件错误，此插件无UI组件"),
    QUERY_PLUGINS_RESULT_IS_NULL(110002,
            "query alarm plugins result is empty, please check the startup status of the alarm component and confirm that the relevant alarm plugin is successfully registered",
            "查询告警插件为空, 请检查告警组件启动状态并确认相关告警插件已注册成功"),
    QUERY_PLUGINS_ERROR(110003, "query plugins error", "查询插件错误"),
    QUERY_PLUGIN_DETAIL_RESULT_IS_NULL(110004, "query plugin detail result is null", "查询插件详情结果为空"),

    UPDATE_ALERT_PLUGIN_INSTANCE_ERROR(110005, "update alert plugin instance error", "更新告警组和告警组插件实例错误"),
    DELETE_ALERT_PLUGIN_INSTANCE_ERROR(110006, "delete alert plugin instance error", "删除告警组和告警组插件实例错误"),
    GET_ALERT_PLUGIN_INSTANCE_ERROR(110007, "get alert plugin instance error", "获取告警组和告警组插件实例错误"),
    CREATE_ALERT_PLUGIN_INSTANCE_ERROR(110008, "create alert plugin instance error", "创建告警组和告警组插件实例错误"),
    QUERY_ALL_ALERT_PLUGIN_INSTANCE_ERROR(110009, "query all alert plugin instance error", "查询所有告警实例失败"),
    PLUGIN_INSTANCE_ALREADY_EXISTS(110010, "plugin instance already exists", "该告警插件实例已存在"),
    LIST_PAGING_ALERT_PLUGIN_INSTANCE_ERROR(110011, "query plugin instance page error", "分页查询告警实例失败"),
    DELETE_ALERT_PLUGIN_INSTANCE_ERROR_HAS_ALERT_GROUP_ASSOCIATED(110012,
            "failed to delete the alert instance, there is an alarm group associated with this alert instance",
            "删除告警实例失败，存在与此告警实例关联的警报组"),
    WORKFLOW_DEFINITION_VERSION_IS_USED(110013, "this workflow definition version is used", "此工作流定义版本被使用"),
    ALERT_TEST_SENDING_FAILED(110014, "Alert test sending failed, [{0}]", "alert测试发送失败，[{0}]"),
    ALERT_CHANNEL_NOT_EXIST(110015, "Alert channel not exist", "alert channel不存在"),
    SEND_TEST_ALERT_PLUGIN_INSTANCE_ERROR(110016, "send test alert plugin instance error", "发送测试告警错误"),
    ALERT_SERVER_NOT_EXIST(110017, "Alert server does not exist", "Alert server不存在"),
    CREATE_ENVIRONMENT_ERROR(120001, "create environment error", "创建环境失败"),
    ENVIRONMENT_NAME_EXISTS(120002, "this environment name [{0}] already exists", "环境名称[{0}]已经存在"),
    ENVIRONMENT_NAME_IS_NULL(120003, "this environment name shouldn't be empty.", "环境名称不能为空"),
    ENVIRONMENT_CONFIG_IS_NULL(120004, "this environment config shouldn't be empty.", "环境配置信息不能为空"),
    UPDATE_ENVIRONMENT_ERROR(120005, "update environment [{0}] info error", "更新环境[{0}]信息失败"),
    DELETE_ENVIRONMENT_ERROR(120006, "delete environment error", "删除环境信息失败"),
    DELETE_ENVIRONMENT_RELATED_TASK_EXISTS(120007, "this environment has been used in tasks,so you can't delete it.",
            "该环境已经被任务使用，所以不能删除该环境信息"),
    QUERY_ENVIRONMENT_BY_NAME_ERROR(1200008, "not found environment name [{0}] ", "查询环境名称[{0}]不存在"),
    QUERY_ENVIRONMENT_BY_CODE_ERROR(1200009, "not found environment code [{0}] ", "查询环境编码[{0}]不存在"),
    QUERY_ENVIRONMENT_ERROR(1200010, "login user query environment error", "分页查询环境列表错误"),
    VERIFY_ENVIRONMENT_ERROR(1200011, "verify environment error", "验证环境信息错误"),
    GET_DATASOURCE_TABLES_ERROR(1200018, "get datasource tables error", "获取数据源表列表错误"),
    GET_DATASOURCE_TABLE_COLUMNS_ERROR(1200019, "get datasource table columns error", "获取数据源表列名错误"),
    GET_DATASOURCE_DATABASES_ERROR(1200035, "get datasource databases error", "获取数据库列表错误"),

    CREATE_CLUSTER_ERROR(120020, "create cluster error", "创建集群失败"),
    CLUSTER_NAME_EXISTS(120021, "this cluster name [{0}] already exists", "集群名称[{0}]已经存在"),
    CLUSTER_NAME_IS_NULL(120022, "this cluster name shouldn't be empty.", "集群名称不能为空"),
    CLUSTER_CONFIG_IS_NULL(120023, "this cluster config shouldn't be empty.", "集群配置信息不能为空"),
    UPDATE_CLUSTER_ERROR(120024, "update cluster [{0}] info error", "更新集群[{0}]信息失败"),
    DELETE_CLUSTER_ERROR(120025, "delete cluster error", "删除集群信息失败"),
    DELETE_CLUSTER_RELATED_TASK_EXISTS(120026, "this cluster has been used in tasks,so you can't delete it.",
            "该集群已经被任务使用，所以不能删除该集群信息"),
    QUERY_CLUSTER_BY_NAME_ERROR(1200027, "not found cluster [{0}] ", "查询集群名称[{0}]信息不存在"),
    QUERY_CLUSTER_BY_CODE_ERROR(1200028, "not found cluster [{0}] ", "查询集群编码[{0}]不存在"),
    QUERY_CLUSTER_ERROR(1200029, "login user query cluster error", "分页查询集群列表错误"),
    VERIFY_CLUSTER_ERROR(1200030, "verify cluster error", "验证集群信息错误"),
    CLUSTER_WORKFLOW_DEFINITIONS_IS_INVALID(1200031, "cluster worker groups is invalid format", "集群关联的工作组参数解析错误"),
    UPDATE_CLUSTER_WORKFLOW_DEFINITION_RELATION_ERROR(1200032,
            "You can't modify the workflow definition, because the workflow definition [{0}] and this cluster [{1}] already be used in the task [{2}]",
            "您不能修改集群选项，因为该工作流组 [{0}] 和 该集群 [{1}] 已经被用在任务 [{2}] 中"),
    CLUSTER_NOT_EXISTS(120033, "this cluster can not found in db.", "集群配置数据库里查询不到为空"),
    DELETE_CLUSTER_RELATED_NAMESPACE_EXISTS(120034, "this cluster has been used in namespace,so you can't delete it.",
            "该集群已经被命名空间使用，所以不能删除该集群信息"),

    TASK_GROUP_NAME_EXSIT(130001, "this task group name is repeated in a project", "该任务组名称在一个项目中已经使用"),
    TASK_GROUP_SIZE_ERROR(130002, "task group size error", "任务组大小应该为大于1的整数"),
    TASK_GROUP_STATUS_ERROR(130003, "task group status error", "任务组已经被关闭"),
    TASK_GROUP_FULL(130004, "task group is full", "任务组已经满了"),
    TASK_GROUP_USED_SIZE_ERROR(130005, "the used size number of task group is dirty", "任务组使用的容量发生了变化"),
    TASK_GROUP_QUEUE_RELEASE_ERROR(130006, "failed to release task group queue", "任务组资源释放时出现了错误"),
    TASK_GROUP_QUEUE_AWAKE_ERROR(130007, "awake waiting task failed", "任务组使唤醒等待任务时发生了错误"),
    CREATE_TASK_GROUP_ERROR(130008, "create task group error", "创建任务组错误"),
    UPDATE_TASK_GROUP_ERROR(130009, "update task group list error", "更新任务组错误"),
    QUERY_TASK_GROUP_LIST_ERROR(130010, "query task group list error", "查询任务组列表错误"),
    CLOSE_TASK_GROUP_ERROR(130011, "close task group error", "关闭任务组错误"),
    START_TASK_GROUP_ERROR(130012, "start task group error", "启动任务组错误"),
    QUERY_TASK_GROUP_QUEUE_LIST_ERROR(130013, "query task group queue list error", "查询任务组队列列表错误"),
    ENVIRONMENT_WORKER_GROUPS_IS_INVALID(130015, "environment worker groups is invalid format", "环境关联的工作组参数解析错误"),
    UPDATE_ENVIRONMENT_WORKER_GROUP_RELATION_ERROR(130016,
            "You can't modify the worker group, because the worker group [{0}] and this environment [{1}] already be used in the task [{2}]",
            "您不能修改工作组选项，因为该工作组 [{0}] 和 该环境 [{1}] 已经被用在任务 [{2}] 中"),
    TASK_GROUP_QUEUE_ALREADY_START(130017, "task group queue already start", "节点已经获取任务组资源"),
    TASK_GROUP_STATUS_CLOSED(130018, "The task group has been closed.", "任务组已经被关闭"),
    TASK_GROUP_STATUS_OPENED(130019, "The task group has been opened.", "任务组已经被开启"),
    NOT_ALLOW_TO_DISABLE_OWN_ACCOUNT(130020, "Not allow to disable your own account", "不能停用自己的账号"),
    NOT_ALLOW_TO_DELETE_DEFAULT_ALARM_GROUP(130030, "Not allow to delete the default alarm group ", "不能删除默认告警组"),
    TIME_ZONE_ILLEGAL(130031, "time zone [{0}] is illegal", "时区参数 [{0}] 不合法"),
    NOT_ALLOW_TO_UPDATE_GLOBAL_ALARM_GROUP(130032, "Not allow to update the global alert group ", "不能更新全局告警组"),

    QUERY_K8S_NAMESPACE_LIST_PAGING_ERROR(1300001, "login user query k8s namespace list paging error",
            "分页查询k8s名称空间列表错误"),
    K8S_NAMESPACE_EXIST(1300002, "k8s namespace {0} already exists", "k8s命名空间[{0}]已存在"),
    CREATE_K8S_NAMESPACE_ERROR(1300003, "create k8s namespace error", "创建k8s命名空间错误"),
    UPDATE_K8S_NAMESPACE_ERROR(1300004, "update k8s namespace error", "更新k8s命名空间信息错误"),
    K8S_NAMESPACE_NOT_EXIST(1300005, "k8s namespace {0} not exists", "命名空间ID[{0}]不存在"),
    K8S_CLIENT_OPS_ERROR(1300006, "k8s error with exception {0}", "k8s操作报错[{0}]"),
    VERIFY_K8S_NAMESPACE_ERROR(1300007, "verify k8s and namespace error", "验证k8s命名空间信息错误"),
    DELETE_K8S_NAMESPACE_BY_ID_ERROR(1300008, "delete k8s namespace by id error", "删除命名空间错误"),
    VERIFY_PARAMETER_NAME_FAILED(1300009, "The file name verify failed", "文件命名校验失败"),
    STORE_OPERATE_CREATE_ERROR(1300010, "create the resource failed", "存储操作失败"),
    GRANT_K8S_NAMESPACE_ERROR(1300011, "grant namespace error", "授权资源错误"),
    QUERY_UNAUTHORIZED_NAMESPACE_ERROR(1300012, "query unauthorized namespace error", "查询未授权命名空间错误"),
    QUERY_AUTHORIZED_NAMESPACE_ERROR(1300013, "query authorized namespace error", "查询授权命名空间错误"),
    QUERY_CAN_USE_K8S_CLUSTER_ERROR(1300014, "login user query can used k8s cluster list error", "查询可用k8s集群错误"),
    RESOURCE_FULL_NAME_TOO_LONG_ERROR(1300015, "resource's fullname is too long error", "资源文件名过长"),
    TENANT_FULL_NAME_TOO_LONG_ERROR(1300016, "tenant's fullname is too long error", "租户名过长"),
    USER_PASSWORD_LENGTH_ERROR(1300017, "user's password length error", "用户密码长度错误"),
    QUERY_CAN_USE_K8S_NAMESPACE_ERROR(1300018, "login user query can used namespace list error", "查询可用命名空间错误"),

    QUERY_WORKFLOW_DEFINITION_ALL_VARIABLES_ERROR(1300100, "query workflow definition all variables error",
            "查询工作流自定义变量信息错误"),

    NO_CURRENT_OPERATING_PERMISSION(1400001, "The current user does not have this permission.", "当前用户无此权限"),
    FUNCTION_DISABLED(1400002, "The current feature is disabled.", "当前功能已被禁用"),
    SCHEDULE_TIME_NUMBER_EXCEED(1400003, "The number of complement dates exceed 100.", "补数日期个数超过100"),
    DESCRIPTION_TOO_LONG_ERROR(1400004, "description is too long error", "描述过长"),
    DELETE_WORKER_GROUP_BY_ID_FAIL_ENV(1400005,
            "delete worker group fail, for there are [{0}] enviroments using:{1}", "删除工作组失败，有 [{0}] 个环境正在使用：{1}"),

    WORKER_GROUP_DEPENDENT_TASK_EXISTS(1401000,
            "You can not modify or remove this worker group, cause it has [{0}] dependent tasks like :{1}",
            "不能修改或删除该Worker组，有 [{0}] 个任务正在使用：{1}"),

    WORKER_GROUP_DEPENDENT_SCHEDULER_EXISTS(1401001,
            "You can not modify or remove this worker group, cause it has [{0}] dependent workflow timings like :{1}",
            "不能修改或删除该Worker组，有 [{0}] 个工作流定时正在使用：{1}"),

    WORKER_GROUP_DEPENDENT_ENVIRONMENT_EXISTS(1401002,
            "You can not modify or remove this worker group, cause it has [{0}] dependent environments.",
            "不能修改或删除该Worker组，有 [{0}] 个环境配置正在使用"),

    WORKER_GROUP_NOT_EXIST(1402001, "The Worker group [{0}] not exists", "Worker组[{0}]不存在."),
    ASSIGN_WORKER_GROUP_TO_PROJECT_ERROR(1402002, "Failed to assign these worker groups to the project",
            "给项目分配工作组失败"),
    WORKER_GROUP_TO_PROJECT_IS_EMPTY(1402003, "Need to assign at least one worker group to the project",
            "需要给项目至少分配一个Worker组"),
    USED_WORKER_GROUP_EXISTS(1402004,
            "You can not reassign worker groups to the project, cause these worker groups {0} are already used.",
            "Worker组{0}被项目中任务或定时引用，无法重新分配"),
    CREATE_WORKFLOW_LINEAGE_ERROR(1403001, "create workflow lineage error", "创建工作流血缘错误"),
    UPDATE_WORKFLOW_LINEAGE_ERROR(1403002, "update workflow lineage error", "更新工作流血缘错误"),
    DELETE_WORKFLOW_LINEAGE_ERROR(1403003, "delete workflow lineage error", "删除工作流血缘错误"),
    ;

    @Getter
    private final int code;
    private final String enMsg;
    private final String zhMsg;

    Status(int code, String enMsg, String zhMsg) {
        this.code = code;
        this.enMsg = enMsg;
        this.zhMsg = zhMsg;
    }

    public String getMsg() {
        if (Locale.SIMPLIFIED_CHINESE.getLanguage().equals(LocaleContextHolder.getLocale().getLanguage())) {
            return this.zhMsg;
        } else {
            return this.enMsg;
        }
    }

    /**
     * Retrieve Status enum entity by status code.
     */
    public static Optional<Status> findStatusBy(int code) {
        for (Status status : Status.values()) {
            if (code == status.getCode()) {
                return Optional.of(status);
            }
        }
        return Optional.empty();
    }
}
