/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class EclipseLogLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private static final String SYMBOLIC_NAME = "org.apache.directory.studio.slf4j-eclipselog";

    private void internalLog(int severity, String message, Throwable t) {
        Bundle bundle = Platform.getBundle((String)SYMBOLIC_NAME);
        if (bundle != null) {
            Status status = new Status(severity, SYMBOLIC_NAME, message, t);
            Platform.getLog((Bundle)bundle).log((IStatus)status);
        }
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.internalLog(4, msg, null);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg).getMessage();
            this.internalLog(4, msgStr, null);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
            this.internalLog(4, msgStr, null);
        }
    }

    public void error(String format, Object ... argArray) {
        if (this.isErrorEnabled()) {
            String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray).getMessage();
            this.internalLog(4, msgStr, null);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.internalLog(4, msg, t);
        }
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.internalLog(2, msg, null);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg).getMessage();
            this.internalLog(2, msgStr, null);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
            this.internalLog(2, msgStr, null);
        }
    }

    public void warn(String format, Object ... argArray) {
        if (this.isWarnEnabled()) {
            String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray).getMessage();
            this.internalLog(2, msgStr, null);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.internalLog(2, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public void info(String msg) {
    }

    public void info(String format, Object arg) {
    }

    public void info(String format, Object arg1, Object arg2) {
    }

    public void info(String format, Object ... argArray) {
    }

    public void info(String msg, Throwable t) {
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void debug(String msg) {
    }

    public void debug(String format, Object arg) {
    }

    public void debug(String format, Object arg1, Object arg2) {
    }

    public void debug(String format, Object ... argArray) {
    }

    public void debug(String msg, Throwable t) {
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void trace(String msg) {
    }

    public void trace(String format, Object arg) {
    }

    public void trace(String format, Object arg1, Object arg2) {
    }

    public void trace(String format, Object ... argArray) {
    }

    public void trace(String msg, Throwable t) {
    }
}

