/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import java.util.ArrayList;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;

public class LdifContentRecord
extends LdifRecord {
    public LdifContentRecord(LdifDnLine dn) {
        super(dn);
    }

    public void addAttrVal(LdifAttrValLine attrVal) {
        if (attrVal == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(attrVal);
    }

    public LdifAttrValLine[] getAttrVals() {
        ArrayList<LdifAttrValLine> ldifAttrValLines = new ArrayList<LdifAttrValLine>();
        for (LdifPart ldifPart : this.ldifParts) {
            if (!(ldifPart instanceof LdifAttrValLine)) continue;
            ldifAttrValLines.add((LdifAttrValLine)ldifPart);
        }
        return ldifAttrValLines.toArray(new LdifAttrValLine[ldifAttrValLines.size()]);
    }

    private int getSize() {
        int size = 0;
        for (LdifPart ldifPart : this.ldifParts) {
            if (!(ldifPart instanceof LdifAttrValLine)) continue;
            ++size;
        }
        return size;
    }

    public static LdifContentRecord create(String dn) {
        return new LdifContentRecord(LdifDnLine.create(dn));
    }

    @Override
    public boolean isValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        return this.getSize() > 0;
    }

    @Override
    public String getInvalidString() {
        if (this.getSize() > 0) {
            return super.getInvalidString();
        }
        return "Record must contain attribute value lines";
    }
}

