/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.actions;

import org.apache.directory.studio.ldapservers.LdapServersPluginConstants;
import org.apache.directory.studio.ldapservers.actions.Messages;
import org.apache.directory.studio.ldapservers.dialogs.DeleteServerDialog;
import org.apache.directory.studio.ldapservers.jobs.DeleteLdapServerRunnable;
import org.apache.directory.studio.ldapservers.jobs.StudioLdapServerJob;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.views.ServersView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;

    public DeleteAction() {
        super(Messages.getString("DeleteAction.Delete"));
        this.init();
    }

    public DeleteAction(ServersView view) {
        super(Messages.getString("DeleteAction.Delete"));
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(LdapServersPluginConstants.CMD_DELETE);
        this.setActionDefinitionId(LdapServersPluginConstants.CMD_DELETE);
        this.setToolTipText(Messages.getString("DeleteAction.DeleteToolTip"));
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void run() {
        if (this.view != null) {
            StructuredSelection selection = (StructuredSelection)this.view.getViewer().getSelection();
            LdapServer server = (LdapServer)selection.getFirstElement();
            DeleteServerDialog dsd = new DeleteServerDialog(this.view.getSite().getShell(), server);
            if (dsd.open() == 0) {
                StudioLdapServerJob job = new StudioLdapServerJob(new DeleteLdapServerRunnable(server));
                job.schedule();
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

