/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.browser;

import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorInput;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.AbstractLinkWithEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.Messages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class LinkWithEditorAction
extends AbstractLinkWithEditorAction {
    private BrowserView browserView;

    public LinkWithEditorAction(BrowserView browserView) {
        super(browserView, Messages.getString("LinkWithEditorAction.LinkWithEditor"));
        this.browserView = browserView;
        super.init();
    }

    @Override
    protected void linkViewWithEditor(IWorkbenchPart part) {
        if (part != null && this.browserView != null && part.getSite().getWorkbenchWindow() == this.browserView.getSite().getWorkbenchWindow()) {
            IStructuredSelection selection;
            Object objectToSelect = null;
            if (part instanceof IEditorPart) {
                IEditorPart editor = (IEditorPart)part;
                IEditorInput input = editor.getEditorInput();
                if (input instanceof EntryEditorInput) {
                    EntryEditorInput eei = (EntryEditorInput)input;
                    objectToSelect = eei.getInput();
                } else if (input instanceof SearchResultEditorInput) {
                    SearchResultEditorInput srei = (SearchResultEditorInput)input;
                    objectToSelect = srei.getSearch();
                }
            }
            if (!(objectToSelect == null || (selection = (IStructuredSelection)this.browserView.getMainWidget().getViewer().getSelection()).size() == 1 && selection.getFirstElement().equals(objectToSelect))) {
                this.browserView.select(objectToSelect);
            }
        }
    }
}

