/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.wizards.EditEntryWizard;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.AbstractOpenEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorActionGroup;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorCursor;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class OpenEntryEditorAction
extends AbstractOpenEditorAction {
    private IValueEditor valueEditor;

    public OpenEntryEditorAction(TableViewer viewer, SearchResultEditorCursor cursor, ValueEditorManager valueEditorManager, IValueEditor valueEditor, SearchResultEditorActionGroup actionGroup) {
        super(viewer, cursor, valueEditorManager, actionGroup);
        this.cellEditor = valueEditor.getCellEditor();
        this.valueEditor = valueEditor;
    }

    public IValueEditor getValueEditor() {
        return this.valueEditor;
    }

    @Override
    public void run() {
        IEntry entry;
        IEntry iEntry = entry = this.getSelectedSearchResults().length > 0 ? this.getSelectedSearchResults()[0].getEntry() : null;
        if (entry != null) {
            this.actionGroup.deactivateGlobalActionHandlers();
            EditEntryWizard wizard = new EditEntryWizard(entry);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.setBlockOnOpen(true);
            dialog.create();
            dialog.open();
            this.actionGroup.activateGlobalActionHandlers();
        }
    }

    public void dispose() {
        this.valueEditor = null;
        super.dispose();
    }

    public String getCommandId() {
        return BrowserCommonConstants.ACTION_ID_EDIT_RECORD;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getText() {
        return Messages.getString("OpenEntryEditorAction.EditEntry");
    }

    public boolean isEnabled() {
        return true;
    }
}

