/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.preferences;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.preferences.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SearchResultEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showDnButton;
    private Button showLinksButton;
    private Text sortFilterLimitText;

    public SearchResultEditorPreferencePage() {
        super(Messages.getString("SearchResultEditorPreferencePage.ResultEditor"));
        super.setPreferenceStore(BrowserUIPlugin.getDefault().getPreferenceStore());
        super.setDescription(Messages.getString("SearchResultEditorPreferencePage.GeneralSettings"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)2);
        this.showDnButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("SearchResultEditorPreferencePage.DNAsFirst"), (int)2);
        this.showDnButton.setSelection(this.getPreferenceStore().getBoolean("searchResultEditorShowDn"));
        this.showLinksButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("SearchResultEditorPreferencePage.DNAsLink"), (int)2);
        this.showLinksButton.setSelection(this.getPreferenceStore().getBoolean("searchResultEditorShowLinks"));
        String sortFilterLimitTooltip = Messages.getString("SearchResultEditorPreferencePage.SortFilterLimitToolTip");
        Label sortFilterLimitLabel = BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("SearchResultEditorPreferencePage.SortFilterLimitColon"), (int)1);
        sortFilterLimitLabel.setToolTipText(sortFilterLimitTooltip);
        this.sortFilterLimitText = BaseWidgetUtils.createText((Composite)composite, (String)("" + this.getPreferenceStore().getInt("searchResultEditorSortFilterLimit")), (int)5, (int)1);
        this.sortFilterLimitText.setToolTipText(sortFilterLimitTooltip);
        this.sortFilterLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        this.applyDialogFont(composite);
        return composite;
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("searchResultEditorShowDn", this.showDnButton.getSelection());
        this.getPreferenceStore().setValue("searchResultEditorShowLinks", this.showLinksButton.getSelection());
        int sortFilterLimit = this.getPreferenceStore().getInt("searchResultEditorSortFilterLimit");
        try {
            sortFilterLimit = Integer.parseInt(this.sortFilterLimitText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {}
        this.getPreferenceStore().setValue("searchResultEditorSortFilterLimit", sortFilterLimit);
        return true;
    }

    protected void performDefaults() {
        this.showDnButton.setSelection(this.getPreferenceStore().getDefaultBoolean("searchResultEditorShowDn"));
        this.showLinksButton.setSelection(this.getPreferenceStore().getDefaultBoolean("searchResultEditorShowLinks"));
        super.performDefaults();
    }
}

