/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import java.util.Collection;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.AbstractOpenEditorAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroup;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetTableMetadata;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class OpenBestEditorAction
extends AbstractOpenEditorAction {
    private IValueEditor bestValueEditor;

    public OpenBestEditorAction(TreeViewer viewer, ValueEditorManager valueEditorManager, EntryEditorWidgetActionGroup actionGroup) {
        super(viewer, valueEditorManager, actionGroup);
    }

    public IValueEditor getBestValueEditor() {
        return this.bestValueEditor;
    }

    @Override
    public void dispose() {
        this.bestValueEditor = null;
        super.dispose();
    }

    @Override
    public String getCommandId() {
        return null;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.isEnabled() ? this.bestValueEditor.getValueEditorImageDescriptor() : null;
    }

    @Override
    public String getText() {
        if (this.isEnabled()) {
            return this.bestValueEditor.getValueEditorName();
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        if (this.getSelectedValues().length == 1 && this.getSelectedAttributes().length == 0 && this.viewer.getCellModifier().canModify((Object)this.getSelectedValues()[0], EntryEditorWidgetTableMetadata.VALUE_COLUMN_NAME)) {
            this.bestValueEditor = this.valueEditorManager.getCurrentValueEditor(this.getSelectedValues()[0]);
            this.setCellEditor(this.bestValueEditor.getCellEditor());
            return true;
        }
        this.bestValueEditor = null;
        return false;
    }

    @Override
    public void run() {
        boolean ok = true;
        if (this.getSelectedValues().length == 1 && this.getSelectedAttributes().length == 0) {
            IValue value = this.getSelectedValues()[0];
            StringBuffer message = new StringBuffer();
            IAttribute attribute = value.getAttribute();
            String description = attribute.getDescription();
            AttributeType atd = attribute.getAttributeTypeDescription();
            if (value.isEmpty()) {
                IEntry entry;
                Collection allAtds;
                if (attribute.getValueSize() > 1 && atd.isSingleValued()) {
                    message.append(NLS.bind((String)Messages.getString("OpenBestEditorAction.ValueSingleValued"), (Object)description));
                    message.append(BrowserCoreConstants.LINE_SEPARATOR);
                    message.append(BrowserCoreConstants.LINE_SEPARATOR);
                }
                if (!(allAtds = SchemaUtils.getAllAttributeTypeDescriptions((IEntry)(entry = attribute.getEntry()))).contains(atd)) {
                    message.append(NLS.bind((String)Messages.getString("OpenBestEditorAction.AttributeNotInSubSchema"), (Object)description));
                    message.append(BrowserCoreConstants.LINE_SEPARATOR);
                    message.append(BrowserCoreConstants.LINE_SEPARATOR);
                }
            }
            if (!SchemaUtils.isModifiable((AttributeType)atd)) {
                message.append(NLS.bind((String)Messages.getString("OpenBestEditorAction.ValueNotModifiable"), (Object)description));
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
            }
            if (value.isRdnPart() && this.getCellEditor() != this.valueEditorManager.getRenameValueEditor()) {
                message.append(NLS.bind((String)Messages.getString("OpenBestEditorAction.ValueIsRdnPart"), (Object)description));
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
            }
            if (message.length() > 0) {
                if (value.isEmpty()) {
                    message.append(Messages.getString("OpenBestEditorAction.NewValueQuestion"));
                } else {
                    message.append(Messages.getString("OpenBestEditorAction.EditValueQuestion"));
                }
                ok = MessageDialog.openConfirm((Shell)this.getShell(), (String)this.getText(), (String)message.toString());
            }
            if (ok) {
                super.run();
            } else if (value.isEmpty()) {
                attribute.deleteEmptyValue();
            }
        }
    }
}

