/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.studio.connection.core.jobs.OpenConnectionsRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserCategory;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserEntryPage;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserPreferences;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSearchResultPage;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSorter;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeChildrenRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IContinuation;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IQuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DirectoryMetadataEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.SearchContinuation;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class BrowserContentProvider
implements ITreeContentProvider {
    private TreeViewer viewer;
    protected BrowserPreferences preferences;
    protected BrowserSorter sorter;
    private Map<IEntry, BrowserEntryPage[]> entryToEntryPagesMap;
    private Map<ISearch, BrowserSearchResultPage[]> searchToSearchResultPagesMap;
    private Map<IBrowserConnection, BrowserCategory[]> connectionToCategoriesMap;
    private ISelectionChangedListener pageListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 1 && selection.getFirstElement() instanceof StudioConnectionRunnableWithProgress) {
                StudioConnectionRunnableWithProgress runnable = (StudioConnectionRunnableWithProgress)selection.getFirstElement();
                new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{runnable}).execute();
            }
        }
    };

    public BrowserContentProvider(BrowserWidget widget, BrowserPreferences preferences, BrowserSorter sorter) {
        this.viewer = widget.getViewer();
        this.preferences = preferences;
        this.sorter = sorter;
        this.entryToEntryPagesMap = new HashMap<IEntry, BrowserEntryPage[]>();
        this.searchToSearchResultPagesMap = new HashMap<ISearch, BrowserSearchResultPage[]>();
        this.connectionToCategoriesMap = new HashMap<IBrowserConnection, BrowserCategory[]>();
        this.viewer.addSelectionChangedListener(this.pageListener);
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
        if (this.entryToEntryPagesMap != null) {
            this.entryToEntryPagesMap.clear();
            this.entryToEntryPagesMap = null;
        }
        if (this.searchToSearchResultPagesMap != null) {
            this.searchToSearchResultPagesMap.clear();
            this.searchToSearchResultPagesMap = null;
        }
        if (this.connectionToCategoriesMap != null) {
            this.connectionToCategoriesMap.clear();
            this.connectionToCategoriesMap = null;
        }
        this.viewer.removeSelectionChangedListener(this.pageListener);
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof IBrowserConnection) {
            BrowserCategory[] categories;
            IBrowserConnection connection = (IBrowserConnection)parent;
            if (!this.connectionToCategoriesMap.containsKey(connection)) {
                categories = new BrowserCategory[]{new BrowserCategory(0, connection), new BrowserCategory(1, connection), new BrowserCategory(2, connection)};
                this.connectionToCategoriesMap.put(connection, categories);
            }
            categories = this.connectionToCategoriesMap.get(connection);
            ArrayList<BrowserCategory> catList = new ArrayList<BrowserCategory>(3);
            if (this.preferences.isShowDIT()) {
                catList.add(categories[0]);
            }
            if (this.preferences.isShowSearches()) {
                catList.add(categories[1]);
            }
            if (this.preferences.isShowBookmarks()) {
                catList.add(categories[2]);
            }
            return catList.toArray(new BrowserCategory[0]);
        }
        if (parent instanceof IEntry[]) {
            return (IEntry[])parent;
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof BrowserCategory) {
            return ((BrowserCategory)child).getParent();
        }
        if (child instanceof BrowserEntryPage) {
            return ((BrowserEntryPage)child).getParent();
        }
        if (child instanceof IEntry) {
            IEntry parentEntry = ((IEntry)child).getParententry();
            if (parentEntry == null) {
                if (this.connectionToCategoriesMap.get(((IEntry)child).getBrowserConnection()) != null) {
                    return this.connectionToCategoriesMap.get(((IEntry)child).getBrowserConnection())[0];
                }
                return null;
            }
            if (parentEntry.getChildrenCount() <= this.preferences.getFoldingSize() || !this.preferences.isUseFolding()) {
                return parentEntry;
            }
            BrowserEntryPage[] entryPages = this.getEntryPages(parentEntry);
            BrowserEntryPage ep = null;
            int i = 0;
            while (i < entryPages.length && ep == null) {
                ep = entryPages[i].getParentOf((IEntry)child);
                ++i;
            }
            return ep;
        }
        if (child instanceof BrowserSearchResultPage) {
            return ((BrowserSearchResultPage)child).getParent();
        }
        if (child instanceof IQuickSearch) {
            IQuickSearch quickSearch = (IQuickSearch)child;
            IEntry entry = quickSearch.getBrowserConnection().getEntryFromCache(quickSearch.getSearchBase());
            return entry;
        }
        if (child instanceof ISearch) {
            ISearch search = (ISearch)child;
            if (this.connectionToCategoriesMap.get(search.getBrowserConnection()) != null) {
                return this.connectionToCategoriesMap.get(search.getBrowserConnection())[1];
            }
            return null;
        }
        if (child instanceof ISearchResult) {
            ISearch parentSearch = ((ISearchResult)child).getSearch();
            if (parentSearch == null || parentSearch.getSearchResults().length <= this.preferences.getFoldingSize() || !this.preferences.isUseFolding()) {
                return parentSearch;
            }
            BrowserSearchResultPage[] srPages = this.getSearchResultPages(parentSearch);
            BrowserSearchResultPage srp = null;
            int i = 0;
            while (i < srPages.length && srp == null) {
                srp = srPages[i].getParentOf((ISearchResult)child);
                ++i;
            }
            return srp;
        }
        if (child instanceof IBookmark) {
            IBookmark bookmark = (IBookmark)child;
            if (this.connectionToCategoriesMap.get(bookmark.getBrowserConnection()) != null) {
                return this.connectionToCategoriesMap.get(bookmark.getBrowserConnection())[2];
            }
            return null;
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof BrowserEntryPage) {
            BrowserEntryPage entryPage = (BrowserEntryPage)parent;
            Object[] objects = entryPage.getChildren();
            if (objects == null) {
                return new String[]{Messages.getString("BrowserContentProvider.FetchingEntries")};
            }
            if (objects instanceof IEntry[]) {
                Object[] entries = (IEntry[])objects;
                return entries;
            }
            return objects;
        }
        if (parent instanceof IRootDSE) {
            IRootDSE rootDSE = (IRootDSE)parent;
            if (!rootDSE.isChildrenInitialized()) {
                new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new InitializeChildrenRunnable(false, new IEntry[]{rootDSE})}).execute();
                return new String[]{Messages.getString("BrowserContentProvider.FetchingEntries")};
            }
            ArrayList<IEntry> entryList = new ArrayList<IEntry>();
            entryList.addAll(Arrays.asList(rootDSE.getChildren()));
            Iterator it = entryList.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (this.preferences.isShowDirectoryMetaEntries() || !(o instanceof DirectoryMetadataEntry)) continue;
                it.remove();
            }
            return entryList.toArray();
        }
        if (parent instanceof IEntry) {
            IEntry parentEntry = (IEntry)parent;
            if (parentEntry instanceof IContinuation) {
                IContinuation continuation = (IContinuation)parentEntry;
                if (continuation.getState() == IContinuation.State.UNRESOLVED) {
                    continuation.resolve();
                }
                if (continuation.getState() == IContinuation.State.CANCELED) {
                    return new Object[0];
                }
            }
            ArrayList<Object> objects = new ArrayList<Object>();
            IQuickSearch quickSearch = this.getQuickSearchForEntry(parentEntry);
            if (quickSearch != null) {
                objects.add(quickSearch);
            }
            if (!parentEntry.isChildrenInitialized()) {
                new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new InitializeChildrenRunnable(false, new IEntry[]{parentEntry})}).execute();
                return new String[]{Messages.getString("BrowserContentProvider.FetchingEntries")};
            }
            if (parentEntry.getChildrenCount() <= this.preferences.getFoldingSize() || !this.preferences.isUseFolding()) {
                if (this.entryToEntryPagesMap.containsKey(parentEntry)) {
                    this.entryToEntryPagesMap.remove(parentEntry);
                }
                IEntry[] results = parentEntry.getChildren();
                if (parentEntry.getTopPageChildrenRunnable() != null) {
                    objects.add(parentEntry.getTopPageChildrenRunnable());
                }
                objects.addAll(Arrays.asList(results));
                if (parentEntry.getNextPageChildrenRunnable() != null) {
                    objects.add(parentEntry.getNextPageChildrenRunnable());
                }
                return objects.toArray();
            }
            BrowserEntryPage[] entryPages = this.getEntryPages(parentEntry);
            objects.addAll(Arrays.asList(entryPages));
            return objects.toArray();
        }
        if (parent instanceof BrowserSearchResultPage) {
            BrowserSearchResultPage srPage = (BrowserSearchResultPage)parent;
            Object[] objects = srPage.getChildren();
            if (objects == null) {
                return new String[]{Messages.getString("BrowserContentProvider.FetchingSearchResults")};
            }
            if (objects instanceof ISearchResult[]) {
                Object[] srs = (ISearchResult[])objects;
                return srs;
            }
            return objects;
        }
        if (parent instanceof ISearch) {
            ISearch search = (ISearch)parent;
            if (search instanceof IContinuation) {
                IContinuation continuation = (IContinuation)search;
                if (continuation.getState() == IContinuation.State.UNRESOLVED) {
                    continuation.resolve();
                }
                if (continuation.getState() == IContinuation.State.CANCELED) {
                    return new Object[0];
                }
            }
            if (search.getSearchResults() == null || search.getSearchContinuations() == null) {
                new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new SearchRunnable(new ISearch[]{search})}).execute();
                return new String[]{Messages.getString("BrowserContentProvider.PerformingSearch")};
            }
            if (search.getSearchResults().length + search.getSearchContinuations().length == 0) {
                return new String[]{Messages.getString("BrowserContentProvider.NoResults")};
            }
            if (search.getSearchResults().length <= this.preferences.getFoldingSize() || !this.preferences.isUseFolding()) {
                if (this.searchToSearchResultPagesMap.containsKey(search)) {
                    this.searchToSearchResultPagesMap.remove(search);
                }
                ISearchResult[] results = search.getSearchResults();
                SearchContinuation[] scs = search.getSearchContinuations();
                ArrayList<Object> objects = new ArrayList<Object>();
                if (search.getTopSearchRunnable() != null) {
                    objects.add(search.getTopSearchRunnable());
                }
                objects.addAll(Arrays.asList(results));
                if (scs != null) {
                    objects.addAll(Arrays.asList(scs));
                }
                if (search.getNextSearchRunnable() != null) {
                    objects.add(search.getNextSearchRunnable());
                }
                return objects.toArray();
            }
            Object[] srPages = this.getSearchResultPages(search);
            return srPages;
        }
        if (parent instanceof BrowserCategory) {
            BrowserCategory category = (BrowserCategory)parent;
            IBrowserConnection browserConnection = category.getParent();
            switch (category.getType()) {
                case 0: {
                    if (browserConnection.getConnection() != null && !browserConnection.getConnection().getConnectionWrapper().isConnected()) {
                        new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new OpenConnectionsRunnable(browserConnection.getConnection())}).execute();
                        return new String[]{Messages.getString("BrowserContentProvider.OpeningConnection")};
                    }
                    return new Object[]{browserConnection.getRootDSE()};
                }
                case 1: {
                    return browserConnection.getSearchManager().getSearches().toArray();
                }
                case 2: {
                    return browserConnection.getBookmarkManager().getBookmarks();
                }
            }
            return new Object[0];
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof IEntry) {
            IEntry parentEntry = (IEntry)parent;
            return parentEntry.hasChildren() || this.getQuickSearchForEntry(parentEntry) != null;
        }
        if (parent instanceof SearchContinuation) {
            return true;
        }
        if (parent instanceof BrowserEntryPage) {
            return true;
        }
        if (parent instanceof BrowserSearchResultPage) {
            return true;
        }
        if (parent instanceof ISearchResult) {
            return false;
        }
        if (parent instanceof ISearch) {
            return true;
        }
        return parent instanceof BrowserCategory;
    }

    private IQuickSearch getQuickSearchForEntry(IEntry parentEntry) {
        IQuickSearch quickSearch = parentEntry.getBrowserConnection().getQuickSearch();
        if (quickSearch != null && parentEntry.getDn().equals((Object)quickSearch.getSearchBase())) {
            return quickSearch;
        }
        return null;
    }

    private BrowserEntryPage[] getEntryPages(IEntry parentEntry) {
        BrowserEntryPage[] entryPages;
        if (!this.entryToEntryPagesMap.containsKey(parentEntry)) {
            entryPages = this.getEntryPages(parentEntry, 0, parentEntry.getChildrenCount() - 1);
            this.entryToEntryPagesMap.put(parentEntry, entryPages);
        } else {
            entryPages = this.entryToEntryPagesMap.get(parentEntry);
            if (parentEntry.getChildrenCount() - 1 != entryPages[entryPages.length - 1].getLast()) {
                entryPages = this.getEntryPages(parentEntry, 0, parentEntry.getChildrenCount() - 1);
                this.entryToEntryPagesMap.put(parentEntry, entryPages);
            }
        }
        return entryPages;
    }

    private BrowserEntryPage[] getEntryPages(IEntry entry, int first, int last) {
        int pagingSize = this.preferences.getFoldingSize();
        int diff = last - first;
        int factor = diff > 0 ? (int)(Math.log(diff) / Math.log(pagingSize)) : 0;
        int groupFirst = first;
        int groupLast = first;
        BrowserEntryPage[] pages = new BrowserEntryPage[(int)((double)diff / Math.pow(pagingSize, factor)) + 1];
        int i = 0;
        while (i < pages.length) {
            groupFirst = (int)((double)i * Math.pow(pagingSize, factor)) + first;
            groupLast = (int)((double)(i + 1) * Math.pow(pagingSize, factor)) + first - 1;
            groupLast = groupLast > last ? last : groupLast;
            BrowserEntryPage[] subpages = factor > 1 ? this.getEntryPages(entry, groupFirst, groupLast) : null;
            pages[i] = new BrowserEntryPage(entry, groupFirst, groupLast, subpages, this.sorter);
            ++i;
        }
        return pages;
    }

    private BrowserSearchResultPage[] getSearchResultPages(ISearch search) {
        BrowserSearchResultPage[] srPages;
        if (!this.searchToSearchResultPagesMap.containsKey(search)) {
            srPages = this.getSearchResultPages(search, 0, search.getSearchResults().length - 1);
            this.searchToSearchResultPagesMap.put(search, srPages);
        } else {
            srPages = this.searchToSearchResultPagesMap.get(search);
            if (search.getSearchResults().length - 1 != srPages[srPages.length - 1].getLast()) {
                srPages = this.getSearchResultPages(search, 0, search.getSearchResults().length - 1);
                this.searchToSearchResultPagesMap.put(search, srPages);
            }
        }
        return srPages;
    }

    private BrowserSearchResultPage[] getSearchResultPages(ISearch search, int first, int last) {
        int pagingSize = this.preferences.getFoldingSize();
        int diff = last - first;
        int factor = diff > 0 ? (int)(Math.log(diff) / Math.log(pagingSize)) : 0;
        int groupFirst = first;
        int groupLast = first;
        BrowserSearchResultPage[] pages = new BrowserSearchResultPage[(int)((double)diff / Math.pow(pagingSize, factor)) + 1];
        int i = 0;
        while (i < pages.length) {
            groupFirst = (int)((double)i * Math.pow(pagingSize, factor)) + first;
            groupLast = (int)((double)(i + 1) * Math.pow(pagingSize, factor)) + first - 1;
            groupLast = groupLast > last ? last : groupLast;
            BrowserSearchResultPage[] subpages = factor > 1 ? this.getSearchResultPages(search, groupFirst, groupLast) : null;
            pages[i] = new BrowserSearchResultPage(search, groupFirst, groupLast, subpages, this.sorter);
            ++i;
        }
        return pages;
    }
}

