/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.studio.connection.ui.wizards.ExportCertificateWizardPage;
import org.apache.directory.studio.connection.ui.wizards.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class ExportCertificateWizard
extends Wizard {
    private X509Certificate certificate;
    private ExportCertificateWizardPage page;

    public ExportCertificateWizard(X509Certificate certificate) {
        this.certificate = certificate;
        this.setWindowTitle(Messages.getString("ExportCertificateWizard.ExportCertificate"));
        this.setNeedsProgressMonitor(false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page = new ExportCertificateWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        ExportCertificateWizardPage.CertificateExportFormat format = this.page.getCertificateExportFormat();
        try {
            if (format == ExportCertificateWizardPage.CertificateExportFormat.DER) {
                return this.exportAsDerFormat();
            }
            return this.exportAsPemFormat();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ExportCertificateWizard.ErrorDialogTitle"), (String)NLS.bind((String)Messages.getString("ExportCertificateWizard.ErrorDialogMessage"), (Object)e.getMessage()));
            return false;
        }
    }

    private boolean exportAsDerFormat() throws CertificateEncodingException, IOException {
        File exportFile = this.page.getExportFile();
        FileUtils.writeByteArrayToFile((File)exportFile, (byte[])this.certificate.getEncoded());
        return true;
    }

    private boolean exportAsPemFormat() throws CertificateEncodingException, IOException {
        File exportFile = this.page.getExportFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fos = new FileOutputStream(exportFile);){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8"));){
                osw.write("-----BEGIN CERTIFICATE-----\n");
                osw.write(ExportCertificateWizard.stripLineToNChars(new String(Base64.encodeBase64((byte[])this.certificate.getEncoded()), Charset.forName("UTF-8")), 64));
                osw.write("\n-----END CERTIFICATE-----\n");
                osw.flush();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return true;
    }

    public static String stripLineToNChars(String str, int nbChars) {
        int strLength = str.length();
        if (strLength <= nbChars) {
            return str;
        }
        int charsPerLine = nbChars;
        int remaining = (strLength - nbChars) % charsPerLine;
        int nbLines = 1 + (strLength - nbChars) / charsPerLine + (remaining == 0 ? 0 : 1);
        int nbCharsTotal = strLength + nbLines + nbLines - 2;
        char[] buffer = new char[nbCharsTotal];
        char[] orig = str.toCharArray();
        int posSrc = 0;
        int posDst = 0;
        System.arraycopy(orig, posSrc, buffer, posDst, nbChars);
        posSrc += nbChars;
        posDst += nbChars;
        int i = 0;
        while (i < nbLines - 2) {
            buffer[posDst++] = 10;
            System.arraycopy(orig, posSrc, buffer, posDst, charsPerLine);
            posSrc += charsPerLine;
            posDst += charsPerLine;
            ++i;
        }
        buffer[posDst++] = 10;
        System.arraycopy(orig, posSrc, buffer, posDst, remaining == 0 ? charsPerLine : remaining);
        return new String(buffer);
    }
}

