/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.ui.widgets;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.studio.common.ui.AddEditDialog;
import org.apache.directory.studio.common.ui.Messages;
import org.apache.directory.studio.common.ui.TableDecorator;
import org.apache.directory.studio.common.ui.widgets.AbstractWidget;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.OrderedElement;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TableWidget<E>
extends AbstractWidget {
    private List<E> elements = new ArrayList();
    private int currentSelection;
    private boolean hasEdit;
    private boolean isOrdered;
    private boolean isEnabled = true;
    private static final boolean ORDERED = true;
    private static final boolean UNORDERED = false;
    private Composite composite;
    private Table elementTable;
    private TableViewer elementTableViewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private TableDecorator<E> decorator;
    private ISelectionChangedListener tableViewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (TableWidget.this.isEnabled) {
                int selectionLine = TableWidget.this.elementTableViewer.getTable().getSelectionIndex();
                if (selectionLine == TableWidget.this.currentSelection) {
                    TableWidget.this.elementTableViewer.getTable().deselect(selectionLine);
                    TableWidget.this.currentSelection = -1;
                } else {
                    TableWidget.this.currentSelection = selectionLine;
                    StructuredSelection selection = (StructuredSelection)TableWidget.this.elementTableViewer.getSelection();
                    if (TableWidget.this.hasEdit) {
                        TableWidget.this.editButton.setEnabled(!selection.isEmpty());
                    }
                    TableWidget.this.deleteButton.setEnabled(!selection.isEmpty());
                    if (TableWidget.this.isOrdered) {
                        TableWidget.this.upButton.setEnabled(!selection.isEmpty() && TableWidget.this.elements.size() > 1 && selectionLine > 0);
                        TableWidget.this.downButton.setEnabled(!selection.isEmpty() && TableWidget.this.elements.size() > 1 && selectionLine < TableWidget.this.elements.size() - 1);
                    }
                }
            }
        }
    };
    private IDoubleClickListener tableViewerDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            if (TableWidget.this.isEnabled) {
                TableWidget.this.editElement();
            }
        }
    };
    private SelectionListener addButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableWidget.this.addElement();
        }
    };
    private SelectionListener editButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableWidget.this.editElement();
        }
    };
    private SelectionListener deleteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableWidget.this.deleteElement();
        }
    };
    private SelectionListener upButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableWidget.this.upElement();
        }
    };
    private SelectionListener downButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableWidget.this.downElement();
        }
    };

    public TableWidget(TableDecorator<E> decorator) {
        this.decorator = decorator;
        this.currentSelection = -1;
    }

    public void createWidgetWithEdit(Composite parent, FormToolkit toolkit) {
        this.createWidget(parent, toolkit, true, false);
    }

    public void createWidgetNoEdit(Composite parent, FormToolkit toolkit) {
        this.createWidget(parent, toolkit, false, false);
    }

    public void createOrderedWidgetWithEdit(Composite parent, FormToolkit toolkit) {
        this.createWidget(parent, toolkit, true, true);
    }

    public void createOrderedWidgetNoEdit(Composite parent, FormToolkit toolkit) {
        this.createWidget(parent, toolkit, true, true);
    }

    private void createWidget(Composite parent, FormToolkit toolkit, boolean hasEdit, boolean isOrdered) {
        this.hasEdit = hasEdit;
        this.isOrdered = isOrdered;
        this.composite = toolkit != null ? toolkit.createComposite(parent) : new Composite(parent, 0);
        GridLayout compositeGridLayout = new GridLayout(2, false);
        compositeGridLayout.marginWidth = 0;
        compositeGridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)compositeGridLayout);
        this.elementTable = toolkit != null ? toolkit.createTable(this.composite, 0) : new Table(this.composite, 0);
        int nbLinesSpan = 3;
        if (isOrdered) {
            nbLinesSpan += 3;
        }
        GridData gd = new GridData(4, 4, true, true, 1, nbLinesSpan);
        this.elementTable.setLayoutData((Object)gd);
        this.elementTableViewer = new TableViewer(this.elementTable);
        this.elementTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.elementTableViewer.setLabelProvider(this.decorator);
        this.elementTableViewer.addSelectionChangedListener(this.tableViewerSelectionChangedListener);
        if (hasEdit) {
            this.elementTableViewer.addDoubleClickListener(this.tableViewerDoubleClickListener);
        }
        this.elementTableViewer.setInput(this.elements);
        GridData buttonGd = new GridData(4, 4, false, false, 1, 1);
        buttonGd.widthHint = 60;
        if (toolkit != null) {
            this.addButton = toolkit.createButton(this.composite, Messages.getString("CommonUIWidgets.AddButton"), 8);
            this.addButton.setLayoutData((Object)buttonGd);
        } else {
            this.addButton = BaseWidgetUtils.createButton(this.composite, Messages.getString("CommonUIWidgets.AddButton"), 1);
            this.addButton.setLayoutData((Object)buttonGd);
        }
        this.addButton.setLayoutData((Object)buttonGd);
        this.addButton.addSelectionListener(this.addButtonListener);
        if (hasEdit) {
            this.editButton = toolkit != null ? toolkit.createButton(this.composite, Messages.getString("CommonUIWidgets.EditButton"), 8) : BaseWidgetUtils.createButton(this.composite, Messages.getString("CommonUIWidgets.EditButton"), 8);
            this.editButton.setEnabled(false);
            this.editButton.setLayoutData((Object)buttonGd);
            this.editButton.addSelectionListener(this.editButtonListener);
        }
        this.deleteButton = toolkit != null ? toolkit.createButton(this.composite, Messages.getString("CommonUIWidgets.DeleteButton"), 8) : BaseWidgetUtils.createButton(this.composite, Messages.getString("CommonUIWidgets.DeleteButton"), 8);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)buttonGd);
        this.deleteButton.addSelectionListener(this.deleteButtonListener);
        if (isOrdered) {
            Label separator = BaseWidgetUtils.createSeparator(this.composite, 1);
            separator.setLayoutData((Object)new GridData(0, 1, false, false));
            this.upButton = toolkit != null ? toolkit.createButton(this.composite, Messages.getString("CommonUIWidgets.UpButton"), 8) : BaseWidgetUtils.createButton(this.composite, Messages.getString("CommonUIWidgets.UpButton"), 8);
            this.upButton.setEnabled(false);
            this.upButton.setLayoutData((Object)buttonGd);
            this.upButton.addSelectionListener(this.upButtonListener);
            this.downButton = toolkit != null ? toolkit.createButton(this.composite, Messages.getString("CommonUIWidgets.DownButton"), 8) : BaseWidgetUtils.createButton(this.composite, Messages.getString("CommonUIWidgets.DownButton"), 8);
            this.downButton.setEnabled(false);
            this.downButton.setLayoutData((Object)buttonGd);
            this.downButton.addSelectionListener(this.downButtonListener);
        }
    }

    public void enable() {
        if (this.addButton != null) {
            this.addButton.setEnabled(true);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(true);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(true);
        }
        this.isEnabled = true;
    }

    public void disable() {
        if (this.addButton != null) {
            this.addButton.setEnabled(false);
        }
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(false);
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(false);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(false);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(false);
        }
        this.isEnabled = false;
    }

    public Control getControl() {
        return this.composite;
    }

    public static <T> void sort(List<T> list, Comparator<T> cmp) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        TableWidget.quicksort(list, cmp, 0, size - 1);
    }

    private static <T> void quicksort(List<T> list, Comparator<T> cmp, int left, int right) {
        if (left < right) {
            int splitter = TableWidget.split(list, cmp, left, right);
            TableWidget.quicksort(list, cmp, left, splitter - 1);
            TableWidget.quicksort(list, cmp, splitter + 1, right);
        }
    }

    private static <T> void swap(List<T> list, int i, int j) {
        T tmp = list.get(i);
        list.set(i, list.get(j));
        list.set(j, tmp);
    }

    private static <T> int split(List<T> list, Comparator<T> cmp, int left, int right) {
        int i = left;
        int j = right - 1;
        T pivot = list.get(right);
        while (true) {
            if (cmp.compare(list.get(i), pivot) <= 0 && i < right) {
                ++i;
                continue;
            }
            while (cmp.compare(pivot, list.get(j)) <= 0 && j > left) {
                --j;
            }
            if (i < j) {
                TableWidget.swap(list, i, j);
            }
            if (i >= j) break;
        }
        if (cmp.compare(pivot, list.get(i)) < 0) {
            TableWidget.swap(list, i, right);
        }
        return i;
    }

    public void setElements(List<E> elements) {
        this.elements.clear();
        if (elements != null && elements.size() > 0) {
            TableWidget.sort(elements, this.decorator);
            this.elements.addAll(elements);
        }
        this.elementTableViewer.refresh();
    }

    public List<E> getElements() {
        if (this.elements != null) {
            ArrayList<E> copy = new ArrayList<E>(this.elements.size());
            copy.addAll(this.elements);
            return copy;
        }
        return null;
    }

    private void addElement() {
        AddEditDialog<E> dialog = this.decorator.getDialog();
        dialog.setAdd();
        dialog.addNewElement();
        dialog.setElements(this.elements);
        StructuredSelection selection = (StructuredSelection)this.elementTableViewer.getSelection();
        int insertionPos = this.elements.size();
        if (!selection.isEmpty()) {
            insertionPos = this.elementTableViewer.getTable().getSelectionIndex();
        }
        if (this.decorator.getDialog().open() == 0) {
            E newElement = this.decorator.getDialog().getEditedElement();
            if (!this.elements.contains(newElement)) {
                String elementStr = newElement.toString();
                int pos = 0;
                if (this.isOrdered) {
                    ((OrderedElement)newElement).setPrefix(insertionPos);
                    this.elements.add(insertionPos, newElement);
                    int i = insertionPos + 1;
                    while (i < this.elements.size()) {
                        E element = this.elements.get(i);
                        ((OrderedElement)element).incrementPrefix();
                        ++i;
                    }
                } else {
                    pos = selection.isEmpty() ? this.elements.size() : this.elementTableViewer.getTable().getSelectionIndex() + 1;
                    this.elements.add(pos, newElement);
                }
                this.elementTableViewer.refresh();
                this.elementTableViewer.setSelection((ISelection)new StructuredSelection((Object)elementStr));
            }
            this.notifyListeners();
        }
    }

    private void editElement() {
        StructuredSelection selection = (StructuredSelection)this.elementTableViewer.getSelection();
        if (!selection.isEmpty()) {
            AddEditDialog<Object> dialog = this.decorator.getDialog();
            dialog.setEdit();
            Object selectedElement = selection.getFirstElement();
            int editPosition = this.elementTableViewer.getTable().getSelectionIndex();
            dialog.setEditedElement(selectedElement);
            dialog.setSelectedPosition(editPosition);
            if (this.decorator.getDialog().open() == 0) {
                E newElement = dialog.getEditedElement();
                if (!this.isOrdered) {
                    if (this.elements.contains(newElement)) {
                        this.elements.remove(selectedElement);
                        this.elements.remove(newElement);
                        int pos = 0;
                        for (E element : this.elements) {
                            if (this.decorator.compare(element, newElement) > 0) break;
                            ++pos;
                        }
                        this.elements.add(pos, newElement);
                    } else {
                        this.elements.remove(editPosition);
                        this.elements.add(editPosition, newElement);
                    }
                } else {
                    this.elements.remove(selectedElement);
                    this.elements.add(editPosition, newElement);
                }
                this.elementTableViewer.refresh();
                this.elementTableViewer.setSelection((ISelection)new StructuredSelection((Object)newElement.toString()));
                this.notifyListeners();
            }
        }
    }

    private void deleteElement() {
        StructuredSelection selection = (StructuredSelection)this.elementTableViewer.getSelection();
        if (!selection.isEmpty()) {
            if (this.isOrdered) {
                int selectedPosition = this.elementTableViewer.getTable().getSelectionIndex();
                int i = selectedPosition + 1;
                while (i < this.elements.size()) {
                    E nextElement = this.elements.get(i);
                    ((OrderedElement)nextElement).decrementPrefix();
                    this.elements.set(i - 1, nextElement);
                    ++i;
                }
                this.elements.remove(this.elements.size() - 1);
            } else {
                int selectedPosition = this.elementTableViewer.getTable().getSelectionIndex();
                this.elements.remove(selectedPosition);
            }
            this.elementTableViewer.refresh();
            this.notifyListeners();
        }
    }

    private void upElement() {
        StructuredSelection selection = (StructuredSelection)this.elementTableViewer.getSelection();
        if (!selection.isEmpty()) {
            int selectionLine = this.elementTableViewer.getTable().getSelectionIndex();
            Object selectedElement = selection.getFirstElement();
            ((OrderedElement)selectedElement).decrementPrefix();
            E previousElement = this.getElements().get(selectionLine - 1);
            ((OrderedElement)previousElement).incrementPrefix();
            this.elements.remove(selectionLine - 1);
            this.elements.add(selectionLine, previousElement);
            this.elementTableViewer.refresh();
            this.elementTableViewer.setSelection((ISelection)new StructuredSelection(selectedElement));
            this.notifyListeners();
        }
    }

    private void downElement() {
        StructuredSelection selection = (StructuredSelection)this.elementTableViewer.getSelection();
        if (!selection.isEmpty()) {
            int selectionLine = this.elementTableViewer.getTable().getSelectionIndex();
            Object selectedElement = selection.getFirstElement();
            ((OrderedElement)selectedElement).incrementPrefix();
            E previousElement = this.getElements().get(selectionLine + 1);
            ((OrderedElement)previousElement).decrementPrefix();
            this.elements.remove(selectionLine + 1);
            this.elements.add(selectionLine, previousElement);
            this.elementTableViewer.refresh();
            this.elementTableViewer.setSelection((ISelection)new StructuredSelection(selectedElement));
            this.notifyListeners();
        }
    }
}

