/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.impl.avl;

import java.util.Comparator;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.SingletonCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.avltree.AvlSingletonOrOrderedSetCursor;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.AvlTreeCursor;
import org.apache.directory.server.core.avltree.AvlTreeMap;
import org.apache.directory.server.core.avltree.AvlTreeMapImpl;
import org.apache.directory.server.core.avltree.AvlTreeMapNoDupsWrapperCursor;
import org.apache.directory.server.core.avltree.KeyTupleAvlCursor;
import org.apache.directory.server.core.avltree.LinkedAvlMapNode;
import org.apache.directory.server.core.avltree.SingletonOrOrderedSet;
import org.apache.directory.server.xdbm.AbstractTable;
import org.apache.directory.server.xdbm.impl.avl.AvlTableDupsCursor;

public class AvlTable<K, V>
extends AbstractTable<K, V> {
    private final AvlTreeMap<K, V> avl;
    private final Comparator<Tuple<K, V>> keyOnlytupleComparator;

    public AvlTable(String name, final Comparator<K> keyComparator, Comparator<V> valueComparator, boolean dupsEnabled) {
        super(null, name, keyComparator, valueComparator);
        this.avl = new AvlTreeMapImpl(keyComparator, valueComparator, dupsEnabled);
        this.allowsDuplicates = this.avl.isDupsAllowed();
        this.keyOnlytupleComparator = new Comparator<Tuple<K, V>>(){

            @Override
            public int compare(Tuple<K, V> t0, Tuple<K, V> t1) {
                return keyComparator.compare(t0.getKey(), t1.getKey());
            }
        };
    }

    @Override
    public void close(PartitionTxn transaction) throws LdapException {
        ((AvlTreeMapImpl)this.avl).removeAll();
    }

    @Override
    public long count(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return 0L;
        }
        LinkedAvlMapNode node = this.avl.find(key);
        if (node == null) {
            return 0L;
        }
        SingletonOrOrderedSet val = node.getValue();
        if (val.isOrderedSet()) {
            return val.getOrderedSet().getSize();
        }
        return 1L;
    }

    @Override
    public V get(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return null;
        }
        LinkedAvlMapNode node = this.avl.find(key);
        if (node == null) {
            return null;
        }
        SingletonOrOrderedSet val = node.getValue();
        if (val.isOrderedSet()) {
            return (V)val.getOrderedSet().getFirst().getKey();
        }
        return (V)val.getSingleton();
    }

    @Override
    public long greaterThanCount(PartitionTxn transaction, K key) throws LdapException {
        return this.avl.getSize();
    }

    @Override
    public boolean has(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return false;
        }
        return this.avl.find(key) != null;
    }

    @Override
    public boolean has(PartitionTxn transaction, K key, V value) throws LdapException {
        if (key == null) {
            return false;
        }
        return this.avl.find(key, value) != null;
    }

    @Override
    public boolean hasGreaterOrEqual(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return false;
        }
        return this.avl.findGreaterOrEqual(key) != null;
    }

    @Override
    public boolean hasGreaterOrEqual(PartitionTxn transaction, K key, V val) throws LdapException {
        if (key == null) {
            return false;
        }
        LinkedAvlMapNode node = this.avl.findGreaterOrEqual(key);
        if (node == null) {
            return false;
        }
        if (node.getValue().isOrderedSet()) {
            AvlTree values = node.getValue().getOrderedSet();
            return values.findGreaterOrEqual(val) != null;
        }
        return this.valueComparator.compare(node.getValue().getSingleton(), val) >= 0;
    }

    @Override
    public boolean hasLessOrEqual(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return false;
        }
        return this.avl.findLessOrEqual(key) != null;
    }

    @Override
    public boolean hasLessOrEqual(PartitionTxn transaction, K key, V val) throws LdapException {
        if (key == null) {
            return false;
        }
        LinkedAvlMapNode node = this.avl.findLessOrEqual(key);
        if (node == null) {
            return false;
        }
        if (node.getValue().isOrderedSet()) {
            AvlTree values = node.getValue().getOrderedSet();
            return values.findLessOrEqual(val) != null;
        }
        return this.valueComparator.compare(node.getValue().getSingleton(), val) <= 0;
    }

    @Override
    public long lessThanCount(PartitionTxn transaction, K key) throws LdapException {
        return this.count;
    }

    @Override
    public void put(PartitionTxn partitionTxn, K key, V value) throws LdapException {
        if (key == null || value == null) {
            return;
        }
        if (this.avl.insert(key, value) == null) {
            ++this.count;
        }
    }

    @Override
    public void remove(PartitionTxn partitionTxn, K key) throws LdapException {
        if (key == null) {
            return;
        }
        SingletonOrOrderedSet value = this.avl.remove(key);
        if (value == null) {
            return;
        }
        this.count = value.isOrderedSet() ? (this.count -= (long)value.getOrderedSet().getSize()) : --this.count;
    }

    @Override
    public void remove(PartitionTxn partitionTxn, K key, V value) throws LdapException {
        if (this.avl.remove(key, value) != null) {
            --this.count;
        }
    }

    @Override
    public Cursor<Tuple<K, V>> cursor() {
        if (!this.allowsDuplicates) {
            return new AvlTreeMapNoDupsWrapperCursor(new AvlSingletonOrOrderedSetCursor(this.avl));
        }
        return new AvlTableDupsCursor(this);
    }

    @Override
    public Cursor<Tuple<K, V>> cursor(PartitionTxn partitionTxn, K key) throws LdapException {
        if (key == null) {
            return new EmptyCursor();
        }
        LinkedAvlMapNode node = this.avl.find(key);
        if (node == null) {
            return new EmptyCursor();
        }
        if (node.getValue().isOrderedSet()) {
            return new KeyTupleAvlCursor(node.getValue().getOrderedSet(), key);
        }
        return new SingletonCursor((Object)new Tuple(key, node.getValue().getSingleton()), this.keyOnlytupleComparator);
    }

    @Override
    public Cursor<V> valueCursor(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return new EmptyCursor();
        }
        LinkedAvlMapNode node = this.avl.find(key);
        if (node == null) {
            return new EmptyCursor();
        }
        if (node.getValue().isOrderedSet()) {
            return new AvlTreeCursor(node.getValue().getOrderedSet());
        }
        return new SingletonCursor(node.getValue().getSingleton(), this.valueComparator);
    }

    AvlTreeMap<K, V> getAvlTreeMap() {
        return this.avl;
    }
}

