/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.avltree.Marshaller;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirect;
import org.apache.directory.server.i18n.I18n;

public class BTreeRedirectMarshaller
implements Marshaller<BTreeRedirect> {
    static final int SIZE = 9;
    public static final BTreeRedirectMarshaller INSTANCE = new BTreeRedirectMarshaller();

    public final byte[] serialize(BTreeRedirect redirect) throws IOException {
        byte[] bites = new byte[]{1, (byte)(0xFFL & redirect.recId >> 56), (byte)(0xFFL & redirect.recId >> 48), (byte)(0xFFL & redirect.recId >> 40), (byte)(0xFFL & redirect.recId >> 32), (byte)(0xFFL & redirect.recId >> 24), (byte)(0xFFL & redirect.recId >> 16), (byte)(0xFFL & redirect.recId >> 8), (byte)(0xFFL & redirect.recId)};
        return bites;
    }

    public final BTreeRedirect deserialize(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length != 9 || bytes[0] != 1) {
            if (bytes != null) {
                throw new IOException(I18n.err((I18n)I18n.ERR_568, (Object[])new Object[]{Strings.dumpBytes((byte[])bytes)}));
            }
            throw new IOException(I18n.err((I18n)I18n.ERR_569, (Object[])new Object[0]));
        }
        long recId = (long)(bytes[1] & 0xFF) << 56 | (long)(bytes[2] & 0xFF) << 48 | (long)(bytes[3] & 0xFF) << 40 | (long)(bytes[4] & 0xFF) << 32 | (long)(bytes[5] & 0xFF) << 24 | (long)(bytes[6] & 0xFF) << 16 | (long)(bytes[7] & 0xFF) << 8 | (long)(bytes[8] & 0xFF);
        return new BTreeRedirect(recId);
    }

    public static boolean isRedirect(byte[] bites) {
        return bites != null && bites.length == 9 && bites[0] == 1;
    }
}

