/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config;

import java.io.File;
import java.util.UUID;
import org.apache.directory.api.ldap.model.csn.CsnFactory;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.api.util.TimeProvider;
import org.apache.directory.server.config.LdifConfigExtractor;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.api.partition.PartitionWriteTxn;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPartitionInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigPartitionInitializer.class);
    private SchemaManager schemaManager;
    private InstanceLayout instanceLayout;
    private DnFactory dnFactory;

    public ConfigPartitionInitializer(InstanceLayout instanceLayout, DnFactory dnFactory, SchemaManager schemaManager) {
        this.instanceLayout = instanceLayout;
        this.dnFactory = dnFactory;
        this.schemaManager = schemaManager;
    }

    public LdifPartition initConfigPartition() throws Exception {
        LdifPartition configPartition = new LdifPartition(this.schemaManager, this.dnFactory);
        configPartition.setId("config");
        configPartition.setPartitionPath(this.instanceLayout.getConfDirectory().toURI());
        configPartition.setSuffixDn(new Dn(this.schemaManager, new String[]{"ou=config"}));
        configPartition.setSchemaManager(this.schemaManager);
        File newConfigDir = new File(this.instanceLayout.getConfDirectory(), configPartition.getSuffixDn().getName());
        File oldConfFile = new File(this.instanceLayout.getConfDirectory(), "config.ldif");
        boolean migrate = false;
        File tempConfFile = null;
        if (oldConfFile.exists()) {
            if (newConfigDir.exists()) {
                String msg = "Conflict in selecting configuration source, both config.ldif and " + newConfigDir.getName() + " exist delete either one of them and restart the server";
                LOG.warn(msg);
                throw new IllegalStateException(msg);
            }
            migrate = true;
        } else if (!newConfigDir.exists()) {
            String file = LdifConfigExtractor.extractSingleFileConfig(this.instanceLayout.getConfDirectory(), "config.ldif", true);
            tempConfFile = new File(file);
        }
        LdifReader reader = null;
        if (migrate) {
            LOG.info("Old config partition detected, converting to multiple LDIF file configuration model");
            reader = new LdifReader(oldConfFile, this.schemaManager);
        } else if (tempConfFile != null) {
            LOG.info("Creating default configuration");
            reader = new LdifReader(tempConfFile, this.schemaManager);
        }
        if (reader != null) {
            File residue = new File(this.instanceLayout.getConfDirectory(), "ou=config.ldif");
            if (residue.exists()) {
                residue.delete();
            }
            configPartition.initialize();
            CsnFactory csnFactory = new CsnFactory(0);
            while (reader.hasNext()) {
                Entry entry = reader.next().getEntry();
                if (!entry.containsAttribute(new String[]{"entryUUID"})) {
                    String uuid = UUID.randomUUID().toString();
                    entry.add("entryUUID", new String[]{uuid});
                }
                if (!entry.containsAttribute(new String[]{"entryCSN"})) {
                    entry.removeAttributes(new String[]{"entryCSN"});
                    entry.add("entryCSN", new String[]{csnFactory.newInstance().toString()});
                }
                if (!entry.containsAttribute(new String[]{"creatorsName"})) {
                    entry.add("creatorsName", new String[]{"uid=admin,ou=system"});
                }
                if (!entry.containsAttribute(new String[]{"createTimestamp"})) {
                    entry.add("createTimestamp", new String[]{DateUtils.getGeneralizedTime((TimeProvider)TimeProvider.DEFAULT)});
                }
                AddOperationContext addContext = new AddOperationContext(null, entry);
                addContext.setPartition((Partition)configPartition);
                PartitionWriteTxn partitionTxn = null;
                try {
                    partitionTxn = configPartition.beginWriteTransaction();
                    addContext.setTransaction((PartitionTxn)partitionTxn);
                    configPartition.add(addContext);
                    partitionTxn.commit();
                }
                catch (LdapException le) {
                    partitionTxn.abort();
                    throw le;
                }
            }
            reader.close();
            if (migrate) {
                oldConfFile.renameTo(new File(oldConfFile.getAbsolutePath() + "_migrated"));
            } else {
                tempConfFile.delete();
            }
        } else {
            configPartition.initialize();
        }
        return configPartition;
    }
}

