/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */

package org.apache.directory.studio.connection.core.jobs;


import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgressAdapter;
import org.apache.directory.studio.connection.core.Connection;


/**
 * An adapter class for StudioConnectionRunnableWithProgress.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public abstract class StudioConnectionRunnableWithProgressAdapter extends StudioRunnableWithProgressAdapter implements
    StudioConnectionRunnableWithProgress
{
    /** The connections*/
    private static final Connection[] EMPTY_CONNECTION_ARRAY = new Connection[0];


    /**
     * @return an empty array
     */
    public Connection[] getConnections()
    {
        return EMPTY_CONNECTION_ARRAY;
    }
}
