/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.text.Normalizer;
import java.util.HashSet;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.HTMLURIEscaper;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class XHTMLURIEscaper
extends HTMLURIEscaper {
    private static final HashSet<String> urlTable = new HashSet(70);
    private static final HashSet<String> attTable = new HashSet(20);

    private static void setUrlAttributeX(String element, String attribute) {
        attTable.add(attribute);
        urlTable.add(element + "+" + attribute);
    }

    public XHTMLURIEscaper(Receiver next) {
        super(next);
    }

    private static boolean isURLAttribute(NodeName elcode, NodeName atcode) {
        if (!elcode.hasURI(NamespaceUri.XHTML)) {
            return false;
        }
        if (!atcode.hasURI(NamespaceUri.NULL)) {
            return false;
        }
        String attName = atcode.getLocalPart();
        return attTable.contains(attName) && urlTable.contains(elcode.getLocalPart() + "+" + attName);
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.currentElement = nameCode;
        AttributeMap atts2 = attributes;
        if (this.escapeURIAttributes) {
            try {
                atts2 = attributes.apply(att -> {
                    if (!ReceiverOption.contains(att.getProperties(), 1)) {
                        NodeName attName = att.getNodeName();
                        if (this.isUrlAttribute(nameCode, attName)) {
                            String value = att.getValue();
                            try {
                                String normalized = XHTMLURIEscaper.isAllAscii(value) ? value : Normalizer.normalize(value, Normalizer.Form.NFC);
                                return new AttributeInfo(attName, att.getType(), XHTMLURIEscaper.escapeURL(normalized, true, this.getConfiguration()), att.getLocation(), att.getProperties() | 2);
                            }
                            catch (XPathException e) {
                                throw new UncheckedXPathException(e);
                            }
                        }
                        return att;
                    }
                    return att;
                });
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
        }
        this.nextReceiver.startElement(nameCode, type, atts2, namespaces, location, properties);
    }

    private static boolean isAllAscii(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    static {
        XHTMLURIEscaper.setUrlAttributeX("form", "action");
        XHTMLURIEscaper.setUrlAttributeX("object", "archive");
        XHTMLURIEscaper.setUrlAttributeX("body", "background");
        XHTMLURIEscaper.setUrlAttributeX("q", "cite");
        XHTMLURIEscaper.setUrlAttributeX("blockquote", "cite");
        XHTMLURIEscaper.setUrlAttributeX("del", "cite");
        XHTMLURIEscaper.setUrlAttributeX("ins", "cite");
        XHTMLURIEscaper.setUrlAttributeX("object", "classid");
        XHTMLURIEscaper.setUrlAttributeX("object", "codebase");
        XHTMLURIEscaper.setUrlAttributeX("applet", "codebase");
        XHTMLURIEscaper.setUrlAttributeX("object", "data");
        XHTMLURIEscaper.setUrlAttributeX("button", "datasrc");
        XHTMLURIEscaper.setUrlAttributeX("div", "datasrc");
        XHTMLURIEscaper.setUrlAttributeX("input", "datasrc");
        XHTMLURIEscaper.setUrlAttributeX("object", "datasrc");
        XHTMLURIEscaper.setUrlAttributeX("select", "datasrc");
        XHTMLURIEscaper.setUrlAttributeX("span", "datasrc");
        XHTMLURIEscaper.setUrlAttributeX("table", "datasrc");
        XHTMLURIEscaper.setUrlAttributeX("textarea", "datasrc");
        XHTMLURIEscaper.setUrlAttributeX("script", "for");
        XHTMLURIEscaper.setUrlAttributeX("a", "href");
        XHTMLURIEscaper.setUrlAttributeX("a", "name");
        XHTMLURIEscaper.setUrlAttributeX("area", "href");
        XHTMLURIEscaper.setUrlAttributeX("link", "href");
        XHTMLURIEscaper.setUrlAttributeX("base", "href");
        XHTMLURIEscaper.setUrlAttributeX("img", "longdesc");
        XHTMLURIEscaper.setUrlAttributeX("frame", "longdesc");
        XHTMLURIEscaper.setUrlAttributeX("iframe", "longdesc");
        XHTMLURIEscaper.setUrlAttributeX("head", "profile");
        XHTMLURIEscaper.setUrlAttributeX("script", "src");
        XHTMLURIEscaper.setUrlAttributeX("input", "src");
        XHTMLURIEscaper.setUrlAttributeX("frame", "src");
        XHTMLURIEscaper.setUrlAttributeX("iframe", "src");
        XHTMLURIEscaper.setUrlAttributeX("img", "src");
        XHTMLURIEscaper.setUrlAttributeX("img", "usemap");
        XHTMLURIEscaper.setUrlAttributeX("input", "usemap");
        XHTMLURIEscaper.setUrlAttributeX("object", "usemap");
    }
}

