/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.logs.ActiveMQUtilBundle;
import org.apache.activemq.artemis.utils.AbstractByteBufPool;
import org.apache.activemq.artemis.utils.ByteUtil;

public class TypedProperties {
    private Map<SimpleString, PropertyValue> properties;
    private int size;
    private final Predicate<SimpleString> internalPropertyPredicate;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean internalProperties;
    private final Predicate<SimpleString> amqpPropertyPredicate;
    private boolean amqpProperties;

    public TypedProperties() {
        this.internalPropertyPredicate = null;
        this.amqpPropertyPredicate = null;
    }

    public TypedProperties(Predicate<SimpleString> internalPropertyPredicate) {
        this(internalPropertyPredicate, null);
    }

    public TypedProperties(Predicate<SimpleString> internalPropertyPredicate, Predicate<SimpleString> amqpPropertyPredicate) {
        this.internalPropertyPredicate = internalPropertyPredicate;
        this.amqpPropertyPredicate = amqpPropertyPredicate;
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.properties == null ? 0 : this.properties.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getMemoryOffset() {
        this.lock.readLock().lock();
        try {
            int n = this.properties == null ? 0 : this.size + 8 * this.properties.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TypedProperties(TypedProperties other) {
        other.lock.readLock().lock();
        try {
            this.properties = other.properties == null ? null : new HashMap<SimpleString, PropertyValue>(other.properties);
            this.size = other.size;
            this.internalPropertyPredicate = other.internalPropertyPredicate;
            this.internalProperties = other.internalProperties;
            this.amqpPropertyPredicate = other.amqpPropertyPredicate;
            this.amqpProperties = other.amqpProperties;
        }
        finally {
            other.lock.readLock().unlock();
        }
    }

    public void putBooleanProperty(SimpleString key, boolean value) {
        this.doPutValue(key, BooleanValue.of(value));
    }

    public void putByteProperty(SimpleString key, byte value) {
        this.doPutValue(key, ByteValue.valueOf(value));
    }

    public void putBytesProperty(SimpleString key, byte[] value) {
        this.doPutValue(key, value == null ? NullValue.INSTANCE : new BytesValue(value));
    }

    public void putShortProperty(SimpleString key, short value) {
        this.doPutValue(key, new ShortValue(value));
    }

    public void putIntProperty(SimpleString key, int value) {
        this.doPutValue(key, new IntValue(value));
    }

    public void putLongProperty(SimpleString key, long value) {
        this.doPutValue(key, new LongValue(value));
    }

    public void putFloatProperty(SimpleString key, float value) {
        this.doPutValue(key, new FloatValue(value));
    }

    public void putDoubleProperty(SimpleString key, double value) {
        this.doPutValue(key, new DoubleValue(value));
    }

    public void putSimpleStringProperty(SimpleString key, SimpleString value) {
        this.doPutValue(key, value == null ? NullValue.INSTANCE : new StringValue(value));
    }

    public void putNullValue(SimpleString key) {
        this.doPutValue(key, NullValue.INSTANCE);
    }

    public void putCharProperty(SimpleString key, char value) {
        this.doPutValue(key, new CharValue(value));
    }

    public void putTypedProperties(TypedProperties otherProps) {
        if (otherProps == null || otherProps == this || otherProps.properties == null) {
            return;
        }
        otherProps.forEachInternal(this::doPutValue);
    }

    public TypedProperties putProperty(SimpleString key, Object value) {
        TypedProperties.setObjectProperty(key, value, this);
        return this;
    }

    public Object getProperty(SimpleString key) {
        return this.doGetProperty(key);
    }

    public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        if (value instanceof SimpleString) {
            SimpleString simpleString = (SimpleString)value;
            return Boolean.valueOf(simpleString.toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + String.valueOf(key));
    }

    public Byte getByteProperty(SimpleString key, Supplier<Byte> defaultValue) throws ActiveMQPropertyConversionException {
        Objects.requireNonNull(defaultValue);
        Object value = this.doGetProperty(key);
        if (value == null) {
            return defaultValue.get();
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return byteValue;
        }
        if (value instanceof SimpleString) {
            SimpleString simpleString = (SimpleString)value;
            return Byte.parseByte(simpleString.toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + String.valueOf(key));
    }

    public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getByteProperty(key, () -> Byte.valueOf(null));
    }

    public Character getCharProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            throw new NullPointerException("Invalid conversion: " + String.valueOf(key));
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return character;
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + String.valueOf(key));
    }

    public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes;
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + String.valueOf(key));
    }

    public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Double.valueOf(null);
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return floatValue.doubleValue();
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return doubleValue;
        }
        if (value instanceof SimpleString) {
            SimpleString simpleString = (SimpleString)value;
            return Double.parseDouble(simpleString.toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + String.valueOf(key));
    }

    public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Integer.valueOf(null);
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer;
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return byteValue.intValue();
        }
        if (value instanceof Short) {
            Short shortValue = (Short)value;
            return shortValue.intValue();
        }
        if (value instanceof SimpleString) {
            SimpleString simpleString = (SimpleString)value;
            return Integer.parseInt(simpleString.toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + String.valueOf(key));
    }

    public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Long.valueOf(null);
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return longValue;
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return byteValue.longValue();
        }
        if (value instanceof Short) {
            Short shortValue = (Short)value;
            return shortValue.longValue();
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer.longValue();
        }
        if (value instanceof SimpleString) {
            SimpleString simpleString = (SimpleString)value;
            return Long.parseLong(simpleString.toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + String.valueOf(key));
    }

    public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Short.valueOf(null);
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return byteValue.shortValue();
        }
        if (value instanceof Short) {
            Short shortValue = (Short)value;
            return shortValue;
        }
        if (value instanceof SimpleString) {
            SimpleString simpleString = (SimpleString)value;
            return Short.parseShort(simpleString.toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + String.valueOf(key));
    }

    public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Float.valueOf(null);
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return floatValue;
        }
        if (value instanceof SimpleString) {
            SimpleString string = (SimpleString)value;
            return Float.valueOf(Float.parseFloat(string.toString()));
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + String.valueOf(key));
    }

    public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return null;
        }
        if (value instanceof SimpleString) {
            SimpleString string = (SimpleString)value;
            return string;
        }
        if (value instanceof Boolean) {
            return SimpleString.of(value.toString());
        }
        if (value instanceof Character) {
            return SimpleString.of(value.toString());
        }
        if (value instanceof Byte) {
            return SimpleString.of(value.toString());
        }
        if (value instanceof Short) {
            return SimpleString.of(value.toString());
        }
        if (value instanceof Integer) {
            return SimpleString.of(value.toString());
        }
        if (value instanceof Long) {
            return SimpleString.of(value.toString());
        }
        if (value instanceof Float) {
            return SimpleString.of(value.toString());
        }
        if (value instanceof Double) {
            return SimpleString.of(value.toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + String.valueOf(key));
    }

    public Object removeProperty(SimpleString key) {
        return this.doRemoveProperty(key);
    }

    public boolean containsProperty(SimpleString key) {
        this.lock.readLock().lock();
        try {
            if (this.properties == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.properties.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<SimpleString> getPropertyNames() {
        this.lock.readLock().lock();
        try {
            if (this.properties == null) {
                Set<SimpleString> set = Collections.emptySet();
                return set;
            }
            HashSet<SimpleString> hashSet = new HashSet<SimpleString>(this.properties.keySet());
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean clearInternalProperties() {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.internalProperties && this.removeInternalProperties();
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean clearAMQPProperties() {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.amqpProperties && this.removeAMQPProperties();
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean removeInternalProperties() {
        this.lock.writeLock().lock();
        try {
            if (this.internalPropertyPredicate == null) {
                boolean bl = false;
                return bl;
            }
            if (this.properties == null) {
                boolean bl = false;
                return bl;
            }
            if (this.properties.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean removed = this.removePredicate(this.internalPropertyPredicate);
            this.internalProperties = false;
            boolean bl = removed;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean removeAMQPProperties() {
        this.lock.writeLock().lock();
        try {
            if (this.amqpPropertyPredicate == null) {
                boolean bl = false;
                return bl;
            }
            if (this.properties == null) {
                boolean bl = false;
                return bl;
            }
            if (this.properties.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean removed = this.removePredicate(this.amqpPropertyPredicate);
            this.amqpProperties = false;
            boolean bl = removed;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean removePredicate(Predicate<SimpleString> predicate) {
        int removedBytes = 0;
        boolean removed = false;
        Iterator<Map.Entry<SimpleString, PropertyValue>> keyNameIterator = this.properties.entrySet().iterator();
        while (keyNameIterator.hasNext()) {
            Map.Entry<SimpleString, PropertyValue> entry = keyNameIterator.next();
            SimpleString propertyName = entry.getKey();
            if (!predicate.test(propertyName)) continue;
            PropertyValue propertyValue = entry.getValue();
            removedBytes += propertyName.sizeof() + propertyValue.encodeSize();
            keyNameIterator.remove();
            removed = true;
        }
        this.size -= removedBytes;
        return removed;
    }

    public void forEachKey(Consumer<SimpleString> action) {
        this.lock.readLock().lock();
        try {
            if (this.properties != null) {
                this.properties.keySet().forEach(action::accept);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void forEach(BiConsumer<SimpleString, Object> action) {
        this.lock.readLock().lock();
        try {
            if (this.properties != null) {
                this.properties.forEach((? super K k, ? super V v) -> action.accept((SimpleString)k, v.getValue()));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void forEachInternal(BiConsumer<SimpleString, PropertyValue> action) {
        this.lock.readLock().lock();
        try {
            if (this.properties != null) {
                this.properties.forEach(action::accept);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static boolean searchProperty(SimpleString key, ByteBuf buffer, int startIndex) {
        int index = startIndex;
        byte b = buffer.getByte(index);
        ++index;
        if (b == 0) {
            return false;
        }
        int numHeaders = buffer.getInt(index);
        index += 4;
        block10: for (int i = 0; i < numHeaders; ++i) {
            int keyLength;
            if (key.equals(buffer, index += 4, keyLength = buffer.getInt(index))) {
                return true;
            }
            if (i == numHeaders - 1) {
                return false;
            }
            byte type = buffer.getByte(index += keyLength);
            ++index;
            switch (type) {
                case 0: {
                    continue block10;
                }
                case 5: 
                case 11: {
                    index += 2;
                    continue block10;
                }
                case 2: 
                case 3: {
                    ++index;
                    continue block10;
                }
                case 4: 
                case 10: {
                    index += 4 + buffer.getInt(index);
                    continue block10;
                }
                case 6: {
                    index += 4;
                    continue block10;
                }
                case 7: {
                    index += 8;
                    continue block10;
                }
                case 8: {
                    index += 4;
                    continue block10;
                }
                case 9: {
                    index += 8;
                    continue block10;
                }
                default: {
                    throw ActiveMQUtilBundle.BUNDLE.invalidType(type);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ByteBuf buffer, TypedPropertiesDecoderPools keyValuePools) {
        this.lock.writeLock().lock();
        try {
            byte b = buffer.readByte();
            if (b == 0) {
                this.properties = null;
                this.size = 0;
            } else {
                int numHeaders = buffer.readInt();
                this.properties = new HashMap<SimpleString, PropertyValue>(numHeaders, 1.0f);
                this.size = 0;
                block16: for (int i = 0; i < numHeaders; ++i) {
                    SimpleString key = SimpleString.readSimpleString(buffer, keyValuePools == null ? null : keyValuePools.getPropertyKeysPool());
                    byte type = buffer.readByte();
                    switch (type) {
                        case 0: {
                            PropertyValue val = NullValue.INSTANCE;
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        case 11: {
                            PropertyValue val = new CharValue(buffer);
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        case 2: {
                            PropertyValue val = BooleanValue.of(buffer.readBoolean());
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        case 3: {
                            PropertyValue val = ByteValue.valueOf(buffer.readByte());
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        case 4: {
                            PropertyValue val = new BytesValue(buffer);
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        case 5: {
                            PropertyValue val = new ShortValue(buffer);
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        case 6: {
                            PropertyValue val = new IntValue(buffer);
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        case 7: {
                            PropertyValue val = new LongValue(buffer);
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        case 8: {
                            PropertyValue val = new FloatValue(buffer);
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        case 9: {
                            PropertyValue val = new DoubleValue(buffer);
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        case 10: {
                            PropertyValue val = StringValue.readStringValue(buffer, keyValuePools == null ? null : keyValuePools.getPropertyValuesPool());
                            this.doPutValue(key, val);
                            continue block16;
                        }
                        default: {
                            throw ActiveMQUtilBundle.BUNDLE.invalidType(type);
                        }
                    }
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void decode(ByteBuf buffer) {
        this.decode(buffer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encode(ByteBuf buffer) {
        this.lock.readLock().lock();
        try {
            int encodedSize;
            int writerIndex = 0;
            assert ((writerIndex = buffer.writerIndex()) >= 0) : "Always true";
            if (this.properties == null || this.size == 0) {
                encodedSize = 1;
                ByteUtil.ensureExactWritable(buffer, encodedSize);
                buffer.writeByte(0);
            } else {
                encodedSize = 5 + this.size;
                ByteUtil.ensureExactWritable(buffer, encodedSize);
                buffer.writeByte(1);
                buffer.writeInt(this.properties.size());
                this.properties.forEach((? super K key, ? super V value) -> {
                    byte[] data = key.getData();
                    buffer.writeInt(data.length);
                    buffer.writeBytes(data);
                    value.write(buffer);
                });
            }
            assert (buffer.writerIndex() == writerIndex + encodedSize) : "Bad encode size estimation";
            int n = encodedSize;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getEncodeSize() {
        this.lock.readLock().lock();
        try {
            if (this.properties == null || this.size == 0) {
                int n = 1;
                return n;
            }
            int n = 5 + this.size;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            if (this.properties != null) {
                this.properties.clear();
            }
            this.size = 0;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.readLock().lock();
        try {
            StringBuilder sb = new StringBuilder("TypedProperties[");
            if (this.properties != null) {
                Iterator<Map.Entry<SimpleString, PropertyValue>> iter = this.properties.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<SimpleString, PropertyValue> iterItem = iter.next();
                    sb.append(String.valueOf(iterItem.getKey()) + "=");
                    Object theValue = iterItem.getValue().getValue();
                    if (theValue == null) {
                        sb.append("NULL-value");
                    } else if (theValue instanceof byte[]) {
                        byte[] bytes = (byte[])theValue;
                        sb.append("[" + ByteUtil.maxString(ByteUtil.bytesToHex(bytes, 2), 150) + "]");
                        if (iterItem.getKey().toString().startsWith("_AMQ_ROUTE_TO")) {
                            sb.append(", bytesAsLongs[");
                            try {
                                ByteBuffer buff = ByteBuffer.wrap(bytes);
                                while (buff.hasRemaining()) {
                                    long bindingID = buff.getLong();
                                    sb.append(bindingID);
                                    if (!buff.hasRemaining()) continue;
                                    sb.append(", ");
                                }
                            }
                            catch (Throwable e) {
                                sb.append("error-converting-longs=" + e.getMessage());
                            }
                            sb.append("]");
                        }
                    } else {
                        sb.append(theValue.toString());
                    }
                    if (!iter.hasNext()) continue;
                    sb.append(", ");
                }
            }
            String string = sb.append("]").toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPutValue(SimpleString key, PropertyValue value) {
        this.lock.writeLock().lock();
        try {
            PropertyValue oldValue;
            if (!this.internalProperties && this.internalPropertyPredicate != null && this.internalPropertyPredicate.test(key)) {
                this.internalProperties = true;
            }
            if (!this.amqpProperties && this.amqpPropertyPredicate != null && this.amqpPropertyPredicate.test(key)) {
                this.amqpProperties = true;
            }
            if (this.properties == null) {
                this.properties = new HashMap<SimpleString, PropertyValue>();
            }
            this.size = (oldValue = this.properties.put(key, value)) != null ? (this.size += value.encodeSize() - oldValue.encodeSize()) : (this.size += SimpleString.sizeofString(key) + value.encodeSize());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doRemoveProperty(SimpleString key) {
        this.lock.writeLock().lock();
        try {
            if (this.properties == null) {
                Object var2_2 = null;
                return var2_2;
            }
            PropertyValue val = this.properties.remove(key);
            if (val == null) {
                Object var3_4 = null;
                return var3_4;
            }
            this.size -= SimpleString.sizeofString(key) + val.encodeSize();
            Object object = val.getValue();
            return object;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doGetProperty(SimpleString key) {
        this.lock.readLock().lock();
        try {
            if (this.properties == null) {
                Object var2_2 = null;
                return var2_2;
            }
            PropertyValue val = this.properties.get(key);
            if (val == null) {
                Object var3_4 = null;
                return var3_4;
            }
            Object object = val.getValue();
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            if (this.properties == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.properties.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMapNames() {
        this.lock.readLock().lock();
        try {
            if (this.properties == null) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            HashSet<String> names = new HashSet<String>(this.properties.size());
            for (SimpleString name : this.properties.keySet()) {
                names.add(name.toString());
            }
            HashSet<String> hashSet = names;
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getMap() {
        this.lock.readLock().lock();
        try {
            if (this.properties == null) {
                Map<String, Object> map = Collections.emptyMap();
                return map;
            }
            HashMap<String, Object> m = new HashMap<String, Object>(this.properties.size());
            for (Map.Entry<SimpleString, PropertyValue> entry : this.properties.entrySet()) {
                Object val = entry.getValue().getValue();
                if (val instanceof SimpleString) {
                    SimpleString simpleString = (SimpleString)val;
                    m.put(entry.getKey().toString(), simpleString.toString());
                    continue;
                }
                m.put(entry.getKey().toString(), val);
            }
            HashMap<String, Object> hashMap = m;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Lock getReadLock() {
        return this.lock.readLock();
    }

    public Lock getWriteLock() {
        return this.lock.writeLock();
    }

    public static void setObjectProperty(SimpleString key, Object value, TypedProperties properties) {
        if (value == null) {
            properties.putNullValue(key);
        } else if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            properties.putBooleanProperty(key, booleanValue);
        } else if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            properties.putByteProperty(key, byteValue);
        } else if (value instanceof Character) {
            Character character = (Character)value;
            properties.putCharProperty(key, character.charValue());
        } else if (value instanceof Short) {
            Short shortValue = (Short)value;
            properties.putShortProperty(key, shortValue);
        } else if (value instanceof Integer) {
            Integer integer = (Integer)value;
            properties.putIntProperty(key, integer);
        } else if (value instanceof Long) {
            Long longValue = (Long)value;
            properties.putLongProperty(key, longValue);
        } else if (value instanceof Float) {
            Float floatValue = (Float)value;
            properties.putFloatProperty(key, floatValue.floatValue());
        } else if (value instanceof Double) {
            Double doubleValue = (Double)value;
            properties.putDoubleProperty(key, doubleValue);
        } else if (value instanceof String) {
            String string = (String)value;
            properties.putSimpleStringProperty(key, SimpleString.of(string));
        } else if (value instanceof SimpleString) {
            SimpleString simpleString = (SimpleString)value;
            properties.putSimpleStringProperty(key, simpleString);
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            properties.putBytesProperty(key, bytes);
        } else {
            throw new ActiveMQPropertyConversionException(String.valueOf(value.getClass()) + " is not a valid property type");
        }
    }

    private static final class BooleanValue
    extends PropertyValue {
        private static final int ENCODE_SIZE = 2;
        private static final BooleanValue TRUE = new BooleanValue(true);
        private static final BooleanValue FALSE = new BooleanValue(false);
        private final boolean val;
        private final Boolean objVal;

        private BooleanValue(boolean val) {
            this.val = val;
            this.objVal = val;
        }

        private static BooleanValue of(boolean val) {
            if (val) {
                return TRUE;
            }
            return FALSE;
        }

        @Override
        public Object getValue() {
            return this.objVal;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(2);
            buffer.writeBoolean(this.val);
        }

        @Override
        public int encodeSize() {
            return 2;
        }
    }

    private static abstract class PropertyValue {
        private PropertyValue() {
        }

        abstract Object getValue();

        abstract void write(ByteBuf var1);

        abstract int encodeSize();

        public String toString() {
            return String.valueOf(this.getValue());
        }
    }

    private static final class ByteValue
    extends PropertyValue {
        private static final int ENCODE_SIZE = 2;
        private static final ByteValue[] VALUES = new ByteValue[256];
        private final byte val;
        private final Byte objectVal;

        private static ByteValue valueOf(byte b) {
            int offset = 128;
            int index = b + 128;
            ByteValue value = VALUES[index];
            if (value == null) {
                ByteValue.VALUES[index] = new ByteValue(b);
                return ByteValue.VALUES[index];
            }
            return value;
        }

        private ByteValue(byte val) {
            this.val = val;
            this.objectVal = val;
        }

        @Override
        public Object getValue() {
            return this.objectVal;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(3);
            buffer.writeByte((int)this.val);
        }

        @Override
        public int encodeSize() {
            return 2;
        }
    }

    private static final class NullValue
    extends PropertyValue {
        private static final NullValue INSTANCE = new NullValue();

        private NullValue() {
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(0);
        }

        @Override
        public int encodeSize() {
            return 1;
        }
    }

    private static final class BytesValue
    extends PropertyValue {
        final byte[] val;

        private BytesValue(byte[] val) {
            this.val = val;
        }

        private BytesValue(ByteBuf buffer) {
            int len = buffer.readInt();
            this.val = new byte[len];
            buffer.readBytes(this.val);
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(4);
            buffer.writeInt(this.val.length);
            buffer.writeBytes(this.val);
        }

        @Override
        public int encodeSize() {
            return 5 + this.val.length;
        }
    }

    private static final class ShortValue
    extends PropertyValue {
        final short val;

        private ShortValue(short val) {
            this.val = val;
        }

        private ShortValue(ByteBuf buffer) {
            this.val = buffer.readShort();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(5);
            buffer.writeShort((int)this.val);
        }

        @Override
        public int encodeSize() {
            return 3;
        }
    }

    private static final class IntValue
    extends PropertyValue {
        final int val;

        private IntValue(int val) {
            this.val = val;
        }

        private IntValue(ByteBuf buffer) {
            this.val = buffer.readInt();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(6);
            buffer.writeInt(this.val);
        }

        @Override
        public int encodeSize() {
            return 5;
        }
    }

    private static final class LongValue
    extends PropertyValue {
        final long val;

        private LongValue(long val) {
            this.val = val;
        }

        private LongValue(ByteBuf buffer) {
            this.val = buffer.readLong();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(7);
            buffer.writeLong(this.val);
        }

        @Override
        public int encodeSize() {
            return 9;
        }
    }

    private static final class FloatValue
    extends PropertyValue {
        final float val;

        private FloatValue(float val) {
            this.val = val;
        }

        private FloatValue(ByteBuf buffer) {
            this.val = Float.intBitsToFloat(buffer.readInt());
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.val);
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(8);
            buffer.writeInt(Float.floatToIntBits(this.val));
        }

        @Override
        public int encodeSize() {
            return 5;
        }
    }

    private static final class DoubleValue
    extends PropertyValue {
        final double val;

        private DoubleValue(double val) {
            this.val = val;
        }

        private DoubleValue(ByteBuf buffer) {
            this.val = Double.longBitsToDouble(buffer.readLong());
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(9);
            buffer.writeLong(Double.doubleToLongBits(this.val));
        }

        @Override
        public int encodeSize() {
            return 9;
        }
    }

    public static final class StringValue
    extends PropertyValue {
        final SimpleString val;

        private StringValue(SimpleString val) {
            this.val = val;
        }

        static StringValue readStringValue(ByteBuf byteBuf, ByteBufStringValuePool pool) {
            if (pool == null) {
                return new StringValue(SimpleString.readSimpleString(byteBuf));
            }
            return (StringValue)pool.getOrCreate(byteBuf);
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(10);
            SimpleString.writeSimpleString(buffer, this.val);
        }

        @Override
        public int encodeSize() {
            return 1 + SimpleString.sizeofString(this.val);
        }

        public static final class ByteBufStringValuePool
        extends AbstractByteBufPool<StringValue> {
            public static final int DEFAULT_MAX_LENGTH = 36;
            private final int maxLength;

            public ByteBufStringValuePool() {
                this.maxLength = 36;
            }

            public ByteBufStringValuePool(int capacity) {
                this(capacity, 36);
            }

            public ByteBufStringValuePool(int capacity, int maxCharsLength) {
                super(capacity);
                this.maxLength = maxCharsLength;
            }

            @Override
            protected boolean isEqual(StringValue entry, ByteBuf byteBuf, int offset, int length) {
                if (entry == null || entry.val == null) {
                    return false;
                }
                return entry.val.equals(byteBuf, offset, length);
            }

            @Override
            protected boolean canPool(ByteBuf byteBuf, int length) {
                assert (length % 2 == 0) : "length must be a multiple of 2";
                int expectedStringLength = length >> 1;
                return expectedStringLength <= this.maxLength;
            }

            @Override
            protected StringValue create(ByteBuf byteBuf, int length) {
                return new StringValue(SimpleString.readSimpleString(byteBuf, length));
            }
        }
    }

    private static final class CharValue
    extends PropertyValue {
        final char val;

        private CharValue(char val) {
            this.val = val;
        }

        private CharValue(ByteBuf buffer) {
            this.val = (char)buffer.readShort();
        }

        @Override
        public Object getValue() {
            return Character.valueOf(this.val);
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(11);
            buffer.writeShort((int)((short)this.val));
        }

        @Override
        public int encodeSize() {
            return 3;
        }
    }

    public static class TypedPropertiesDecoderPools {
        private SimpleString.ByteBufSimpleStringPool propertyKeysPool;
        private StringValue.ByteBufStringValuePool propertyValuesPool;

        public TypedPropertiesDecoderPools() {
            this.propertyKeysPool = new SimpleString.ByteBufSimpleStringPool();
            this.propertyValuesPool = new StringValue.ByteBufStringValuePool();
        }

        public TypedPropertiesDecoderPools(int keyPoolCapacity, int valuePoolCapacity) {
            this.propertyKeysPool = new SimpleString.ByteBufSimpleStringPool(keyPoolCapacity);
            this.propertyValuesPool = new StringValue.ByteBufStringValuePool(valuePoolCapacity);
        }

        public SimpleString.ByteBufSimpleStringPool getPropertyKeysPool() {
            return this.propertyKeysPool;
        }

        public StringValue.ByteBufStringValuePool getPropertyValuesPool() {
            return this.propertyValuesPool;
        }
    }

    public static class TypedPropertiesStringSimpleStringPools {
        private SimpleString.StringSimpleStringPool propertyKeysPool;
        private SimpleString.StringSimpleStringPool propertyValuesPool;

        public TypedPropertiesStringSimpleStringPools() {
            this.propertyKeysPool = new SimpleString.StringSimpleStringPool();
            this.propertyValuesPool = new SimpleString.StringSimpleStringPool();
        }

        public TypedPropertiesStringSimpleStringPools(int keyPoolCapacity, int valuePoolCapacity) {
            this.propertyKeysPool = new SimpleString.StringSimpleStringPool(keyPoolCapacity);
            this.propertyValuesPool = new SimpleString.StringSimpleStringPool(valuePoolCapacity);
        }

        public SimpleString.StringSimpleStringPool getPropertyKeysPool() {
            return this.propertyKeysPool;
        }

        public SimpleString.StringSimpleStringPool getPropertyValuesPool() {
            return this.propertyValuesPool;
        }
    }
}

