/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.SortedSet;
import org.apache.rat.analysis.TikaProcessor;
import org.apache.rat.api.MetaData;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.tika.parser.txt.CharsetDetector;

public abstract class Document
implements Comparable<Document> {
    protected final DocumentNameMatcher nameMatcher;
    private final MetaData metaData;
    protected final DocumentName name;

    protected Document(DocumentName name, DocumentNameMatcher nameMatcher) {
        this.name = name;
        this.nameMatcher = nameMatcher;
        this.metaData = new MetaData();
    }

    public final DocumentName getName() {
        return this.name;
    }

    public final DocumentNameMatcher getNameMatcher() {
        return this.nameMatcher;
    }

    @Override
    public int compareTo(Document doc) {
        return this.name.compareTo(doc.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Document)) {
            return false;
        }
        return this.name.equals(((Document)obj).name);
    }

    public Reader reader() throws IOException {
        return new CharsetDetector().getReader(TikaProcessor.markSupportedInputStream(this.inputStream()), this.getMetaData().getCharset().name());
    }

    public abstract InputStream inputStream() throws IOException;

    public final MetaData getMetaData() {
        return this.metaData;
    }

    public String toString() {
        return String.format("%s( name = %s metaData = %s )", this.getClass().getSimpleName(), this.getName().localized(), this.getMetaData());
    }

    public abstract boolean isDirectory();

    public abstract SortedSet<Document> listChildren();

    public static enum Type {
        ARCHIVE,
        BINARY,
        GENERATED,
        NOTICE,
        STANDARD,
        UNKNOWN;

    }
}

