/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.rat.api.Document;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.document.guesser.NoteGuesser;
import org.apache.rat.utils.DefaultLog;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;

public final class TikaProcessor {
    private static final Tika TIKA = new Tika();
    private static final Map<String, Document.Type> DOCUMENT_TYPE_MAP = new HashMap<String, Document.Type>();

    private TikaProcessor() {
    }

    static Map<String, Document.Type> getDocumentTypeMap() {
        return new HashMap<String, Document.Type>(DOCUMENT_TYPE_MAP);
    }

    public static InputStream markSupportedInputStream(InputStream stream) {
        return stream.markSupported() ? stream : new BufferedInputStream(stream);
    }

    public static String process(Document document) throws RatDocumentAnalysisException {
        String string;
        block10: {
            Metadata metadata = new Metadata();
            InputStream stream = TikaProcessor.markSupportedInputStream(document.inputStream());
            try {
                metadata.set("resourceName", document.getName().getName());
                String result = TIKA.detect(stream, metadata);
                String[] parts = result.split("/");
                MediaType mediaType = new MediaType(parts[0], parts[1]);
                document.getMetaData().setMediaType(mediaType);
                document.getMetaData().setDocumentType(TikaProcessor.fromMediaType(mediaType));
                if (Document.Type.STANDARD == document.getMetaData().getDocumentType()) {
                    document.getMetaData().setCharset(TikaProcessor.detectCharset(stream, document.getName()));
                    if (NoteGuesser.isNote(document)) {
                        document.getMetaData().setDocumentType(Document.Type.NOTICE);
                    }
                }
                string = result;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RatDocumentAnalysisException(e);
                }
            }
            stream.close();
        }
        return string;
    }

    private static Charset detectCharset(InputStream stream, DocumentName documentName) throws IOException {
        CharsetDetector encodingDetector = new CharsetDetector();
        encodingDetector.setText(stream);
        CharsetMatch charsetMatch = encodingDetector.detect();
        if (charsetMatch != null) {
            try {
                return Charset.forName(charsetMatch.getName());
            }
            catch (UnsupportedCharsetException e) {
                DefaultLog.getInstance().warn(String.format("Unsupported character set '%s' in file '%s'.  Will use system default encoding.", charsetMatch.getName(), documentName));
            }
        }
        return null;
    }

    public static Document.Type fromMediaType(MediaType mediaType) {
        if ("text".equals(mediaType.getType())) {
            return Document.Type.STANDARD;
        }
        Document.Type result = DOCUMENT_TYPE_MAP.get(mediaType.toString());
        return result == null ? Document.Type.BINARY : result;
    }

    static {
        DOCUMENT_TYPE_MAP.put("application/x-ibooks+zip", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/epub+zip", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/vnd.wap.xhtml+xml", Document.Type.STANDARD);
        DOCUMENT_TYPE_MAP.put("application/x-asp", Document.Type.STANDARD);
        DOCUMENT_TYPE_MAP.put("application/xhtml+xml", Document.Type.STANDARD);
        DOCUMENT_TYPE_MAP.put("application/pdf", Document.Type.STANDARD);
        DOCUMENT_TYPE_MAP.put("application/zlib", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-gzip", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-bzip2", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-compress", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-java-pack200", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-lzma", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/deflate64", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-lz4", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-snappy", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-brotli", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/gzip", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-bzip", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-xz", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-tar", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/java-archive", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-arj", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-archive", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/zip", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-cpio", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-tika-unix-dump", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-7z-compressed", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-rar-compressed", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/x-xliff+xml", Document.Type.STANDARD);
        DOCUMENT_TYPE_MAP.put("application/x-xliff+zip", Document.Type.ARCHIVE);
        DOCUMENT_TYPE_MAP.put("application/xml", Document.Type.STANDARD);
        DOCUMENT_TYPE_MAP.put("image/svg+xml", Document.Type.STANDARD);
        DOCUMENT_TYPE_MAP.put("application/x-fictionbook+xml", Document.Type.STANDARD);
    }
}

