/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.TimeZones;
import org.apache.commons.validator.routines.TimeValidator;
import org.apache.commons.validator.util.TestTimeZones;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;
import org.junitpioneer.jupiter.DefaultTimeZone;

class TimeValidatorTest {
    protected TimeValidator validator;
    protected String[] patternValid = new String[]{"23-59-59", "00-00-00", "00-00-01", "0-0-0", "1-12-1", "10-49-18", "16-23-46"};
    protected Date[] patternExpect = new Date[]{TimeValidatorTest.createDate(null, 235959, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 1, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 11201, 0), TimeValidatorTest.createDate(null, 104918, 0), TimeValidatorTest.createDate(null, 162346, 0)};
    protected String[] localeValid = new String[]{"23:59", "00:00", "00:01", "0:0", "1:12", "10:49", "16:23"};
    protected Date[] localeExpect = new Date[]{TimeValidatorTest.createDate(null, 235900, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 100, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 11200, 0), TimeValidatorTest.createDate(null, 104900, 0), TimeValidatorTest.createDate(null, 162300, 0)};
    protected String[] patternInvalid = new String[]{"24-00-00", "24-00-01", "25-02-03", "10-61-31", "10-01-61", "05:02-29", "0X-01:01", "05-0X-01", "10-01-0X", "01:01:05", "10-10", "10--10", "10-10-"};
    protected String[] localeInvalid = new String[]{"24:00", "24:00", "25:02", "10:61", "05-02", "0X:01", "05:0X", "01-01", "10:", "10::1", "10:1:"};

    TimeValidatorTest() {
    }

    protected static Date createDate(TimeZone zone, int time, int millisecond) {
        Calendar calendar = TimeValidatorTest.createTime(zone, time, millisecond);
        return calendar.getTime();
    }

    protected static Calendar createTime(TimeZone zone, int time, int millisecond) {
        Calendar calendar = zone == null ? Calendar.getInstance() : Calendar.getInstance(zone);
        int hour = time / 10000 * 10000;
        int min = time / 100 * 100 - hour;
        int sec = time - (hour + min);
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, hour / 10000);
        calendar.set(12, min / 100);
        calendar.set(13, sec);
        calendar.set(14, millisecond);
        return calendar;
    }

    @BeforeEach
    protected void setUp() {
        this.validator = new TimeValidator();
    }

    @AfterEach
    protected void tearDown() {
        this.validator = null;
    }

    @Test
    void testCompare() {
        int testTime = 154523;
        int min = 100;
        int hour = 10000;
        Calendar milliGreater = TimeValidatorTest.createTime(TimeZones.GMT, 154523, 500);
        Calendar value = TimeValidatorTest.createTime(TimeZones.GMT, 154523, 400);
        Calendar milliLess = TimeValidatorTest.createTime(TimeZones.GMT, 154523, 300);
        Calendar secGreater = TimeValidatorTest.createTime(TimeZones.GMT, 154524, 100);
        Calendar secLess = TimeValidatorTest.createTime(TimeZones.GMT, 154522, 100);
        Calendar minGreater = TimeValidatorTest.createTime(TimeZones.GMT, 154623, 100);
        Calendar minLess = TimeValidatorTest.createTime(TimeZones.GMT, 154423, 100);
        Calendar hourGreater = TimeValidatorTest.createTime(TimeZones.GMT, 164523, 100);
        Calendar hourLess = TimeValidatorTest.createTime(TimeZones.GMT, 144523, 100);
        Assertions.assertEquals((int)-1, (int)this.validator.compareTime(value, milliGreater), (String)"milli LT");
        Assertions.assertEquals((int)0, (int)this.validator.compareTime(value, value), (String)"milli EQ");
        Assertions.assertEquals((int)1, (int)this.validator.compareTime(value, milliLess), (String)"milli GT");
        Assertions.assertEquals((int)-1, (int)this.validator.compareSeconds(value, secGreater), (String)"secs LT");
        Assertions.assertEquals((int)0, (int)this.validator.compareSeconds(value, milliGreater), (String)"secs =1");
        Assertions.assertEquals((int)0, (int)this.validator.compareSeconds(value, value), (String)"secs =2");
        Assertions.assertEquals((int)0, (int)this.validator.compareSeconds(value, milliLess), (String)"secs =3");
        Assertions.assertEquals((int)1, (int)this.validator.compareSeconds(value, secLess), (String)"secs GT");
        Assertions.assertEquals((int)-1, (int)this.validator.compareMinutes(value, minGreater), (String)"mins LT");
        Assertions.assertEquals((int)0, (int)this.validator.compareMinutes(value, secGreater), (String)"mins =1");
        Assertions.assertEquals((int)0, (int)this.validator.compareMinutes(value, value), (String)"mins =2");
        Assertions.assertEquals((int)0, (int)this.validator.compareMinutes(value, secLess), (String)"mins =3");
        Assertions.assertEquals((int)1, (int)this.validator.compareMinutes(value, minLess), (String)"mins GT");
        Assertions.assertEquals((int)-1, (int)this.validator.compareHours(value, hourGreater), (String)"hour LT");
        Assertions.assertEquals((int)0, (int)this.validator.compareHours(value, minGreater), (String)"hour =1");
        Assertions.assertEquals((int)0, (int)this.validator.compareHours(value, value), (String)"hour =2");
        Assertions.assertEquals((int)0, (int)this.validator.compareHours(value, minLess), (String)"hour =3");
        Assertions.assertEquals((int)1, (int)this.validator.compareHours(value, hourLess), (String)"hour GT");
    }

    @Test
    @DefaultLocale(value="en-GB")
    void testFormat() {
        Calendar cal = TimeValidatorTest.createTime(null, 164923, 0);
        DateFormat df = DateFormat.getTimeInstance(3);
        String val = df.format(cal.getTime());
        DateFormat dfus = DateFormat.getTimeInstance(3, Locale.US);
        String valus = dfus.format(cal.getTime());
        Calendar test = TimeValidator.getInstance().validate("16:49:23", "HH:mm:ss");
        Assertions.assertNotNull((Object)test, (String)"Test Date ");
        Assertions.assertEquals((Object)"16-49-23", (Object)this.validator.format((Object)test, "HH-mm-ss"), (String)"Format pattern");
        Assertions.assertEquals((Object)valus, (Object)this.validator.format((Object)test, Locale.US), (String)"Format locale");
        Assertions.assertEquals((Object)val, (Object)this.validator.format((Object)test), (String)"Format default");
    }

    @Test
    void testLocaleInvalid() {
        for (int i = 0; i < this.localeInvalid.length; ++i) {
            String text = i + " value=[" + this.localeInvalid[i] + "] passed ";
            Calendar date = this.validator.validate(this.localeInvalid[i], Locale.US);
            Assertions.assertNull((Object)date, (String)("validate() " + text + date));
            Assertions.assertFalse((boolean)this.validator.isValid(this.localeInvalid[i], Locale.UK), (String)("isValid() " + text));
        }
    }

    @Test
    void testLocaleValid() {
        for (int i = 0; i < this.localeValid.length; ++i) {
            String text = i + " value=[" + this.localeValid[i] + "] failed ";
            Calendar calendar = this.validator.validate(this.localeValid[i], Locale.UK);
            Assertions.assertNotNull((Object)calendar, (String)("validate() " + text));
            Date date = calendar.getTime();
            Assertions.assertTrue((boolean)this.validator.isValid(this.localeValid[i], Locale.UK), (String)("isValid() " + text));
            Assertions.assertEquals((Object)this.localeExpect[i], (Object)date, (String)("compare " + text));
        }
    }

    @Test
    void testPatternInvalid() {
        for (int i = 0; i < this.patternInvalid.length; ++i) {
            String text = i + " value=[" + this.patternInvalid[i] + "] passed ";
            Calendar date = this.validator.validate(this.patternInvalid[i], "HH-mm-ss");
            Assertions.assertNull((Object)date, (String)("validate() " + text + date));
            Assertions.assertFalse((boolean)this.validator.isValid(this.patternInvalid[i], "HH-mm-ss"), (String)("isValid() " + text));
        }
    }

    @Test
    void testPatternValid() {
        for (int i = 0; i < this.patternValid.length; ++i) {
            String text = i + " value=[" + this.patternValid[i] + "] failed ";
            Calendar calendar = this.validator.validate(this.patternValid[i], "HH-mm-ss");
            Assertions.assertNotNull((Object)calendar, (String)("validateObj() " + text));
            Date date = calendar.getTime();
            Assertions.assertTrue((boolean)this.validator.isValid(this.patternValid[i], "HH-mm-ss"), (String)("isValid() " + text));
            Assertions.assertEquals((Object)this.patternExpect[i], (Object)date, (String)("compare " + text));
        }
    }

    @Test
    @DefaultLocale(value="en-GB")
    @DefaultTimeZone(value="GMT")
    void testTimeZone() {
        Calendar result = this.validator.validate("18:01");
        Assertions.assertNotNull((Object)result, (String)"default result");
        Assertions.assertEquals((Object)TimeZones.GMT, (Object)result.getTimeZone(), (String)"default zone");
        Assertions.assertEquals((int)18, (int)result.get(11), (String)"default hour");
        Assertions.assertEquals((int)1, (int)result.get(12), (String)"default minute");
        result = null;
        result = this.validator.validate("16:49", TestTimeZones.EST);
        Assertions.assertNotNull((Object)result, (String)"zone result");
        Assertions.assertEquals((Object)TestTimeZones.EST, (Object)result.getTimeZone(), (String)"zone zone");
        Assertions.assertEquals((int)16, (int)result.get(11), (String)"zone hour");
        Assertions.assertEquals((int)49, (int)result.get(12), (String)"zone minute");
        result = null;
        result = this.validator.validate("14-34", "HH-mm", TestTimeZones.EST);
        Assertions.assertNotNull((Object)result, (String)"pattern result");
        Assertions.assertEquals((Object)TestTimeZones.EST, (Object)result.getTimeZone(), (String)"pattern zone");
        Assertions.assertEquals((int)14, (int)result.get(11), (String)"pattern hour");
        Assertions.assertEquals((int)34, (int)result.get(12), (String)"pattern minute");
        result = null;
        DateFormat usdf = DateFormat.getTimeInstance(3, Locale.US);
        Calendar uscal = Calendar.getInstance(Locale.US);
        uscal.set(2005, 0, 1, 19, 18);
        String usVal = usdf.format(uscal.getTime());
        result = this.validator.validate(usVal, Locale.US, TestTimeZones.EST);
        Assertions.assertNotNull((Object)result, (String)("locale result: " + usVal));
        Assertions.assertEquals((Object)TestTimeZones.EST, (Object)result.getTimeZone(), (String)("locale zone: " + usVal));
        Assertions.assertEquals((int)19, (int)result.get(11), (String)("locale hour: " + usVal));
        Assertions.assertEquals((int)18, (int)result.get(12), (String)("locale minute: " + usVal));
        result = null;
        String dateTimePattern = "dd/MMM/yy HH-mm";
        Calendar decal = Calendar.getInstance(Locale.GERMAN);
        decal.set(2005, 11, 31, 21, 5);
        String germanSample = new SimpleDateFormat("dd/MMM/yy HH-mm", Locale.GERMAN).format(decal.getTime());
        result = this.validator.validate(germanSample, "dd/MMM/yy HH-mm", Locale.GERMAN, TestTimeZones.EST);
        Assertions.assertNotNull((Object)result, (String)("pattern result: " + germanSample));
        Assertions.assertEquals((Object)TestTimeZones.EST, (Object)result.getTimeZone(), (String)"pattern zone");
        Assertions.assertEquals((int)2005, (int)result.get(1), (String)"pattern day");
        Assertions.assertEquals((int)11, (int)result.get(2), (String)"pattern day");
        Assertions.assertEquals((int)31, (int)result.get(5), (String)"pattern day");
        Assertions.assertEquals((int)21, (int)result.get(11), (String)"pattern hour");
        Assertions.assertEquals((int)5, (int)result.get(12), (String)"pattern minute");
        result = null;
        result = this.validator.validate(germanSample, "dd/MMM/yy HH-mm", Locale.GERMAN);
        Assertions.assertNotNull((Object)result, (String)("pattern result: " + germanSample));
        Assertions.assertEquals((Object)TimeZones.GMT, (Object)result.getTimeZone(), (String)"pattern zone");
        Assertions.assertEquals((int)2005, (int)result.get(1), (String)"pattern day");
        Assertions.assertEquals((int)11, (int)result.get(2), (String)"pattern day");
        Assertions.assertEquals((int)31, (int)result.get(5), (String)"pattern day");
        Assertions.assertEquals((int)21, (int)result.get(11), (String)"pattern hour");
        Assertions.assertEquals((int)5, (int)result.get(12), (String)"pattern minute");
        result = null;
    }
}

