/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.roundtrip;

import java.awt.image.BufferedImage;
import java.util.stream.Stream;
import org.apache.commons.imaging.roundtrip.FormatInfo;
import org.apache.commons.imaging.roundtrip.RoundtripBase;
import org.apache.commons.imaging.roundtrip.TestImages;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class FullColorRoundtrip
extends RoundtripBase {
    public static final BufferedImage[] images = new BufferedImage[]{TestImages.createFullColorImage(1, 1), TestImages.createFullColorImage(2, 2), TestImages.createFullColorImage(10, 10), TestImages.createFullColorImage(300, 300)};

    public static Stream<Arguments> testFullColorRoundtrip() {
        return FullColorRoundtrip.createRoundtripArguments(images);
    }

    @ParameterizedTest
    @MethodSource
    public void testFullColorRoundtrip(BufferedImage testImage, FormatInfo formatInfo) throws Exception {
        boolean imageExact = true;
        if (formatInfo.colorSupport == 3) {
            imageExact = false;
        }
        if (formatInfo.colorSupport == 2) {
            imageExact = false;
        }
        if (formatInfo.colorSupport == 1) {
            imageExact = false;
        }
        this.roundtrip(formatInfo, testImage, "fullColor", imageExact);
    }
}

