/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.webp.chunks;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.webp.chunks.AbstractWebPChunk;

public final class WebPChunkVp8
extends AbstractWebPChunk {
    private final int versionNumber;
    private final int width;
    private final int height;
    private final int horizontalScale;
    private final int verticalScale;

    public WebPChunkVp8(int type, int size, byte[] bytes) throws ImagingException {
        super(type, size, bytes);
        if (size < 10) {
            throw new ImagingException("Invalid VP8 chunk");
        }
        int b0 = bytes[0] & 0xFF;
        if ((b0 & 1) != 0) {
            throw new ImagingException("Invalid VP8 chunk: should be key frame");
        }
        this.versionNumber = (b0 & 0xE) >> 1;
        if ((b0 & 0x10) == 0) {
            throw new ImagingException("Invalid VP8 chunk: frame should to be display");
        }
        int b3 = bytes[3] & 0xFF;
        int b4 = bytes[4] & 0xFF;
        int b5 = bytes[5] & 0xFF;
        int b6 = bytes[6] & 0xFF;
        int b7 = bytes[7] & 0xFF;
        int b8 = bytes[8] & 0xFF;
        int b9 = bytes[9] & 0xFF;
        if (b3 != 157 || b4 != 1 || b5 != 42) {
            throw new ImagingException("Invalid VP8 chunk: invalid signature");
        }
        this.width = b6 + ((b7 & 0x3F) << 8);
        this.horizontalScale = b7 >> 6;
        this.height = b8 + ((b9 & 0x3F) << 8);
        this.verticalScale = b9 >> 6;
    }

    @Override
    public void dump(PrintWriter pw, int offset) throws ImagingException, IOException {
        super.dump(pw, offset);
        pw.println("  Version Number: " + this.getVersionNumber());
        pw.println("  Width: " + this.getWidth());
        pw.println("  Height: " + this.getHeight());
        pw.println("  Horizontal Scale: " + this.getHorizontalScale());
        pw.println("  Vertical Scale: " + this.getVerticalScale());
    }

    public int getHeight() {
        return this.height;
    }

    public int getHorizontalScale() {
        return this.horizontalScale;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public int getVerticalScale() {
        return this.verticalScale;
    }

    public int getWidth() {
        return this.width;
    }
}

