/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.apache.commons.fileupload2.core.DeferrableOutputStream;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DiskFileItemTest {
    DiskFileItemTest() {
    }

    protected void assertState(DiskFileItem dfi, DeferrableOutputStream.State state, boolean inMemory, Path parentDir, String testString) throws IOException {
        DeferrableOutputStream dos = (DeferrableOutputStream)dfi.getOutputStream();
        Assertions.assertEquals((Object)state, (Object)dos.getState());
        Assertions.assertEquals((Object)inMemory, (Object)dfi.isInMemory());
        Assertions.assertEquals((Object)inMemory, (Object)dos.isInMemory());
        if (parentDir == null) {
            Assertions.assertNull((Object)dos.getPath());
        } else {
            Assertions.assertNotNull((Object)dos.getPath());
            Assertions.assertEquals((Object)parentDir, (Object)dos.getPath().getParent());
        }
        if (testString != null) {
            Assertions.assertEquals((long)testString.length(), (long)dfi.getSize());
            Assertions.assertEquals((long)testString.length(), (long)dos.getSize());
            Assertions.assertEquals((Object)testString, (Object)dfi.getString());
            Assertions.assertArrayEquals((byte[])testString.getBytes(), (byte[])dfi.get());
        } else {
            Assertions.assertNull((Object)dfi.get());
            Assertions.assertNull((Object)dfi.getString());
        }
    }

    @Test
    void testBuilderHeaders() {
        DiskFileItem.Builder builder = DiskFileItem.builder();
        Assertions.assertNotNull((Object)builder.getFileItemHeaders());
        DiskFileItem fileItem = builder.get();
        Assertions.assertNotNull((Object)fileItem.getHeaders(), (String)"Missing default headers (empty)");
        Assertions.assertFalse((boolean)fileItem.getHeaders().getHeaderNames().hasNext());
        Assertions.assertNotNull((Object)fileItem.getHeaders());
        FileItemHeaders fileItemHeaders = FileItemFactory.AbstractFileItemBuilder.newFileItemHeaders();
        Assertions.assertNotNull((Object)fileItemHeaders);
        fileItem.setHeaders(fileItemHeaders);
        Assertions.assertSame((Object)fileItemHeaders, (Object)fileItem.getHeaders());
    }

    @Test
    void testStateModelWithPositiveThreshold() {
        IntConsumer tester = numBytes -> {
            try {
                Path testDir = Paths.get("target/unit-tests/" + DiskFileItemTest.class.getSimpleName(), new String[0]);
                Files.createDirectories(testDir, new FileAttribute[0]);
                Path tempTestDir = Files.createTempDirectory(testDir, "testDir", new FileAttribute[0]);
                DiskFileItemFactory dfif = ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setThreshold(numBytes).setPath(tempTestDir)).setCharset(StandardCharsets.UTF_8)).get();
                Assertions.assertEquals((int)numBytes, (int)dfif.getThreshold());
                DiskFileItem dfi = dfif.fileItemBuilder().get();
                Assertions.assertEquals((int)numBytes, (int)dfi.getThreshold());
                this.assertState(dfi, DeferrableOutputStream.State.initialized, true, null, null);
                StringBuilder sb = new StringBuilder();
                try (OutputStream os = dfi.getOutputStream();){
                    for (int i = 0; i < numBytes - 1; ++i) {
                        os.write(46);
                        sb.append('.');
                        this.assertState(dfi, DeferrableOutputStream.State.opened, true, null, null);
                    }
                    os.write(44);
                    sb.append(',');
                    this.assertState(dfi, DeferrableOutputStream.State.persisted, false, tempTestDir, null);
                }
                this.assertState(dfi, DeferrableOutputStream.State.closed, false, tempTestDir, sb.toString());
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        };
        tester.accept(5);
        tester.accept(8193);
    }

    @Test
    void testStateModelWithThresholdMinusOne() {
        Consumer<String> tester = ts -> {
            try {
                Path testDir = Paths.get("target/unit-tests/" + DiskFileItemTest.class.getSimpleName(), new String[0]);
                Files.createDirectories(testDir, new FileAttribute[0]);
                Path tempTestDir = Files.createTempDirectory(testDir, "testDir", new FileAttribute[0]);
                DiskFileItemFactory dfif = ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setBufferSize(-1).setPath(tempTestDir)).setCharset(StandardCharsets.UTF_8)).get();
                Assertions.assertEquals((int)-1, (int)dfif.getThreshold());
                DiskFileItem dfi = dfif.fileItemBuilder().get();
                Assertions.assertEquals((int)-1, (int)dfi.getThreshold());
                this.assertState(dfi, DeferrableOutputStream.State.persisted, false, tempTestDir, null);
                try (OutputStream out = dfi.getOutputStream();){
                    out.write(ts.getBytes());
                }
                this.assertState(dfi, DeferrableOutputStream.State.closed, false, tempTestDir, (String)ts);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        };
        tester.accept("abcdef");
        tester.accept("aAbBcCdDeEfF012345");
    }

    @Test
    void testStateModelWithThresholdZero() {
        IntConsumer tester = numBytes -> {
            try {
                Path testDir = Paths.get("target/unit-tests/" + DiskFileItemTest.class.getSimpleName(), new String[0]);
                Files.createDirectories(testDir, new FileAttribute[0]);
                Path tempTestDir = Files.createTempDirectory(testDir, "testDir", new FileAttribute[0]);
                DiskFileItemFactory dfif = ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setBufferSize(0).setPath(tempTestDir)).setCharset(StandardCharsets.UTF_8)).get();
                Assertions.assertEquals((int)0, (int)dfif.getThreshold());
                DiskFileItem dfi = dfif.fileItemBuilder().get();
                Assertions.assertEquals((int)0, (int)dfi.getThreshold());
                this.assertState(dfi, DeferrableOutputStream.State.initialized, true, null, null);
                StringBuilder sb = new StringBuilder();
                try (OutputStream os = dfi.getOutputStream();){
                    for (int i = 0; i < numBytes; ++i) {
                        os.write(46);
                        sb.append('.');
                        this.assertState(dfi, DeferrableOutputStream.State.persisted, false, tempTestDir, null);
                    }
                    os.write(44);
                    sb.append(',');
                }
                this.assertState(dfi, DeferrableOutputStream.State.closed, false, tempTestDir, sb.toString());
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        };
        tester.accept(5);
        tester.accept(8193);
    }
}

