/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.io.InputStream;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.xml.HandlerFactory;
import org.apache.cayenne.configuration.xml.LoaderContext;
import org.apache.cayenne.configuration.xml.RootDataMapHandler;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.resource.Resource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLDataMapLoader
implements DataMapLoader {
    private static final String DATA_MAP_LOCATION_SUFFIX = ".map.xml";
    @Inject
    protected HandlerFactory handlerFactory;
    @Inject
    protected Provider<XMLReader> xmlReaderProvider;

    @Override
    public synchronized DataMap load(Resource configurationResource) throws CayenneRuntimeException {
        DataMap[] maps = new DataMap[1];
        try (InputStream in = configurationResource.getURL().openStream();){
            XMLReader parser = this.xmlReaderProvider.get();
            LoaderContext loaderContext = new LoaderContext(parser, this.handlerFactory);
            loaderContext.addDataMapListener(dataMap -> {
                dataMap.setConfigurationSource(configurationResource);
                maps[0] = dataMap;
            });
            RootDataMapHandler rootHandler = new RootDataMapHandler(loaderContext);
            parser.setContentHandler(rootHandler);
            parser.setErrorHandler(rootHandler);
            InputSource input = new InputSource(in);
            input.setSystemId(configurationResource.getURL().toString());
            parser.parse(input);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error loading configuration from %s", (Throwable)e, configurationResource.getURL());
        }
        if (maps[0] == null) {
            throw new CayenneRuntimeException("Unable to load data map from %s", configurationResource.getURL());
        }
        DataMap map = maps[0];
        if (map.getName() == null) {
            map.setName(this.mapNameFromLocation(configurationResource.getURL().getFile()));
        }
        return map;
    }

    protected String mapNameFromLocation(String location) {
        if (location == null) {
            return "Untitled";
        }
        int lastSlash = location.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = location.lastIndexOf(92);
        }
        if (lastSlash >= 0 && lastSlash + 1 < location.length()) {
            location = location.substring(lastSlash + 1);
        }
        if (location.endsWith(DATA_MAP_LOCATION_SUFFIX)) {
            location = location.substring(0, location.length() - DATA_MAP_LOCATION_SUFFIX.length());
        }
        return location;
    }

    public void setHandlerFactory(HandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }
}

