/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.validation;

import org.apache.cassandra.spark.validation.StartupValidation;
import org.apache.cassandra.spark.validation.StartupValidator;
import org.apache.cassandra.spark.validation.TestValidation;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StartupValidatorTests {
    @BeforeEach
    public void beforeEach() {
        StartupValidator.instance().reset();
    }

    @Test
    public void testWithoutValidations() {
        Assertions.assertThatNoException().isThrownBy(() -> ((StartupValidator)StartupValidator.instance()).perform());
    }

    @Test
    public void testSucceedingValidations() {
        StartupValidator.instance().register((StartupValidation)TestValidation.succeeding());
        StartupValidator.instance().register((StartupValidation)TestValidation.succeeding());
        StartupValidator.instance().register((StartupValidation)TestValidation.succeeding());
        Assertions.assertThatNoException().isThrownBy(() -> ((StartupValidator)StartupValidator.instance()).perform());
    }

    @Test
    public void testFailingValidations() {
        StartupValidator.instance().register((StartupValidation)TestValidation.succeeding());
        StartupValidator.instance().register((StartupValidation)TestValidation.failing());
        StartupValidator.instance().register((StartupValidation)TestValidation.succeeding());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((StartupValidator)StartupValidator.instance()).perform()).isInstanceOf(RuntimeException.class)).hasMessage("Failed some of startup validations");
    }

    @Test
    public void testSkipValidations() {
        System.setProperty("SKIP_STARTUP_VALIDATIONS", "true");
        StartupValidator.instance().register((StartupValidation)TestValidation.succeeding());
        StartupValidator.instance().register((StartupValidation)TestValidation.failing());
        StartupValidator.instance().register((StartupValidation)TestValidation.succeeding());
        StartupValidator.instance().perform();
        System.clearProperty("SKIP_STARTUP_VALIDATIONS");
    }

    @AfterAll
    public static void afterAll() {
        StartupValidator.instance().reset();
    }
}

