/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.secrets.SslConfig;
import org.apache.cassandra.spark.KryoRegister;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.apache.cassandra.spark.bulkwriter.util.SbwKryoRegistrator;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.LocalDataLayer;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.CassandraRing;
import org.apache.cassandra.spark.data.partitioner.TokenPartitioner;
import org.apache.cassandra.spark.transports.storage.StorageAccessConfiguration;
import org.apache.cassandra.spark.transports.storage.StorageCredentialPair;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportConfiguration;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.quicktheories.QuickTheory;
import org.quicktheories.generators.SourceDSL;

public class KryoSerializationTests {
    private static final Map<CassandraVersion, Kryo> KRYO = new HashMap<CassandraVersion, Kryo>();

    private static Output serialize(CassandraVersion version, Object object) {
        try (Output out = new Output(1024, -1);){
            KRYO.get(version).writeObject(out, object);
            Output output = out;
            return output;
        }
    }

    private static <T> T deserialize(CassandraVersion version, Output output, Class<T> type) {
        try (Input in = new Input(output.getBuffer(), 0, output.position());){
            Object object = KRYO.get(version).readObject(in, type);
            return (T)object;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCqlField(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(25).forAll(SourceDSL.booleans().all(), SourceDSL.booleans().all(), TestUtils.cql3Type((CassandraBridge)bridge), SourceDSL.integers().all()).checkAssert((isPartitionKey, isClusteringKey, cqlType, position) -> {
            CqlField field = new CqlField(isPartitionKey.booleanValue(), isClusteringKey != false && isPartitionKey == false, false, RandomUtils.randomAlphanumeric((int)5, (int)20), (CqlField.CqlType)cqlType, position.intValue());
            Output out = KryoSerializationTests.serialize(bridge.getVersion(), field);
            CqlField deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, CqlField.class);
            Assertions.assertThat((Comparable)deserialized).isEqualTo((Object)field);
            Assertions.assertThat((String)deserialized.name()).isEqualTo(field.name());
            Assertions.assertThat((Object)deserialized.type()).isEqualTo((Object)field.type());
            Assertions.assertThat((int)deserialized.position()).isEqualTo(field.position());
            Assertions.assertThat((boolean)deserialized.isPartitionKey()).isEqualTo(field.isPartitionKey());
            Assertions.assertThat((boolean)deserialized.isClusteringColumn()).isEqualTo(field.isClusteringColumn());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCqlFieldSet(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(25).forAll(SourceDSL.booleans().all(), SourceDSL.booleans().all(), TestUtils.cql3Type((CassandraBridge)bridge), SourceDSL.integers().all()).checkAssert((isPartitionKey, isClusteringKey, cqlType, position) -> {
            CqlField.CqlSet setType = bridge.set((CqlField.CqlType)cqlType);
            CqlField field = new CqlField(isPartitionKey.booleanValue(), isClusteringKey != false && isPartitionKey == false, false, RandomUtils.randomAlphanumeric((int)5, (int)20), (CqlField.CqlType)setType, position.intValue());
            Output out = KryoSerializationTests.serialize(bridge.getVersion(), field);
            CqlField deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, CqlField.class);
            Assertions.assertThat((Comparable)deserialized).isEqualTo((Object)field);
            Assertions.assertThat((String)deserialized.name()).isEqualTo(field.name());
            Assertions.assertThat((Object)deserialized.type()).isEqualTo((Object)field.type());
            Assertions.assertThat((int)deserialized.position()).isEqualTo(field.position());
            Assertions.assertThat((boolean)deserialized.isPartitionKey()).isEqualTo(field.isPartitionKey());
            Assertions.assertThat((boolean)deserialized.isClusteringColumn()).isEqualTo(field.isClusteringColumn());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCqlFieldList(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(25).forAll(SourceDSL.booleans().all(), SourceDSL.booleans().all(), TestUtils.cql3Type((CassandraBridge)bridge), SourceDSL.integers().all()).checkAssert((isPartitionKey, isClusteringKey, cqlType, position) -> {
            CqlField.CqlList listType = bridge.list((CqlField.CqlType)cqlType);
            CqlField field = new CqlField(isPartitionKey.booleanValue(), isClusteringKey != false && isPartitionKey == false, false, RandomUtils.randomAlphanumeric((int)5, (int)20), (CqlField.CqlType)listType, position.intValue());
            Output out = KryoSerializationTests.serialize(bridge.getVersion(), field);
            CqlField deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, CqlField.class);
            Assertions.assertThat((Comparable)deserialized).isEqualTo((Object)field);
            Assertions.assertThat((String)deserialized.name()).isEqualTo(field.name());
            Assertions.assertThat((Object)deserialized.type()).isEqualTo((Object)field.type());
            Assertions.assertThat((int)deserialized.position()).isEqualTo(field.position());
            Assertions.assertThat((boolean)deserialized.isPartitionKey()).isEqualTo(field.isPartitionKey());
            Assertions.assertThat((boolean)deserialized.isClusteringColumn()).isEqualTo(field.isClusteringColumn());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCqlFieldMap(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(25).forAll(SourceDSL.booleans().all(), SourceDSL.booleans().all(), TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert((isPartitionKey, isClusteringKey, cqlType1, cqlType2) -> {
            CqlField.CqlMap mapType = bridge.map((CqlField.CqlType)cqlType1, (CqlField.CqlType)cqlType2);
            CqlField field = new CqlField(isPartitionKey.booleanValue(), isClusteringKey != false && isPartitionKey == false, false, RandomUtils.randomAlphanumeric((int)5, (int)20), (CqlField.CqlType)mapType, 2);
            Output out = KryoSerializationTests.serialize(bridge.getVersion(), field);
            CqlField deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, CqlField.class);
            Assertions.assertThat((Comparable)deserialized).isEqualTo((Object)field);
            Assertions.assertThat((String)deserialized.name()).isEqualTo(field.name());
            Assertions.assertThat((Object)deserialized.type()).isEqualTo((Object)field.type());
            Assertions.assertThat((int)deserialized.position()).isEqualTo(field.position());
            Assertions.assertThat((boolean)deserialized.isPartitionKey()).isEqualTo(field.isPartitionKey());
            Assertions.assertThat((boolean)deserialized.isClusteringColumn()).isEqualTo(field.isClusteringColumn());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCqlUdt(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(25).forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert((type1, type2) -> {
            CqlField.CqlUdt udt = bridge.udt("keyspace", "testudt").withField("a", (CqlField.CqlType)type1).withField("b", (CqlField.CqlType)type2).build();
            CqlField field = new CqlField(false, false, false, RandomUtils.randomAlphanumeric((int)5, (int)20), (CqlField.CqlType)udt, 2);
            Output out = KryoSerializationTests.serialize(bridge.getVersion(), field);
            CqlField deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, CqlField.class);
            Assertions.assertThat((Comparable)deserialized).isEqualTo((Object)field);
            Assertions.assertThat((String)deserialized.name()).isEqualTo(field.name());
            Assertions.assertThat((Object)deserialized.type()).isEqualTo((Object)udt);
            Assertions.assertThat((int)deserialized.position()).isEqualTo(field.position());
            Assertions.assertThat((boolean)deserialized.isPartitionKey()).isEqualTo(field.isPartitionKey());
            Assertions.assertThat((boolean)deserialized.isClusteringColumn()).isEqualTo(field.isClusteringColumn());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCqlTuple(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(25).forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert((type1, type2) -> {
            CqlField.CqlTuple tuple = bridge.tuple(new CqlField.CqlType[]{type1, bridge.blob(), type2, bridge.set((CqlField.CqlType)bridge.text()), bridge.bigint(), bridge.map((CqlField.CqlType)type2, (CqlField.CqlType)bridge.timeuuid())});
            CqlField field = new CqlField(false, false, false, RandomUtils.randomAlphanumeric((int)5, (int)20), (CqlField.CqlType)tuple, 2);
            Output out = KryoSerializationTests.serialize(bridge.getVersion(), field);
            CqlField deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, CqlField.class);
            Assertions.assertThat((Comparable)deserialized).isEqualTo((Object)field);
            Assertions.assertThat((String)deserialized.name()).isEqualTo(field.name());
            Assertions.assertThat((Object)deserialized.type()).isEqualTo((Object)tuple);
            Assertions.assertThat((int)deserialized.position()).isEqualTo(field.position());
            Assertions.assertThat((boolean)deserialized.isPartitionKey()).isEqualTo(field.isPartitionKey());
            Assertions.assertThat((boolean)deserialized.isClusteringColumn()).isEqualTo(field.isClusteringColumn());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCqlTable(CassandraBridge bridge) {
        ImmutableList fields = ImmutableList.of((Object)new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.bigint(), 0), (Object)new CqlField(true, false, false, "b", (CqlField.CqlType)bridge.bigint(), 1), (Object)new CqlField(false, true, false, "c", (CqlField.CqlType)bridge.bigint(), 2), (Object)new CqlField(false, false, false, "d", (CqlField.CqlType)bridge.timestamp(), 3), (Object)new CqlField(false, false, false, "e", (CqlField.CqlType)bridge.text(), 4));
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        CqlTable table = new CqlTable("test_keyspace", "test_table", "create table test_keyspace.test_table (a bigint, b bigint, c bigint, d bigint, e bigint, primary key((a, b), c));", replicationFactor, (List)fields);
        Output out = KryoSerializationTests.serialize(bridge.getVersion(), table);
        CqlTable deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, CqlTable.class);
        Assertions.assertThat((Object)deserialized).isNotNull();
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)table);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCassandraInstance(CassandraBridge bridge) {
        CassandraInstance instance = new CassandraInstance("-9223372036854775807", "local1-i1", "DC1");
        Output out = KryoSerializationTests.serialize(bridge.getVersion(), instance);
        CassandraInstance deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, CassandraInstance.class);
        Assertions.assertThat((Object)deserialized).isNotNull();
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)instance);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCassandraRing(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.partitioners()).checkAssert(partitioner -> {
            CassandraRing ring = TestUtils.createRing(partitioner, (Map<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
            Output out = KryoSerializationTests.serialize(bridge.getVersion(), ring);
            CassandraRing deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, CassandraRing.class);
            Assertions.assertThat((Object)deserialized).isNotNull();
            Assertions.assertThat((Object)deserialized).isEqualTo((Object)ring);
            Assertions.assertThat((Comparable)deserialized.partitioner()).isEqualTo(partitioner);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testLocalDataLayer(CassandraBridge bridge) {
        String path1 = UUID.randomUUID().toString();
        String path2 = UUID.randomUUID().toString();
        String path3 = UUID.randomUUID().toString();
        LocalDataLayer localDataLayer = new LocalDataLayer(bridge.getVersion(), "test_keyspace", "create table test_keyspace.test_table (a int, b int, c int, primary key(a, b));", new String[]{path1, path2, path3});
        Output out = KryoSerializationTests.serialize(bridge.getVersion(), localDataLayer);
        LocalDataLayer deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, LocalDataLayer.class);
        Assertions.assertThat((Object)deserialized).isNotNull();
        Assertions.assertThat((Comparable)deserialized.version()).isEqualTo((Object)localDataLayer.version());
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)localDataLayer);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testTokenPartitioner(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.partitioners(), SourceDSL.arbitrary().pick(Arrays.asList(3, 16, 128)), SourceDSL.arbitrary().pick(Arrays.asList(1, 4, 16)), SourceDSL.arbitrary().pick(Arrays.asList(4, 16, 64))).checkAssert((partitioner, numInstances, defaultParallelism, numCores) -> {
            CassandraRing ring = TestUtils.createRing(partitioner, numInstances);
            TokenPartitioner tokenPartitioner = new TokenPartitioner(ring, defaultParallelism.intValue(), numCores.intValue());
            Output out = KryoSerializationTests.serialize(bridge.getVersion(), tokenPartitioner);
            TokenPartitioner deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, TokenPartitioner.class);
            Assertions.assertThat((Object)deserialized).isNotNull();
            Assertions.assertThat((int)deserialized.numPartitions()).isEqualTo(tokenPartitioner.numPartitions());
            Assertions.assertThat((List)deserialized.subRanges()).hasSameSizeAs((Iterable)tokenPartitioner.subRanges());
            for (int index = 0; index < tokenPartitioner.subRanges().size(); ++index) {
                Assertions.assertThat((Object)((Range)deserialized.subRanges().get(index))).isEqualTo(tokenPartitioner.subRanges().get(index));
            }
            Assertions.assertThat((Object)deserialized.ring()).isEqualTo((Object)tokenPartitioner.ring());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCqlUdtField(CassandraBridge bridge) {
        CqlField.CqlUdt udt = bridge.udt("udt_keyspace", "udt_table").withField("c", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.timestamp()).withField("a", (CqlField.CqlType)bridge.bigint()).build();
        Output out = new Output(1024, -1);
        udt.write(out);
        out.close();
        Input in = new Input(out.getBuffer(), 0, out.position());
        CqlField.CqlUdt deserialized = (CqlField.CqlUdt)CqlField.CqlType.read((Input)in, (CassandraTypes)bridge.cassandraTypes());
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)udt);
        for (int index = 0; index < deserialized.fields().size(); ++index) {
            Assertions.assertThat((Comparable)deserialized.field(index)).isEqualTo((Object)udt.field(index));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testSslConfig(CassandraBridge bridge) {
        SslConfig config = new SslConfig.Builder().keyStorePath("keyStorePath").base64EncodedKeyStore("encodedKeyStore").keyStorePassword("keyStorePassword").keyStoreType("keyStoreType").trustStorePath("trustStorePath").base64EncodedTrustStore("encodedTrustStore").trustStorePassword("trustStorePassword").trustStoreType("trustStoreType").build();
        Output out = KryoSerializationTests.serialize(bridge.getVersion(), config);
        SslConfig deserialized = KryoSerializationTests.deserialize(bridge.getVersion(), out, SslConfig.class);
        Assertions.assertThat((String)deserialized.keyStorePath()).isEqualTo(config.keyStorePath());
        Assertions.assertThat((String)deserialized.base64EncodedKeyStore()).isEqualTo(config.base64EncodedKeyStore());
        Assertions.assertThat((String)deserialized.keyStorePassword()).isEqualTo(config.keyStorePassword());
        Assertions.assertThat((String)deserialized.keyStoreType()).isEqualTo(config.keyStoreType());
        Assertions.assertThat((String)deserialized.trustStorePath()).isEqualTo(config.trustStorePath());
        Assertions.assertThat((String)deserialized.base64EncodedTrustStore()).isEqualTo(config.base64EncodedTrustStore());
        Assertions.assertThat((String)deserialized.trustStorePassword()).isEqualTo(config.trustStorePassword());
        Assertions.assertThat((String)deserialized.trustStoreType()).isEqualTo(config.trustStoreType());
    }

    @Test
    public void testStorageTransportConfiguration() {
        StorageTransportConfiguration config = new StorageTransportConfiguration("writeBucket", "writeRegion", "readBucket", "readRegion", "prefix", new StorageCredentialPair("writeRegion", new StorageCredentials("keyId1", "secret1", "sessionToken1"), "readRegion", new StorageCredentials("keyId2", "secret2", "sessionToken2")), (Map)ImmutableMap.of((Object)"tag1", (Object)"tagVal1", (Object)"tag2", (Object)"tagVal2"));
        this.testSerDeserStorageTransportConfiguration(config);
    }

    @Test
    public void testStorageTransportConfigurationWithMultiClusters() {
        StorageTransportConfiguration config = new StorageTransportConfiguration("prefix", (Map)ImmutableMap.of((Object)"tag1", (Object)"tagVal1", (Object)"tag2", (Object)"tagVal2"), new StorageAccessConfiguration("writeRegion", "writeBucket", new StorageCredentials("keyId1", "secret1", "sessionToken1")), (Map)ImmutableMap.of((Object)"cluster1", (Object)new StorageAccessConfiguration("readRegion1", "readBucket", new StorageCredentials("keyId1", "secret1", "sessionToken1")), (Object)"cluster2", (Object)new StorageAccessConfiguration("readRegion2", "readBucket", new StorageCredentials("keyId1", "secret1", "sessionToken1"))));
        this.testSerDeserStorageTransportConfiguration(config);
    }

    @Test
    public void testMultiClusterContainer() {
        MultiClusterContainer stringContainer = new MultiClusterContainer();
        stringContainer.addAll((Map)ImmutableMap.of((Object)"cluster1", (Object)"foo", (Object)"cluster2", (Object)"bar"));
        KryoSerializationTests.testSerDeser(stringContainer, MultiClusterContainer.class);
        MultiClusterContainer bigIntContainer = new MultiClusterContainer();
        bigIntContainer.addAll((Map)ImmutableMap.of((Object)"cluster1", (Object)BigInteger.valueOf(123L), (Object)"cluster2", (Object)BigInteger.valueOf(321L)));
        KryoSerializationTests.testSerDeser(bigIntContainer, MultiClusterContainer.class);
    }

    private void testSerDeserStorageTransportConfiguration(StorageTransportConfiguration config) {
        KryoSerializationTests.testSerDeser(config, StorageTransportConfiguration.class);
    }

    private static <T> void testSerDeser(Object origin, Class<T> type) {
        T deserialized;
        try (Output out = KryoSerializationTests.serialize(CassandraVersion.FOURZERO, origin);){
            deserialized = KryoSerializationTests.deserialize(CassandraVersion.FOURZERO, out, type);
        }
        Assertions.assertThat(deserialized).isEqualTo(origin);
    }

    static {
        try {
            for (Map.Entry entry : KryoRegister.KRYO_REGISTRATORS.entrySet()) {
                Kryo kryo = new Kryo();
                KryoRegister register = (KryoRegister)((Class)entry.getValue()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                register.registerClasses(kryo);
                KRYO.put((CassandraVersion)entry.getKey(), kryo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Kryo kryo = KRYO.get(CassandraVersion.FOURZERO);
        new KryoRegister(CassandraVersion.FOURZERO).registerClasses(kryo);
        new SbwKryoRegistrator().registerClasses(kryo);
    }
}

