/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CompressionTests {
    private CassandraBridge bridge;

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#versions"})
    public void testCompressRandom(CassandraVersion version) throws IOException {
        this.bridge = CassandraBridgeFactory.get((CassandraVersion)version);
        this.testCompression(RandomUtils.randomBytes((int)4096));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#versions"})
    public void testCompressUniform(CassandraVersion version) throws IOException {
        this.bridge = CassandraBridgeFactory.get((CassandraVersion)version);
        byte[] bytes = new byte[4096];
        Arrays.fill(bytes, (byte)97);
        this.testCompression(bytes);
    }

    private void testCompression(byte[] bytes) throws IOException {
        ByteBuffer compressed = this.bridge.compress(bytes);
        ByteBuffer uncompressed = this.bridge.uncompress(compressed);
        byte[] result = new byte[uncompressed.remaining()];
        uncompressed.get(result);
        Assertions.assertThat((int)result.length).isEqualTo(bytes.length);
        Assertions.assertThat((byte[])result).isEqualTo((Object)bytes);
    }
}

