/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.reader.ReaderUtils;
import org.apache.cassandra.spark.reader.SummaryDbUtils;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IndexDbUtils {
    private IndexDbUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    @Nullable
    public static Long findDataDbOffset(@NotNull IndexSummary indexSummary, @NotNull TokenRange range, @NotNull IPartitioner partitioner, @NotNull SSTable ssTable, @NotNull Stats stats) throws IOException {
        long searchStartOffset = SummaryDbUtils.findIndexOffsetInSummary(indexSummary, partitioner, range.firstEnclosedValue());
        return IndexDbUtils.findDataDbOffset(range, partitioner, ssTable, stats, searchStartOffset);
    }

    @Nullable
    public static Long findDataDbOffset(@NotNull TokenRange range, @NotNull IPartitioner partitioner, @NotNull SSTable ssTable, @NotNull Stats stats, long searchStartOffset) throws IOException {
        try (InputStream is = ssTable.openPrimaryIndexStream();){
            Long l = IndexDbUtils.findIndexOffset(is, partitioner, range, stats, searchStartOffset);
            return l;
        }
    }

    @Nullable
    static Long findIndexOffset(@Nullable InputStream is, @NotNull IPartitioner partitioner, @NotNull TokenRange range, @NotNull Stats stats, long searchStartOffset) throws IOException {
        if (is == null) {
            return null;
        }
        try {
            DataInputStream in = new DataInputStream(is);
            ByteBufferUtils.skipFully((InputStream)in, (long)searchStartOffset);
            return IndexDbUtils.findStartOffset(in, partitioner, range, stats);
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    static long findStartOffset(@NotNull DataInputStream in, @NotNull IPartitioner partitioner, @NotNull TokenRange range, @NotNull Stats stats) throws IOException {
        BigInteger keyToken;
        long previous = 0L;
        while (IndexDbUtils.isLessThan(keyToken = IndexDbUtils.readNextToken(partitioner, in, stats), range)) {
            previous = ReaderUtils.readPosition(in);
            ReaderUtils.skipPromotedIndex(in);
        }
        assert (range.firstEnclosedValue().compareTo(keyToken) <= 0);
        return previous;
    }

    static boolean isLessThan(@NotNull BigInteger keyToken, @NotNull TokenRange range) {
        return keyToken.compareTo(range.lowerEndpoint()) <= 0;
    }

    static BigInteger readNextToken(@NotNull IPartitioner partitioner, @NotNull DataInputStream in, @NotNull Stats stats) throws IOException {
        ByteBuffer key = ByteBufferUtil.readWithShortLength((DataInput)in);
        BigInteger token = ReaderUtils.tokenToBigInteger((Token)partitioner.decorateKey(key).getToken());
        stats.readPartitionIndexDb(key.rewind(), token);
        return token;
    }
}

