/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.spark.reader.common.AbstractCompressionMetadata;
import org.apache.cassandra.spark.reader.common.BigLongArray;

public class CompressionMetadata
extends AbstractCompressionMetadata {
    private final CompressionParams parameters;
    private final double crcCheckChance;

    private CompressionMetadata(long dataLength, BigLongArray chunkOffsets, CompressionParams parameters, double crcCheckChance) {
        super(dataLength, chunkOffsets);
        this.parameters = parameters;
        this.crcCheckChance = crcCheckChance;
    }

    static CompressionMetadata fromInputStream(InputStream inStream, boolean hasCompressedLength, double crcCheckChance) throws IOException {
        DataInputStream inData = new DataInputStream(inStream);
        String compressorName = inData.readUTF();
        int optionCount = inData.readInt();
        HashMap<String, String> options = new HashMap<String, String>(optionCount);
        for (int option = 0; option < optionCount; ++option) {
            options.put(inData.readUTF(), inData.readUTF());
        }
        int chunkLength = inData.readInt();
        int minCompressRatio = Integer.MAX_VALUE;
        if (hasCompressedLength) {
            minCompressRatio = inData.readInt();
        }
        CompressionParams params = new CompressionParams(compressorName, chunkLength, minCompressRatio, options);
        long dataLength = inData.readLong();
        int chunkCount = inData.readInt();
        BigLongArray chunkOffsets = new BigLongArray(chunkCount);
        for (int chunk = 0; chunk < chunkCount; ++chunk) {
            try {
                chunkOffsets.set(chunk, inData.readLong());
                continue;
            }
            catch (EOFException exception) {
                throw new EOFException(String.format("Corrupted compression index: read %d but expected %d chunks.", chunk, chunkCount));
            }
        }
        return new CompressionMetadata(dataLength, chunkOffsets, params, crcCheckChance);
    }

    ICompressor compressor() {
        return this.parameters.getSstableCompressor();
    }

    protected int chunkLength() {
        return this.parameters.chunkLength();
    }

    protected double crcCheckChance() {
        return this.crcCheckChance;
    }
}

