/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.ext.web.codec.impl;

import o.a.c.sidecar.client.shaded.io.vertx.core.AsyncResult;
import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.Promise;
import o.a.c.sidecar.client.shaded.io.vertx.core.buffer.Buffer;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.WriteStream;
import o.a.c.sidecar.client.shaded.io.vertx.ext.web.codec.BodyCodec;
import o.a.c.sidecar.client.shaded.io.vertx.ext.web.codec.spi.BodyStream;

public class StreamingBodyCodec
implements BodyCodec<Void> {
    private final WriteStream<Buffer> stream;
    private final boolean close;
    private Throwable error;

    public StreamingBodyCodec(WriteStream<Buffer> stream) {
        this(stream, true);
    }

    public StreamingBodyCodec(WriteStream<Buffer> stream, boolean close) {
        this.stream = stream;
        this.close = close;
    }

    public void init() {
        this.stream.exceptionHandler(err -> {
            StreamingBodyCodec streamingBodyCodec = this;
            synchronized (streamingBodyCodec) {
                this.error = err;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Handler<AsyncResult<BodyStream<Void>>> handler) {
        Future<Object> result;
        StreamingBodyCodec streamingBodyCodec = this;
        synchronized (streamingBodyCodec) {
            result = this.error != null ? Future.failedFuture(this.error) : Future.succeededFuture(new BodyStream<Void>(){
                final Promise<Void> promise = Promise.promise();

                @Override
                public Future<Void> result() {
                    return this.promise.future();
                }

                @Override
                public void handle(Throwable cause) {
                    this.promise.tryFail(cause);
                }

                @Override
                public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
                    StreamingBodyCodec.this.stream.exceptionHandler((Handler)handler);
                    return this;
                }

                @Override
                public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
                    StreamingBodyCodec.this.stream.write(data, handler);
                }

                @Override
                public Future<Void> write(Buffer data) {
                    Promise<Void> promise = Promise.promise();
                    this.write(data, (Handler<AsyncResult<Void>>)promise);
                    return promise.future();
                }

                @Override
                public void end(Handler<AsyncResult<Void>> handler) {
                    if (StreamingBodyCodec.this.close) {
                        StreamingBodyCodec.this.stream.end(ar -> {
                            if (ar.succeeded()) {
                                this.promise.tryComplete();
                            } else {
                                this.promise.tryFail(ar.cause());
                            }
                            if (handler != null) {
                                handler.handle((AsyncResult<Void>)ar);
                            }
                        });
                    } else {
                        this.promise.tryComplete();
                        if (handler != null) {
                            handler.handle(Future.succeededFuture());
                        }
                    }
                }

                @Override
                public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
                    StreamingBodyCodec.this.stream.setWriteQueueMaxSize(maxSize);
                    return this;
                }

                @Override
                public boolean writeQueueFull() {
                    return StreamingBodyCodec.this.stream.writeQueueFull();
                }

                @Override
                public WriteStream<Buffer> drainHandler(Handler<Void> handler) {
                    StreamingBodyCodec.this.stream.drainHandler(handler);
                    return this;
                }
            });
        }
        handler.handle(result);
    }
}

